/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.easing;

import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.AbstractMappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtCodecException;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.util.NbtMapCodec;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.attributes.easing.EasingType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.easing.CubicBezierControls;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.easing.CubicCurve;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.TypesBuilderData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

@NullMarked
public final class CubicBezierEasingType
extends AbstractMappedEntity
implements EasingType {
    public static final NbtCodec<CubicBezierEasingType> CODEC = new NbtMapCodec<CubicBezierEasingType>(){

        @Override
        public CubicBezierEasingType decode(NBTCompound compound, PacketWrapper<?> wrapper) throws NbtCodecException {
            CubicBezierControls controls = compound.getOrThrow("cubic_bezier", CubicBezierControls.CODEC, wrapper);
            return new CubicBezierEasingType(controls);
        }

        @Override
        public void encode(NBTCompound compound, PacketWrapper<?> wrapper, CubicBezierEasingType value) throws NbtCodecException {
            compound.set("cubic_bezier", value.controls, CubicBezierControls.CODEC, wrapper);
        }
    }.codec();
    private static final int NEWTON_RAPHSON_ITERATIONS = 4;
    private final CubicBezierControls controls;
    private final CubicCurve curveX;
    private final CubicCurve curveY;

    public CubicBezierEasingType(CubicBezierControls controls) {
        this(null, controls);
    }

    @ApiStatus.Internal
    public CubicBezierEasingType(@Nullable TypesBuilderData data, CubicBezierControls controls) {
        super(data);
        this.controls = controls;
        this.curveX = controls.calcCurveX();
        this.curveY = controls.calcCurveY();
    }

    @Override
    public float apply(float x) {
        float gradient;
        float t = x;
        for (int i = 0; i < 4 && !((gradient = this.curveX.calcSampleGradient(t)) < 1.0E-5f); ++i) {
            float error = this.curveX.calcSample(t) - x;
            t -= error / gradient;
        }
        return this.curveY.calcSample(t);
    }
}

