/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.particle.data;

import ua.valeriishymchuk.simpleitemgenerator.packetevents.manager.server.ServerVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.color.AlphaColor;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBT;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.nbt.NBTCompound;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.particle.data.ParticleData;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.ClientVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.PacketWrapper;

public class ParticleColorData
extends ParticleData {
    private AlphaColor color;

    public ParticleColorData(int color) {
        this(new AlphaColor(color));
    }

    public ParticleColorData(AlphaColor color) {
        this.color = color;
    }

    public static ParticleColorData read(PacketWrapper<?> wrapper) {
        int color = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5) ? wrapper.readInt() : 0;
        return new ParticleColorData(color);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleColorData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            wrapper.writeInt(data.color.asRGB());
        }
    }

    public static ParticleColorData decode(NBTCompound compound, ClientVersion version) {
        AlphaColor argb;
        if (version.isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
            NBT colorTag = compound.getTagOrThrow("color");
            argb = AlphaColor.decode(colorTag, version);
        } else {
            argb = AlphaColor.WHITE;
        }
        return new ParticleColorData(argb);
    }

    public static void encode(ParticleColorData data, ClientVersion version, NBTCompound compound) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
            compound.setTag("color", AlphaColor.encode(data.color, version));
        }
    }

    public int getColor() {
        return this.color.asRGB();
    }

    public void setColor(int color) {
        this.color = new AlphaColor(color);
    }

    public void setAlphaColor(AlphaColor color) {
        this.color = color;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

