/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.type;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.entity.type.EntityType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.mapper.AbstractMappedEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.player.ClientVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.mappings.TypesBuilderData;

public class StaticEntityType
extends AbstractMappedEntity
implements EntityType {
    private final Optional<EntityType> parent;
    private final Map<EntityType, Boolean> parents;
    @Nullable
    private TypesBuilderData legacyData;

    @ApiStatus.Internal
    public StaticEntityType(@Nullable TypesBuilderData data, @Nullable EntityType parent) {
        super(data);
        this.parent = Optional.ofNullable(parent);
        this.parents = new IdentityHashMap<EntityType, Boolean>();
        this.parents.put(this, true);
        while (parent != null) {
            this.parents.put(parent, true);
            parent = parent.getParent().orElse(null);
        }
    }

    StaticEntityType setLegacyData(@Nullable TypesBuilderData legacyData) {
        this.legacyData = legacyData;
        return this;
    }

    @Override
    public boolean isInstanceOf(EntityType parent) {
        return parent != null && this.parents.containsKey(parent);
    }

    @Override
    public Optional<EntityType> getParent() {
        return this.parent;
    }

    @Override
    public int getLegacyId(ClientVersion version) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_14)) {
            return -1;
        }
        if (this.legacyData != null) {
            return this.legacyData.getId(version);
        }
        throw new UnsupportedOperationException();
    }
}

