/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.io.packetevents;

import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ua.valeriishymchuk.simpleitemgenerator.io.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import ua.valeriishymchuk.simpleitemgenerator.io.packetevents.util.SpigotConversionUtil;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.PacketEvents;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.PacketListenerPriority;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.SimplePacketListenerAbstract;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.UserConnectEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.UserDisconnectEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.UserLoginEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.simple.PacketConfigReceiveEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.simple.PacketConfigSendEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.simple.PacketLoginSendEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.simple.PacketPlayReceiveEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.event.simple.PacketPlaySendEvent;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.packettype.PacketType;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.world.states.type.StateTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.util.TimeStampMode;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.play.server.WrapperPlayServerBlockChange;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;

public class PacketEventsPlugin
extends JavaPlugin {
    public void onLoad() {
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PacketEvents.getAPI().getSettings().debug(false).checkForUpdates(true).timeStampMode(TimeStampMode.MILLIS).reEncodeByDefault(true);
        PacketEvents.getAPI().init();
        SimplePacketListenerAbstract listener = new SimplePacketListenerAbstract(PacketListenerPriority.HIGH){

            @Override
            public void onPacketLoginSend(PacketLoginSendEvent event) {
            }

            @Override
            public void onPacketConfigReceive(PacketConfigReceiveEvent event) {
            }

            @Override
            public void onPacketConfigSend(PacketConfigSendEvent event) {
            }

            @Override
            public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
                WrapperPlayClientInteractEntity interaction;
                if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY && (interaction = new WrapperPlayClientInteractEntity(event)).getAction() == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                    Player player = (Player)event.getPlayer();
                    WrapperPlayServerBlockChange blockChange = new WrapperPlayServerBlockChange(SpigotConversionUtil.fromBukkitLocation(player.getLocation()).getPosition().toVector3i().subtract(0, 1, 0), StateTypes.COAL_BLOCK.createBlockState().getGlobalId());
                    event.getUser().sendPacket(blockChange);
                }
            }

            @Override
            public void onPacketPlaySend(PacketPlaySendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.BLOCK_CHANGE) {
                    WrapperPlayServerBlockChange bc = new WrapperPlayServerBlockChange(event);
                    ((Player)event.getPlayer()).sendMessage("Type: " + bc.getBlockState().getType().getName());
                } else if (event.getPacketType() == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
                    WrapperPlayServerSystemChatMessage wrapperPlayServerSystemChatMessage = new WrapperPlayServerSystemChatMessage(event);
                }
            }

            @Override
            public void onUserConnect(UserConnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " connected...");
            }

            @Override
            public void onUserLogin(UserLoginEvent event) {
                PacketEvents.getAPI().getLogManager().debug("You logged in! User name: " + event.getUser().getProfile().getName());
            }

            @Override
            public void onUserDisconnect(UserDisconnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " disconnected...");
            }
        };
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }
}

