/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.entity;

import io.vavr.CheckedRunnable;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinkedHashMap;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.common.config.tools.ConfigParsingHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.item.RawItem;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectedRepresentations;
import ua.valeriishymchuk.simpleitemgenerator.common.regex.RegexUtils;
import ua.valeriishymchuk.simpleitemgenerator.common.time.TimeTokenParser;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.ClickAt;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.ClickButton;
import ua.valeriishymchuk.simpleitemgenerator.common.version.FeatureSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SigFeatureTag;
import ua.valeriishymchuk.simpleitemgenerator.entity.CustomItemEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.CustomItemsStorageEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.UsageEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.result.ConfigLoadResultEntity;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.ConfigSerializable;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public class MainConfigEntity {
    @Setting(nodeFromParent=true)
    private CustomItemsStorageEntity items = new CustomItemsStorageEntity(MainConfigEntity::initConfigDefaults);
    private String placeholderUpdatePeriod = "10t";
    private String itemUpdatePeriod = "1t";
    private transient Lazy<Long> lazyItemUpdatePeriod = Lazy.of(this::getItemUpdatePeriod0);
    private transient Lazy<Long> lazyPlaceholderUpdatePeriod = Lazy.of(this::getPlaceholderUpdatePeriod0);
    private boolean checkForUpdates = true;
    private boolean sendWelcomeMessage = true;
    private boolean sendInvalidItemMessage = true;
    private boolean debug = false;
    private boolean tickDebug = false;
    private Map<String, Boolean> features = Collections.emptyMap();
    private transient Set<SigFeatureTag> lazyFeatures = null;

    public Set<SigFeatureTag> getFeatures() {
        if (this.lazyFeatures == null) {
            this.lazyFeatures = this.getFeatures0();
        }
        return this.lazyFeatures;
    }

    private Set<SigFeatureTag> getFeatures0() throws InvalidConfigurationException {
        HashSet<SigFeatureTag> featureTags = new HashSet<SigFeatureTag>();
        Arrays.stream(SigFeatureTag.values()).filter(SigFeatureTag::isEnabledByDefault).forEach(featureTags::add);
        Map<SigFeatureTag, Boolean> map = this.features.entrySet().stream().map(entry -> {
            SigFeatureTag sigFeatureTag = MainConfigEntity.parse((String)entry.getKey()).mapError(InvalidConfigurationException.Lambda.path("features")).getOrElseGet(e -> {
                throw e;
            });
            return Tuple.of(sigFeatureTag, (Boolean)entry.getValue());
        }).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        map.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).forEach(entry -> featureTags.remove(entry.getKey()));
        map.entrySet().stream().filter(Map.Entry::getValue).forEach(entry -> featureTags.add((SigFeatureTag)((Object)((Object)entry.getKey()))));
        return featureTags;
    }

    private static Validation<InvalidConfigurationException, SigFeatureTag> parse(String value) {
        return ConfigParsingHelper.parseEnum(SigFeatureTag.class, value, "feature tag", value);
    }

    public static String serializeEnchantment(Enchantment enchantment) {
        if (!FeatureSupport.NAMESPACED_ENCHANTMENTS_SUPPORT) {
            return enchantment.getName();
        }
        return ReflectedRepresentations.Enchantment.getKyoriKey(enchantment).asString();
    }

    public static UsageEntity.Command deserializeCommand(String rawCommand) throws IllegalArgumentException {
        return MainConfigEntity.prepareCommand(rawCommand).replace(command -> RegexUtils.replaceAll(CustomItemEntity.MINIMESSAGE_COMMAND_PLACEHOLDER.matcher((CharSequence)command), commandMatcher -> {
            String rawMessage = commandMatcher.group("placeholder");
            return KyoriHelper.mimiMessageToJson(rawMessage);
        }));
    }

    private static UsageEntity.Command prepareCommand(String rawCommand) throws InvalidConfigurationException {
        Matcher matcher = CustomItemEntity.COMMAND_EXECUTION_PATTERN.matcher(rawCommand);
        if (!matcher.find()) {
            throw InvalidConfigurationException.format("Invalid command: <white>%s</white>. Example command: <white>[console] msg %%player%% hello</white>", rawCommand);
        }
        String command = matcher.group("command");
        boolean isConsoleSender = matcher.group("sender").equals("console");
        return new UsageEntity.Command(isConsoleSender, command);
    }

    private static List<UsageEntity.Command> deserializeCommands(List<String> rawCommands) {
        return rawCommands.stream().map(MainConfigEntity::deserializeCommand).collect(Collectors.toList());
    }

    private static List<UsageEntity.Command> deserializeCommands(String ... rawCommands) {
        return MainConfigEntity.deserializeCommands(Arrays.asList(rawCommands));
    }

    private static List<UsageEntity.Command> deserializeConfigCommands(List<String> rawCommands) {
        return rawCommands.stream().map(MainConfigEntity::prepareCommand).collect(Collectors.toList());
    }

    private static List<UsageEntity.Command> deserializeConfigCommands(String ... rawCommands) {
        return MainConfigEntity.deserializeConfigCommands(Arrays.asList(rawCommands));
    }

    public static String serializeCommand(UsageEntity.Command command) {
        String prepend = command.isExecuteAsConsole() ? "[console]" : "[player]";
        return prepend + " " + command.getCommand();
    }

    private static List<String> serializeCommands(List<UsageEntity.Command> commands) {
        return commands.stream().map(MainConfigEntity::serializeCommand).collect(Collectors.toList());
    }

    private static Map<String, CustomItemEntity> initConfigDefaults() {
        RawItem preparedItem = new RawItem("DIAMOND", "<red><bold>Cool diamond%id%", Arrays.asList("<green>First lore", "<red>Second lore"), null, null, Arrays.asList(ItemFlag.HIDE_ATTRIBUTES.name(), ItemFlag.HIDE_ENCHANTS.name()), HashMap.of(MainConfigEntity.serializeEnchantment(Enchantment.LUCK), 1).toJavaMap(), Collections.emptyList(), null, null, null);
        if (FeatureSupport.CMD_SUPPORT) {
            preparedItem = preparedItem.withCmd(1);
        }
        RawItem exampleItem = preparedItem;
        UsageEntity singleCommandUsage = UsageEntity.DEFAULT.withCommands(MainConfigEntity.deserializeConfigCommands("[console] say %player% hi, you clicked item"));
        UsageEntity multipleCommandUsage = UsageEntity.DEFAULT.withCommands(MainConfigEntity.deserializeConfigCommands("[console] tellraw %player% %minimessage_<red>I am using minimessage in placeholder%", "[console] tellraw %player% %minimessage_<bold><green>So you don't have to use json%"));
        UsageEntity example3 = multipleCommandUsage.withCooldownFreezeTimeMillis(TimeTokenParser.parse("1s")).withCooldownMillis(TimeTokenParser.parse("5s")).withOnCooldown(MainConfigEntity.deserializeConfigCommands("[console] say %player% wait %time_s.2f%s"));
        UsageEntity example4 = example3.withCommands(MainConfigEntity.deserializeConfigCommands("[console] say %player% you used item", "[player] open_some_menu")).withOnCooldown(MainConfigEntity.deserializeConfigCommands("[console] say %player% wait %time_s.2f%s")).withPredicates(Collections.singletonList(ClickButton.LEFT.asType())).withCancel(false);
        UsageEntity example5 = multipleCommandUsage.withPredicates(Collections.singletonList(ClickAt.PLAYER.asType())).withCooldownMillis(TimeTokenParser.parse("3h5m3s200"));
        UsageEntity example6 = example5.withPredicates(Collections.singletonList(ClickButton.LEFT.asType().withAt(ClickAt.AIR)));
        UsageEntity example7 = example6.withCooldownMillis(0L);
        UsageEntity example8 = example7.withPredicates(Arrays.asList(ClickButton.LEFT.asType().withAt(ClickAt.AIR), ClickAt.BLOCK.asType()));
        AtomicInteger ai = new AtomicInteger();
        return ((LinkedHashMap)LinkedHashMap.of("item0", Collections.emptyList(), "item1", Collections.singletonList(singleCommandUsage), "item2", Collections.singletonList(multipleCommandUsage), "item3", Collections.singletonList(example3), "item4", Collections.singletonList(example4), "item5", Collections.singletonList(example5), "item6", Collections.singletonList(example6), "item7", Collections.singletonList(example7), "item8", Collections.singletonList(example8), "item9", Arrays.asList(example8, example8.withPredicates(Collections.singletonList(ClickAt.ENTITY.asType())).withCommands(MainConfigEntity.deserializeConfigCommands("[console] tellraw %minimessage_<green>You clicked at entity%")))).mapValues(usage -> CustomItemEntity.of(exampleItem.replace("%id%", "" + ai.getAndIncrement()), (List<UsageEntity>)usage))).toJavaMap();
    }

    public long getPlaceholderUpdatePeriod() {
        return this.lazyPlaceholderUpdatePeriod.get();
    }

    public long getPlaceholderUpdatePeriod0() {
        return TimeTokenParser.parse(this.placeholderUpdatePeriod);
    }

    public long getItemUpdatePeriod() {
        return this.lazyItemUpdatePeriod.get();
    }

    public long getItemUpdatePeriod0() {
        return TimeTokenParser.parse(this.itemUpdatePeriod);
    }

    public ConfigLoadResultEntity init() throws InvalidConfigurationException {
        ArrayList<InvalidConfigurationException> configErrors = new ArrayList<InvalidConfigurationException>();
        this.initSafely(this::getFeatures).peek(configErrors::add);
        return new ConfigLoadResultEntity(this.items.init(), configErrors);
    }

    private Option<InvalidConfigurationException> initSafely(CheckedRunnable function) {
        try {
            function.run();
            return Option.none();
        }
        catch (Throwable e) {
            if (e instanceof InvalidConfigurationException) {
                return Option.of((InvalidConfigurationException)e);
            }
            return Option.of(InvalidConfigurationException.unhandledException(e));
        }
    }

    @Generated
    public CustomItemsStorageEntity getItems() {
        return this.items;
    }

    @Generated
    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    @Generated
    public boolean isSendWelcomeMessage() {
        return this.sendWelcomeMessage;
    }

    @Generated
    public boolean isSendInvalidItemMessage() {
        return this.sendInvalidItemMessage;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public boolean isTickDebug() {
        return this.tickDebug;
    }
}

