/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.entity;

import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.HashSet;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.math.LongRange;
import org.bukkit.Material;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.CompoundBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.Component;
import ua.valeriishymchuk.simpleitemgenerator.common.config.DefaultLoader;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.common.config.tools.ConfigParsingHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.cooldown.CooldownType;
import ua.valeriishymchuk.simpleitemgenerator.common.item.HeadTexture;
import ua.valeriishymchuk.simpleitemgenerator.common.item.HeadTextureApplier;
import ua.valeriishymchuk.simpleitemgenerator.common.item.ItemPropertyType;
import ua.valeriishymchuk.simpleitemgenerator.common.item.NBTCustomItem;
import ua.valeriishymchuk.simpleitemgenerator.common.item.RawItem;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.nbt.NBTConverter;
import ua.valeriishymchuk.simpleitemgenerator.common.support.ItemsAdderSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.support.NexoSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.support.OraxenSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.support.WorldGuardSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.text.StringSimilarityUtils;
import ua.valeriishymchuk.simpleitemgenerator.common.time.TimeTokenParser;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.Predicate;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.ClickAt;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.ClickButton;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.SlotPredicate;
import ua.valeriishymchuk.simpleitemgenerator.entity.MainConfigEntity;
import ua.valeriishymchuk.simpleitemgenerator.entity.UsageEntity;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.NBT;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.iface.ReadWriteNBT;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurationNode;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.ConfigSerializable;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.serialize.SerializationException;

@ConfigSerializable
public class CustomItemEntity {
    public static final Pattern MINIMESSAGE_COMMAND_PLACEHOLDER = Pattern.compile("%minimessage_(?<placeholder>.+)%");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%(?<placeholder>\\S+)%");
    public static final Pattern COMMAND_EXECUTION_PATTERN = Pattern.compile("\\[(?<sender>player|console)] (?<command>.*)");
    private static final Pattern SINGLE_PREDICATE_PATTERN = Pattern.compile("\\[(?<enum>" + PredicateType.getPattern() + ")] (?<type>.*)");
    private static final Pattern ITEM_LINK_PATTERN = Pattern.compile("\\[(?<linktype>.+)] (?<link>.*)");
    private ConfigurationNode item;
    private ConfigurationNode usage;
    private CompoundBinaryTag nbt;
    private Boolean isIngredient;
    private Boolean canBePutInInventory;
    private Boolean removeOnDeath;
    private Boolean isPlain;
    private Boolean canMove;
    private Boolean autoUpdate;
    private Set<String> updateOnly;
    private transient List<UsageEntity> usages;
    private transient ItemStack itemStack;
    private transient Boolean hasPlaceholders;
    private transient Option<HeadTexture> headTexture;
    private transient Boolean hasTick;
    private transient Set<ItemPropertyType> propertiesToUpdate;

    public CustomItemEntity(ConfigurationNode item, ConfigurationNode usage, CompoundBinaryTag nbt, Boolean isIngredient, Boolean canBePutInInventory, Boolean removeOnDeath, Boolean isPlain, Boolean canMove, Boolean autoUpdate, Set<String> updateOnly) {
        this.item = item;
        this.usage = usage;
        this.nbt = nbt;
        this.isIngredient = isIngredient;
        this.canBePutInInventory = canBePutInInventory;
        this.removeOnDeath = removeOnDeath;
        this.isPlain = isPlain;
        this.canMove = canMove;
        this.autoUpdate = autoUpdate;
        this.updateOnly = updateOnly;
    }

    private static ConfigurationNode createNode() {
        return DefaultLoader.yaml().createNode();
    }

    public Set<ItemPropertyType> getPropertiesToUpdate() {
        if (this.propertiesToUpdate == null) {
            this.propertiesToUpdate = this.getPropertiesToUpdate0();
        }
        return this.propertiesToUpdate;
    }

    private Set<ItemPropertyType> getPropertiesToUpdate0() {
        boolean isEmpty;
        boolean bl = isEmpty = this.updateOnly == null || this.updateOnly.isEmpty();
        if (isEmpty) {
            return Arrays.stream(ItemPropertyType.values()).collect(Collectors.toSet());
        }
        return this.updateOnly.stream().map(CustomItemEntity::parseItemProperty).collect(Collectors.toSet());
    }

    private static ItemPropertyType parseItemProperty(String raw) throws InvalidConfigurationException {
        return ConfigParsingHelper.parseEnum(ItemPropertyType.class, raw, "cooldown type", "update-only").get();
    }

    public boolean hasTick() {
        if (this.hasTick == null) {
            this.hasTick = this.hasTick0();
        }
        return this.hasTick;
    }

    public boolean hasTick0() {
        return this.getUsages().stream().flatMap(e -> e.getPredicates().stream()).anyMatch(p -> !p.getTimeTick().isEmpty());
    }

    public Option<HeadTexture> getHeadTexture() {
        if (this.headTexture == null) {
            this.headTexture = this.getHeadTexture0();
        }
        return this.headTexture;
    }

    private Option<HeadTexture> getHeadTexture0() {
        if (!this.item.isMap()) {
            return Option.none();
        }
        if (!this.item.hasChild("head-texture")) {
            return Option.none();
        }
        ConfigurationNode headTextureNode = this.item.node("head-texture");
        if (headTextureNode.isMap() || headTextureNode.isList()) {
            throw InvalidConfigurationException.nestedPath("Should be a scalar", "item", "head-texture");
        }
        HeadTexture texture = HeadTexture.fromString(headTextureNode.getString());
        return Option.some(texture);
    }

    public boolean isIngredient() {
        if (this.isPlainItem()) {
            return true;
        }
        if (this.isIngredient == null) {
            return false;
        }
        return this.isIngredient;
    }

    public boolean canBePutInInventory() {
        if (this.isPlainItem()) {
            return true;
        }
        if (this.canBePutInInventory == null) {
            return false;
        }
        return this.canBePutInInventory;
    }

    public boolean autoUpdate() {
        if (this.autoUpdate == null) {
            return true;
        }
        return this.autoUpdate;
    }

    public boolean removeOnDeath() {
        if (this.isPlainItem()) {
            return false;
        }
        if (this.removeOnDeath == null) {
            return false;
        }
        return this.removeOnDeath;
    }

    public boolean isPlainItem() {
        if (this.isPlain == null) {
            return false;
        }
        return this.isPlain;
    }

    public boolean canMove() {
        if (this.isPlainItem()) {
            return true;
        }
        if (this.canMove == null) {
            return true;
        }
        return this.canMove;
    }

    public static CustomItemEntity of(ItemStack item, List<UsageEntity> usages) {
        return new CustomItemEntity(CustomItemEntity.serializeItemStack(item), CustomItemEntity.serializeUsages(usages), null, null, null, null, null, null, null, null);
    }

    public static CustomItemEntity of(RawItem item, List<UsageEntity> usages) {
        return new CustomItemEntity(CustomItemEntity.createNode().set(item), CustomItemEntity.serializeUsages(usages), null, null, null, null, null, null, null, null);
    }

    private static ConfigurationNode serializeItemStack(ItemStack item) {
        Integer cmd;
        ConfigurationNode node = CustomItemEntity.createNode();
        ItemMeta meta = item.getItemMeta();
        Material material = item.getType();
        RawItem rawItem = new RawItem(material.name(), (String)Option.of(meta.displayName()).map(KyoriHelper::convert).map(KyoriHelper::toJson).map(KyoriHelper::jsonToMiniMessage).getOrNull(), Option.of(meta.lore()).getOrElse(List.of()).stream().map(KyoriHelper::convert).map(KyoriHelper::toJson).map(KyoriHelper::jsonToMiniMessage).toList(), null, meta.isUnbreakable(), new ArrayList<String>(meta.getItemFlags().stream().map(Enum::name).collect(Collectors.toList())), ((io.vavr.collection.HashMap)io.vavr.collection.HashMap.ofAll(meta.getEnchants()).mapKeys(MainConfigEntity::serializeEnchantment)).toJavaMap(), Collections.emptyList(), null, null, null);
        Integer n = cmd = meta.hasCustomModelData() ? Integer.valueOf(meta.getCustomModelData()) : null;
        if (cmd != null) {
            rawItem = rawItem.withCmd(cmd);
        }
        node.set(RawItem.class, rawItem);
        return node;
    }

    private static ConfigurationNode serializeUsages(List<UsageEntity> usages) {
        ConfigurationNode node = CustomItemEntity.createNode();
        if (usages.isEmpty()) {
            return node;
        }
        if (usages.size() == 1) {
            return CustomItemEntity.serializeUsage(usages.get(0));
        }
        return node.set(usages.stream().map(CustomItemEntity::serializeUsage).map(ConfigurationNode::raw).collect(Collectors.toList()));
    }

    private static ConfigurationNode serializeUsage(UsageEntity usage) {
        boolean isCommandsOnly;
        boolean isEmpty;
        ConfigurationNode node = CustomItemEntity.createNode();
        boolean bl = isEmpty = !usage.isCancel() && usage.getCommands().isEmpty() && usage.getOnCooldown().isEmpty() && usage.getPredicates().isEmpty();
        if (isEmpty) {
            return node;
        }
        boolean bl2 = isCommandsOnly = !usage.getCommands().isEmpty() && usage.getOnCooldown().isEmpty() && usage.getPredicates().isEmpty() && usage.getCooldownMillis() == 0L && usage.getCooldownFreezeTimeMillis() == 0L;
        if (isCommandsOnly) {
            if (usage.getCommands().size() == 1) {
                return CustomItemEntity.serializeCommand(usage.getCommands().get(0));
            }
            return node.set(usage.getCommands().stream().map(CustomItemEntity::serializeCommand).map(ConfigurationNode::raw).collect(Collectors.toList()));
        }
        if (usage.getCooldownMillis() > 0L) {
            node.node("cooldown").set(TimeTokenParser.parse(usage.getCooldownMillis()));
        }
        if (usage.getCooldownFreezeTimeMillis() > 0L) {
            node.node("freezetime").set(TimeTokenParser.parse(usage.getCooldownFreezeTimeMillis()));
        }
        if (!usage.isCancel()) {
            node.node("cancel").set(false);
        }
        node.node("commands").set(CustomItemEntity.serializeCommands(usage.getCommands()).raw());
        node.node("on-cooldown").set(CustomItemEntity.serializeCommands(usage.getOnCooldown()).raw());
        node.node("predicate").set(CustomItemEntity.serializePredicates(usage.getPredicates()).raw());
        return node;
    }

    private static ConfigurationNode serializePredicates(List<Predicate> predicate) {
        ConfigurationNode node = CustomItemEntity.createNode();
        if (predicate.isEmpty()) {
            return node;
        }
        if (predicate.size() == 1) {
            return CustomItemEntity.serializePredicate(predicate.get(0));
        }
        node.set(predicate.stream().map(CustomItemEntity::serializePredicate).map(ConfigurationNode::raw).collect(Collectors.toList()));
        return node;
    }

    private static ConfigurationNode serializePredicate(Predicate clickType) {
        boolean hasAtOrSide = clickType.getAt().isDefined() ^ clickType.getButton().isDefined();
        if (hasAtOrSide) {
            boolean isAt = clickType.getAt().isDefined();
            String prepend = isAt ? "at" : "button";
            String value = (String)clickType.getAt().map(Enum::name).orElse(clickType.getButton().map(Enum::name)).map(String::toLowerCase).get();
            ConfigurationNode node = CustomItemEntity.createNode();
            node.set("[" + prepend + "] " + value);
            return node;
        }
        ConfigurationNode node = CustomItemEntity.createNode();
        node.node("at").set(clickType.getAt().map(Enum::name).map(String::toLowerCase).get());
        node.node("button").set(clickType.getButton().map(Enum::name).map(String::toLowerCase).get());
        return node;
    }

    private static ConfigurationNode serializeCommands(List<UsageEntity.Command> commands) {
        ConfigurationNode node = CustomItemEntity.createNode();
        if (commands.isEmpty()) {
            return node;
        }
        if (commands.size() == 1) {
            return CustomItemEntity.serializeCommand(commands.get(0));
        }
        node.set(commands.stream().map(CustomItemEntity::serializeCommand).map(ConfigurationNode::raw).collect(Collectors.toList()));
        return node;
    }

    private static ConfigurationNode serializeCommand(UsageEntity.Command command) {
        ConfigurationNode node = CustomItemEntity.createNode();
        node.set(MainConfigEntity.serializeCommand(command));
        return node;
    }

    public boolean hasPlaceHolders() throws InvalidConfigurationException {
        if (this.hasPlaceholders == null) {
            this.hasPlaceholders = this.hasPlaceholders0();
        }
        return this.hasPlaceholders;
    }

    private boolean hasPlaceholders0() throws InvalidConfigurationException {
        ItemStack item = this.getItemStack();
        Value displayOpt = Option.of(item.getItemMeta().displayName()).map(KyoriHelper::convert);
        List<Component> lore = Option.of(item.getItemMeta().lore()).getOrElse(List.of()).stream().map(KyoriHelper::convert).toList();
        return Stream.of(displayOpt.toJavaList(), lore).flatMap(Collection::stream).map(KyoriHelper::toJson).map(PLACEHOLDER_PATTERN::matcher).anyMatch(Matcher::find);
    }

    public List<UsageEntity> getUsages() throws InvalidConfigurationException {
        if (this.usages == null) {
            this.usages = this.parseUsages();
        }
        return this.usages;
    }

    public ItemStack getItemStack() throws InvalidConfigurationException {
        if (this.itemStack == null) {
            this.itemStack = this.parseItem();
            this.getHeadTexture().peek(h -> {
                if (h.getValue().contains("%player%")) {
                    return;
                }
                this.itemStack = HeadTextureApplier.apply(h, this.itemStack, s -> s);
            });
            if (this.nbt != null) {
                NBT.modify(this.itemStack, itemNbt -> {
                    ReadWriteNBT nbt2 = NBTConverter.toNBTApi(this.nbt);
                    itemNbt.mergeCompound(nbt2);
                });
            }
            int signature = this.itemStack.serialize().hashCode();
            NBTCustomItem.setSignature(this.itemStack, signature);
        }
        return this.itemStack.clone();
    }

    public int getSignature() {
        if (this.itemStack == null) {
            this.getItemStack();
        }
        return NBTCustomItem.getSignature(this.itemStack).get();
    }

    private ItemStack parseItem() throws InvalidConfigurationException {
        try {
            ItemStack item;
            if (this.item == null || this.item.isNull()) {
                throw new InvalidConfigurationException("Property is not defined");
            }
            if (this.item.isMap()) {
                return this.item.get(RawItem.class).bake();
            }
            String rawItem = this.item.getString();
            Matcher matcher = ITEM_LINK_PATTERN.matcher(rawItem);
            if (!matcher.find()) {
                throw InvalidConfigurationException.format("Invalid item: <white>%s</white>", rawItem);
            }
            String linkType = matcher.group("linktype");
            String link = matcher.group("link");
            if (linkType.equals("itemsadder")) {
                try {
                    item = ItemsAdderSupport.getItem(link);
                }
                catch (Exception e) {
                    if (!ItemsAdderSupport.isPluginEnabled()) {
                        throw new InvalidConfigurationException("Plugin ItemsAdder is not enabled!");
                    }
                    throw new InvalidConfigurationException("Can't find ItemsAdder item <white>" + link + "</white>");
                }
            } else if (linkType.equals("oraxen")) {
                try {
                    item = OraxenSupport.getItem(link);
                }
                catch (Exception e) {
                    if (!OraxenSupport.isPluginEnabled()) {
                        throw new InvalidConfigurationException("Plugin Oraxen is not enabled!");
                    }
                    throw new InvalidConfigurationException("Can't find Oraxen item <white>" + link + "</white>");
                }
            } else if (linkType.equals("nexo")) {
                try {
                    item = NexoSupport.getItem(link);
                }
                catch (Exception e) {
                    if (!NexoSupport.isPluginEnabled()) {
                        throw new InvalidConfigurationException("Plugin Nexo is not enabled!");
                    }
                    throw new InvalidConfigurationException("Can't find Nexo item <white>" + link + "</white>");
                }
            } else {
                throw InvalidConfigurationException.format("Invalid link type: <white>[%s]</white>[", linkType);
            }
            return item;
        }
        catch (Exception e) {
            throw InvalidConfigurationException.path("item", e);
        }
    }

    private List<UsageEntity> parseUsages() throws InvalidConfigurationException {
        if (this.usage.isNull()) {
            return List.of();
        }
        AtomicInteger increment = new AtomicInteger();
        try {
            if (this.usage.isList()) {
                List<ConfigurationNode> usages = this.usage.getList(ConfigurationNode.class);
                ArrayList<UsageEntity> result = new ArrayList<UsageEntity>(usages.size());
                for (ConfigurationNode node : usages) {
                    UsageEntity usage = this.parseUsage(node);
                    increment.incrementAndGet();
                    result.add(usage);
                }
                return result;
            }
        }
        catch (Exception e) {
            throw InvalidConfigurationException.path("usage, " + increment.get(), e);
        }
        try {
            return Collections.singletonList(this.parseUsage(this.usage));
        }
        catch (Exception e) {
            throw InvalidConfigurationException.path("usage", e);
        }
    }

    private static long parseTime(ConfigurationNode node) throws InvalidConfigurationException {
        if (node.isNull()) {
            return 0L;
        }
        return Try.ofSupplier(node::getString).mapTry(TimeTokenParser::parse).getOrElseThrow(ex -> InvalidConfigurationException.path(node.key().toString(), ex));
    }

    private UsageEntity parseUsage(ConfigurationNode node) throws InvalidConfigurationException, SerializationException {
        List<Predicate> predicate;
        UsageEntity.Consume consume;
        CooldownType cooldownType;
        if (!node.isMap()) {
            return new UsageEntity(Collections.emptyList(), 0L, 0L, true, UsageEntity.Consume.NONE, Collections.emptyList(), this.parseCommands(node, true), CooldownType.PER_ITEM);
        }
        long cooldown = CustomItemEntity.parseTime(node.node("cooldown"));
        long freezeTime = CustomItemEntity.parseTime(node.node("freezetime"));
        if (node.node("cooldown-type").isNull()) {
            cooldownType = CooldownType.PER_ITEM;
        } else {
            String rawType;
            try {
                rawType = node.node("cooldown-type").getString();
            }
            catch (IllegalArgumentException e2) {
                throw InvalidConfigurationException.path("cooldown-type", e2);
            }
            cooldownType = rawType != null ? CustomItemEntity.parseCooldownType(rawType) : CooldownType.PER_ITEM;
        }
        boolean shouldCancelEvent = node.node("cancel").getBoolean(true);
        ConfigurationNode consumeNode = node.node("consume");
        if (consumeNode.isNull()) {
            consume = UsageEntity.Consume.NONE;
        } else {
            boolean isNumber;
            Integer number;
            if (consumeNode.isMap() || consumeNode.isList()) {
                throw InvalidConfigurationException.path("consume", new InvalidConfigurationException("Property can't be a list or map"));
            }
            String rawConsume = consumeNode.getString();
            try {
                number = Integer.parseInt(rawConsume);
            }
            catch (NumberFormatException ignored) {
                number = null;
            }
            boolean bl = isNumber = number != null;
            if (isNumber) {
                consume = new UsageEntity.Consume(UsageEntity.ConsumeType.AMOUNT, number);
            } else {
                String upper = rawConsume.toUpperCase();
                Set allowed = ((HashSet)HashSet.of(UsageEntity.ConsumeType.values()).reject(type -> io.vavr.collection.List.of(UsageEntity.ConsumeType.AMOUNT, UsageEntity.ConsumeType.NONE).contains((UsageEntity.ConsumeType)((Object)type)))).toJavaSet();
                UsageEntity.ConsumeType type2 = Try.ofSupplier(() -> UsageEntity.ConsumeType.valueOf(upper)).filter(allowed::contains).mapFailure(API.Case(API.$(), e -> {
                    List<String> suggestions = StringSimilarityUtils.getSuggestions(upper, allowed.stream().map(Enum::name));
                    return InvalidConfigurationException.unknownOption("consume type", rawConsume, suggestions);
                })).getOrElseThrow(e -> InvalidConfigurationException.path("consume", e));
                consume = new UsageEntity.Consume(type2, 0);
            }
        }
        ConfigurationNode predicateNode = node.node("predicate");
        if (predicateNode.isNull()) {
            predicate = Collections.emptyList();
        } else {
            if (predicateNode.isList()) {
                AtomicInteger increment = new AtomicInteger();
                try {
                    predicate = new ArrayList();
                    List<ConfigurationNode> predicateNodeList = predicateNode.getList(ConfigurationNode.class);
                    for (ConfigurationNode prediacteNode : predicateNodeList) {
                        Predicate predicateResult = this.parsePredicate(prediacteNode);
                        increment.incrementAndGet();
                        predicate.add(predicateResult);
                    }
                }
                catch (Exception e3) {
                    throw InvalidConfigurationException.path("predicate, " + increment.get(), e3);
                }
            }
            try {
                predicate = Collections.singletonList(this.parsePredicate(predicateNode));
            }
            catch (Exception e4) {
                throw InvalidConfigurationException.path("predicate", e4);
            }
        }
        List<UsageEntity.Command> onCooldown = this.parseCommands(node.node("on-cooldown"));
        List<UsageEntity.Command> commands = this.parseCommands(node.node("commands"));
        return new UsageEntity(predicate, cooldown, freezeTime, shouldCancelEvent, consume, onCooldown, commands, cooldownType);
    }

    private List<UsageEntity.Command> parseCommands(ConfigurationNode node) throws InvalidConfigurationException {
        try {
            return this.parseCommands(node, false);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    private List<UsageEntity.Command> parseCommands(ConfigurationNode node, boolean ignoreKey) throws InvalidConfigurationException, SerializationException {
        if (node.isNull()) {
            return Collections.emptyList();
        }
        AtomicInteger increment = new AtomicInteger();
        try {
            if (node.isList()) {
                return node.getList(ConfigurationNode.class).stream().map(commandNode -> {
                    UsageEntity.Command command = this.parseCommand((ConfigurationNode)commandNode);
                    increment.incrementAndGet();
                    return command;
                }).collect(Collectors.toList());
            }
        }
        catch (Error | RuntimeException | SerializationException e) {
            if (ignoreKey) {
                throw e;
            }
            throw InvalidConfigurationException.path(node.key().toString() + ", " + increment.get(), e);
        }
        try {
            return Collections.singletonList(this.parseCommand(node));
        }
        catch (Error | RuntimeException e) {
            if (ignoreKey) {
                throw e;
            }
            throw InvalidConfigurationException.path(node.key().toString(), e);
        }
    }

    private UsageEntity.Command parseCommand(ConfigurationNode node) throws InvalidConfigurationException {
        return MainConfigEntity.deserializeCommand(node.getString());
    }

    private static ClickAt parseClickAt(String raw) throws InvalidConfigurationException {
        return ConfigParsingHelper.parseEnum(ClickAt.class, raw, "at").get();
    }

    private static CooldownType parseCooldownType(String raw) throws InvalidConfigurationException {
        return ConfigParsingHelper.parseEnum(CooldownType.class, raw, "cooldown type", "cooldown-type").get();
    }

    private static ClickButton parseClickButton(String raw) throws InvalidConfigurationException {
        return ConfigParsingHelper.parseEnum(ClickButton.class, raw, "button").get();
    }

    private static List<String> parsePermissions(String raw) throws InvalidConfigurationException {
        return Arrays.stream(raw.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private static int parseInt(String raw) throws InvalidConfigurationException {
        return Try.ofSupplier(() -> Integer.parseInt(raw.trim())).getOrElseThrow(x -> InvalidConfigurationException.format("Invalid integer: <white>%s</white>", raw));
    }

    private static Tuple2<String, Boolean> parseStateFlag(String raw) throws InvalidConfigurationException {
        Pattern pattern = Pattern.compile("^(?<flag>[a-z\\-\\d]+)(?::(?<value>true|false))?$");
        Matcher matcher = pattern.matcher(raw.trim());
        if (!matcher.matches()) {
            throw InvalidConfigurationException.format("Invalid state flag predicate format: <white>%s</white>.\nShould be something like <white><wg-flag></white>[:<white><true|false></white>]", raw);
        }
        String flag = matcher.group("flag");
        WorldGuardSupport.ensureStateFlagIsValid(flag);
        boolean value = matcher.group("value") == null || matcher.group("value").equals("true");
        return new Tuple2<String, Boolean>(flag, value);
    }

    private Predicate parsePredicate(ConfigurationNode node) throws InvalidConfigurationException, SerializationException {
        if (node.isMap()) {
            ClickAt clickAt = (ClickAt)((Object)Option.of(node.node("at").getString()).map(CustomItemEntity::parseClickAt).getOrNull());
            ClickButton clickButton = (ClickButton)((Object)Option.of(node.node("button").getString()).map(CustomItemEntity::parseClickButton).getOrNull());
            Predicate.Amount amount = new Predicate.Amount(Option.of(node.node("total-amount").get(Integer.class)).getOrElse(node.node("total_amount").get(Integer.class)), node.node("amount").get(Integer.class));
            HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
            String flagsNodePath = "state-flag";
            ConfigurationNode flagsNode = node.node(flagsNodePath);
            if (flagsNode.isNull()) {
                flagsNodePath = "state_flag";
                flagsNode = node.node(flagsNodePath);
            }
            if (flagsNode.isMap()) {
                flagsNode.childrenMap().forEach((key, value) -> {
                    String flag = key.toString();
                    flags.put(flag, this.wrapErrorSupply(() -> {
                        WorldGuardSupport.ensureStateFlagIsValid(flag);
                        return value.getBoolean(true);
                    }, "state-flag, " + flag));
                });
            }
            List<String> permissions = node.node("permission").getList(String.class);
            List ticks = this.wrapErrorSupply(() -> {
                ConfigurationNode timeNode = node.node("time");
                if (timeNode.isList()) {
                    return timeNode.getList(String.class).stream().flatMap(s -> this.parseTime((String)s).stream()).distinct().collect(Collectors.toList());
                }
                if (!timeNode.isNull() && !timeNode.isMap()) {
                    return this.parseTime(timeNode.getString());
                }
                return null;
            }, "time");
            SlotPredicate slots = this.wrapErrorSupply(() -> {
                ConfigurationNode slotNode = node.node("slot");
                if (slotNode.isList()) {
                    return SlotPredicate.union(slotNode.getList(String.class).stream().map(this::parseSlots).distinct().collect(Collectors.toList()));
                }
                if (!slotNode.isNull() && !slotNode.isMap()) {
                    return this.parseSlots(slotNode.getString());
                }
                return null;
            }, "slot");
            SlotPredicate prevSlots = this.wrapErrorSupply(() -> {
                ConfigurationNode slotNode = node.node("prev_slot");
                if (slotNode.isList()) {
                    return SlotPredicate.union(slotNode.getList(String.class).stream().map(this::parseSlots).distinct().collect(Collectors.toList()));
                }
                if (!slotNode.isNull() && !slotNode.isMap()) {
                    return this.parseSlots(slotNode.getString());
                }
                return null;
            }, "prev_slot");
            return new Predicate(clickButton, clickAt, flags, amount, permissions, ticks, slots, prevSlots);
        }
        Matcher matcher = SINGLE_PREDICATE_PATTERN.matcher(node.getString());
        if (!matcher.find()) {
            throw InvalidConfigurationException.format("Invalid predicate: <white>%s</white>", node.getString());
        }
        String value2 = matcher.group("type");
        PredicateType predicateType = PredicateType.fromString(matcher.group("enum"));
        ClickAt clickAt = null;
        ClickButton clickButton = null;
        Predicate.Amount amount = null;
        List<String> permissions = null;
        Map<String, Boolean> flags = null;
        List<Integer> ticks = null;
        SlotPredicate slots = null;
        SlotPredicate prevSlots = null;
        switch (predicateType) {
            case AT: {
                clickAt = CustomItemEntity.parseClickAt(value2);
                break;
            }
            case BUTTON: {
                clickButton = CustomItemEntity.parseClickButton(value2);
                break;
            }
            case AMOUNT: {
                amount = new Predicate.Amount(null, CustomItemEntity.parseInt(value2));
                break;
            }
            case TOTAL_AMOUNT: {
                amount = new Predicate.Amount(CustomItemEntity.parseInt(value2), null);
                break;
            }
            case PERMISSION: {
                permissions = CustomItemEntity.parsePermissions(value2);
                break;
            }
            case STATE_FLAG: {
                Tuple2<String, Boolean> flag = CustomItemEntity.parseStateFlag(value2);
                flags = Collections.singletonMap((String)flag._1, (Boolean)flag._2);
                break;
            }
            case TIME: {
                ticks = this.parseTime(value2);
                break;
            }
            case SLOT: {
                slots = this.parseSlots(value2);
                break;
            }
            case PREV_SLOT: {
                prevSlots = this.parseSlots(value2);
            }
        }
        return new Predicate(clickButton, clickAt, flags, amount, permissions, ticks, slots, prevSlots);
    }

    private <T> T wrapErrorSupply(CheckedFunction0<T> action, String path) {
        try {
            return action.apply();
        }
        catch (Throwable e) {
            throw InvalidConfigurationException.path(path, e);
        }
    }

    private SlotPredicate parseSlot(String raw) {
        String slot;
        String[] split = raw.split("-");
        String first = split[0];
        boolean isNegate = first.startsWith("!");
        String string = slot = isNegate ? first.substring(1) : first;
        if (split.length == 1) {
            return Try.ofSupplier(() -> SlotPredicate.slot(isNegate, Integer.parseInt(slot))).recover(t -> {
                SlotPredicate equipmentSlot = this.parseEquipmentSlot(slot);
                return isNegate ? SlotPredicate.negate(equipmentSlot) : equipmentSlot;
            }).get();
        }
        int start = CustomItemEntity.parseInt(slot);
        int end = CustomItemEntity.parseInt(split[1]);
        return SlotPredicate.range(isNegate, start, end);
    }

    private SlotPredicate parseSlots(String raw) {
        String[] split = raw.split(",");
        return SlotPredicate.union(Arrays.stream(split).map(this::parseSlot).collect(Collectors.toList()));
    }

    private SlotPredicate parseEquipmentSlot(String raw) throws InvalidConfigurationException {
        return (SlotPredicate)ConfigParsingHelper.parseEnumWithoutPath(SlotGroup.class, raw, "equipment slot").map(SlotGroup::getSlotPredicate).get();
    }

    private List<Integer> parseTime(String raw) {
        return Arrays.stream(raw.split(",")).map(String::trim).flatMap(element -> {
            String[] split = element.split("-");
            if (split.length == 1) {
                return Stream.of(Long.valueOf(TimeTokenParser.parse(split[0]))).map(millis -> millis / 50L).map(l -> (int)l.longValue());
            }
            long start = TimeTokenParser.parse(split[0]) / 50L;
            long end = TimeTokenParser.parse(split[1]) / 50L;
            return Arrays.stream(new LongRange(start, end).toArray()).mapToObj(l -> (int)l);
        }).map(i -> Math.max(1, i)).distinct().collect(Collectors.toList());
    }

    @Generated
    public CustomItemEntity() {
    }

    private static enum PredicateType {
        AT,
        BUTTON,
        AMOUNT,
        TOTAL_AMOUNT,
        PERMISSION,
        STATE_FLAG,
        TIME,
        SLOT,
        PREV_SLOT;


        public static PredicateType fromString(String raw) throws InvalidConfigurationException {
            return ConfigParsingHelper.parseEnumWithoutPath(PredicateType.class, raw, "predicate type").get();
        }

        public static String getPattern() {
            return Arrays.stream(PredicateType.values()).map(p -> p.name().toLowerCase()).reduce((s1, s2) -> s1 + "|" + s2).get();
        }
    }

    private static enum SlotGroup {
        HAND(SlotPredicate.equipment(EquipmentSlot.HAND)),
        OFF_HAND(SlotPredicate.equipment(EquipmentSlot.valueOf((String)"OFF_HAND"))),
        ANY_HAND(SlotPredicate.union(SlotGroup.HAND.slotPredicate, SlotGroup.OFF_HAND.slotPredicate)),
        ANY(SlotPredicate.any()),
        HEAD(SlotPredicate.equipment(EquipmentSlot.HEAD)),
        CHEST(SlotPredicate.equipment(EquipmentSlot.CHEST)),
        LEGS(SlotPredicate.equipment(EquipmentSlot.LEGS)),
        FEET(SlotPredicate.equipment(EquipmentSlot.FEET)),
        ARMOR(SlotPredicate.union(SlotGroup.HEAD.slotPredicate, SlotGroup.CHEST.slotPredicate, SlotGroup.LEGS.slotPredicate, SlotGroup.FEET.slotPredicate)),
        HOTBAR(SlotPredicate.range(0, 8));

        private final SlotPredicate slotPredicate;

        @Generated
        public SlotPredicate getSlotPredicate() {
            return this.slotPredicate;
        }

        @Generated
        private SlotGroup(SlotPredicate slotPredicate) {
            this.slotPredicate = slotPredicate;
        }
    }
}

