/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.controller;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.material.Openable;
import ua.valeriishymchuk.simpleitemgenerator.common.block.BlockDataWrapper;
import ua.valeriishymchuk.simpleitemgenerator.common.bridge.BukkitBridge;
import ua.valeriishymchuk.simpleitemgenerator.common.debug.PipelineDebug;
import ua.valeriishymchuk.simpleitemgenerator.common.item.ItemCopy;
import ua.valeriishymchuk.simpleitemgenerator.common.item.NBTCustomItem;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.scheduler.BukkitTaskScheduler;
import ua.valeriishymchuk.simpleitemgenerator.common.slot.EquipmentToSlotConverter;
import ua.valeriishymchuk.simpleitemgenerator.common.tick.TickTimer;
import ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate.SlotPredicate;
import ua.valeriishymchuk.simpleitemgenerator.common.version.FeatureSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SigFeatureTag;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageBlockDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageEntityDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageGeneralDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.ItemUsageResultDTO;
import ua.valeriishymchuk.simpleitemgenerator.dto.SlotChangeDTO;
import ua.valeriishymchuk.simpleitemgenerator.entity.UsageEntity;
import ua.valeriishymchuk.simpleitemgenerator.service.InfoService;
import ua.valeriishymchuk.simpleitemgenerator.service.ItemService;

public class EventsController
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("SIG-" + EventsController.class.getSimpleName());
    private static final io.vavr.collection.Map<Integer, Set<Material>> FIT_MATERIALS = io.vavr.collection.HashMap.of(40, Arrays.stream(Material.values()).filter(m -> m.name().equals("SHIELD")).collect(Collectors.toSet()), 39, Arrays.stream(Material.values()).filter(m -> EnchantmentTarget.ARMOR_HEAD.includes(m) || FeatureSupport.NAMESPACED_KEYS_SUPPORT && m.name().equals("CARVED_PUMPKIN") || !FeatureSupport.NAMESPACED_KEYS_SUPPORT && m.name().equals("PUMPKIN") || m.name().equals("SKULL_ITEM") || m.name().endsWith("HEAD")).collect(Collectors.toSet()), 38, Arrays.stream(Material.values()).filter(arg_0 -> ((EnchantmentTarget)EnchantmentTarget.ARMOR_TORSO).includes(arg_0)).collect(Collectors.toSet()), 37, Arrays.stream(Material.values()).filter(arg_0 -> ((EnchantmentTarget)EnchantmentTarget.ARMOR_LEGS).includes(arg_0)).collect(Collectors.toSet()), 36, Arrays.stream(Material.values()).filter(arg_0 -> ((EnchantmentTarget)EnchantmentTarget.ARMOR_FEET).includes(arg_0)).collect(Collectors.toSet()));
    private static final Set<Class<?>> DEBUG_EVENTS_TO_INCLUDE = new HashSet<Class>(Arrays.asList(InventoryClickEvent.class, InventoryDragEvent.class, PlayerDeathEvent.class, PlayerJoinEvent.class, PrepareItemCraftEvent.class, PlayerInteractEvent.class, PlayerDropItemEvent.class, PlayerInteractAtEntityEvent.class, EntityDamageByEntityEvent.class, PlayerPickupItemEvent.class));
    private final ItemService itemService;
    private final InfoService infoService;
    private final TickTimer tickerTime;
    private final BukkitTaskScheduler scheduler;
    private final Map<Player, Long> lastDropTick = new WeakHashMap<Player, Long>();
    private final Map<Player, Long> lastPlayerClickTick = new WeakHashMap<Player, Long>();
    private final Map<Player, Tuple2<Long, Integer>> playerTickSlotMap = new WeakHashMap<Player, Tuple2<Long, Integer>>();

    public EventsController(ItemService itemService, InfoService infoService, TickTimer tickerTime, BukkitTaskScheduler scheduler) {
        this.itemService = itemService;
        this.infoService = infoService;
        this.tickerTime = tickerTime;
        this.scheduler = scheduler;
    }

    private boolean checkDebugExclusion(Event event) {
        return this.infoService.isDebug() && !DEBUG_EVENTS_TO_INCLUDE.contains(event.getClass());
    }

    @EventHandler
    private void onJoin(PlayerJoinEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        this.scheduler.runTaskLater(() -> {
            this.infoService.getMessage(event.getPlayer()).peek(msg -> KyoriHelper.sendMessage((CommandSender)event.getPlayer(), msg));
            ((CompletableFuture)this.infoService.getNewUpdateMessage(event.getPlayer()).thenAccept(msgOpt -> msgOpt.peek(msg -> KyoriHelper.sendMessage((CommandSender)event.getPlayer(), msg)))).exceptionally(e -> {
                LOGGER.log(Level.SEVERE, "Please report this error there: https://github.com/ValeraShimchuck/SimpleItemGenerator/issues\n", (Throwable)e);
                return null;
            });
        }, 40L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String command = event.getMessage().replace("/", "");
        if (command.startsWith("sig") || command.startsWith("simpleitemgenerator")) {
            this.infoService.updatePluginActivity();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onServerCommand(ServerCommandEvent event) {
        String command = event.getCommand().replace("/", "");
        if (command.startsWith("sig") || command.startsWith("simpleitemgenerator")) {
            this.infoService.updatePluginActivity();
        }
    }

    private ItemCopy[] getInventorySnapshot(InventoryView inventory) {
        ItemStack item;
        int i;
        Inventory topInventory = inventory.getTopInventory();
        Inventory bottomInventory = inventory.getBottomInventory();
        int topSize = topInventory.getSize();
        int bottomSize = bottomInventory.getSize();
        boolean hasOffhand = FeatureSupport.MODERN_COMBAT;
        int offsize = 4 + (hasOffhand ? 1 : 0);
        ItemCopy[] snapshot = new ItemCopy[topSize + bottomSize + offsize];
        for (i = 0; i < bottomSize; ++i) {
            item = bottomInventory.getItem(i);
            snapshot[i] = ItemCopy.from(item);
        }
        snapshot[bottomSize] = ItemCopy.from(((Player)inventory.getBottomInventory().getHolder()).getInventory().getBoots());
        snapshot[bottomSize + 1] = ItemCopy.from(((Player)inventory.getBottomInventory().getHolder()).getInventory().getLeggings());
        snapshot[bottomSize + 2] = ItemCopy.from(((Player)inventory.getBottomInventory().getHolder()).getInventory().getChestplate());
        snapshot[bottomSize + 3] = ItemCopy.from(((Player)inventory.getBottomInventory().getHolder()).getInventory().getHelmet());
        if (hasOffhand) {
            snapshot[bottomSize + 4] = ItemCopy.from(((Player)inventory.getBottomInventory().getHolder()).getInventory().getItem(40));
        }
        for (i = 0; i < topSize; ++i) {
            item = topInventory.getItem(i);
            snapshot[i + bottomSize + offsize] = ItemCopy.from(item);
        }
        return snapshot;
    }

    private boolean isInteractableBlock(Block block) {
        Supplier<Boolean> legacyDoorCheck = () -> block.getState().getData() instanceof Openable;
        Supplier<Boolean> legacySwitchableCheck = () -> block.getType().name().contains("BUTTON") || block.getType().name().contains("LEVER");
        BlockDataWrapper blockData = new BlockDataWrapper(block);
        boolean checkDoor = blockData.isInstanceOf("org.bukkit.block.data.Openable").getOrElse(legacyDoorCheck) != false && !block.getType().name().contains("IRON");
        boolean checkSwitchable = blockData.isInstanceOf("org.bukkit.block.data.type.Switch").getOrElse(legacySwitchableCheck);
        return block.getState() instanceof InventoryHolder || checkDoor || checkSwitchable;
    }

    @EventHandler
    private void onArmorRMBClickEvent(PlayerInteractEvent event) {
        if (!this.infoService.getFeatures().contains((Object)SigFeatureTag.ENHANCED_SLOT_PREDICATE)) {
            return;
        }
        if (!event.getAction().name().startsWith("RIGHT")) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null) {
            System.out.println(String.valueOf(block.getState().getData()) + " " + String.valueOf(block.getType()));
            System.out.println("with block: " + String.valueOf(event.useInteractedBlock()) + " " + String.valueOf(event.useItemInHand()) + " " + this.isInteractableBlock(block));
        } else {
            System.out.println("without block: " + String.valueOf(event.useInteractedBlock()) + " " + String.valueOf(event.useItemInHand()));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onItemClick(InventoryClickEvent event) {
        if (!this.infoService.getFeatures().contains((Object)SigFeatureTag.ENHANCED_SLOT_PREDICATE)) {
            return;
        }
        if (!(event.getClickedInventory() instanceof PlayerInventory) && event.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY && event.getAction() != InventoryAction.HOTBAR_SWAP) {
            return;
        }
        boolean isClickedSlotEmptied = ItemCopy.isAir(event.getCurrentItem()) ? false : (event.getAction() == InventoryAction.PICKUP_ALL || event.getAction() == InventoryAction.SWAP_WITH_CURSOR ? true : ((event.getAction() == InventoryAction.PICKUP_ONE || event.getAction() == InventoryAction.PICKUP_HALF) && event.getCurrentItem().getAmount() == 1 ? true : event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || event.getAction() == InventoryAction.HOTBAR_SWAP));
        HashMap<Integer, ItemStack> movedSlots = new HashMap<Integer, ItemStack>();
        Player player = (Player)event.getWhoClicked();
        InventoryAction action = event.getAction();
        switch (action) {
            case MOVE_TO_OTHER_INVENTORY: {
                this.handleMoveToOtherInventory(event, movedSlots, player);
                break;
            }
            case HOTBAR_SWAP: {
                this.handleHotbarSwap(event, movedSlots, player);
                break;
            }
            case SWAP_WITH_CURSOR: {
                this.handleSwapWithCursor(event, movedSlots);
                break;
            }
            case PLACE_ONE: 
            case PLACE_SOME: 
            case PLACE_ALL: {
                this.handlePlaceActions(event, movedSlots);
            }
        }
        HashMap<ItemUsageResultDTO, ItemStack> results = new HashMap<ItemUsageResultDTO, ItemStack>();
        if (isClickedSlotEmptied) {
            results.put(this.itemService.moveItem(player, new SlotChangeDTO(new SlotPredicate.Input(event.getSlot(), (EquipmentSlot)EquipmentToSlotConverter.convert(event.getSlot(), player).getOrNull(), false), this.tickerTime.getTick(), ItemCopy.from(event.getCurrentItem())), PipelineDebug.root("Move item From " + event.getSlot(), PipelineDebug.Tag.INVENTORY)), event.getCurrentItem());
        }
        movedSlots.forEach((slot, item) -> {
            if (item.isSimilar(event.getClickedInventory().getItem(slot.intValue()))) {
                return;
            }
            results.put(this.itemService.moveItem(player, new SlotChangeDTO(new SlotPredicate.Input((int)slot, (EquipmentSlot)EquipmentToSlotConverter.convert(slot, player).getOrNull(), true), this.tickerTime.getTick(), ItemCopy.from(item)), PipelineDebug.root("Move item To " + slot, PipelineDebug.Tag.INVENTORY)), (ItemStack)item);
        });
        if (results.isEmpty()) {
            return;
        }
        boolean isAnyCancelled = results.keySet().stream().anyMatch(ItemUsageResultDTO::isShouldCancel);
        if (isAnyCancelled) {
            new HashSet(results.keySet()).stream().filter(usage -> !usage.isShouldCancel()).forEach(results::remove);
        }
        results.forEach((usage, item) -> this.handleResult((ItemUsageResultDTO)usage, (ItemStack)item, player, (Cancellable)event, false));
    }

    private void handleMoveToOtherInventory(InventoryClickEvent event, Map<Integer, ItemStack> movedSlots, Player player) {
        PlayerInventory destination = event.getClickedInventory() instanceof PlayerInventory ? event.getView().getTopInventory() : player.getInventory();
        ItemStack movedItem = event.getCurrentItem().clone();
        if (ItemCopy.isAir(movedItem)) {
            return;
        }
        if (Objects.requireNonNull(event.getView().getType()) == InventoryType.CRAFTING) {
            boolean isHotbar;
            HashSet<Integer> blackListedSlots = new HashSet<Integer>();
            blackListedSlots.add(36);
            blackListedSlots.add(37);
            blackListedSlots.add(38);
            blackListedSlots.add(39);
            if (FeatureSupport.MODERN_COMBAT) {
                blackListedSlots.add(40);
            }
            ArrayList<Integer> slots = new ArrayList<Integer>();
            slots.addAll(blackListedSlots);
            FIT_MATERIALS.filterValues(t -> t.contains(movedItem.getType())).keySet().forEach(blackListedSlots::remove);
            boolean bl = isHotbar = event.getSlot() < 9;
            if (isHotbar) {
                for (int i = 35; i >= 9; --i) {
                    slots.add(i);
                }
            } else if (blackListedSlots.contains(event.getSlot())) {
                for (int i = 35; i >= 0; --i) {
                    slots.add(i);
                }
            } else {
                for (int i = 0; i < 9; ++i) {
                    slots.add(i);
                }
            }
            ShiftClickResult.calculateShiftClick((ItemStack)event.getCurrentItem(), (Inventory)player.getInventory(), slots, blackListedSlots, (boolean)(!blackListedSlots.contains((Object)Integer.valueOf((int)event.getSlot())) ? true : false), (boolean)this.infoService.isDebug()).slotStatuses.forEach((slot, status) -> {
                if (status.wasBefore) {
                    return;
                }
                movedItem.setAmount(status.itemsAdded);
                movedSlots.put((Integer)slot, movedItem);
            });
        } else {
            ArrayList<Integer> slots;
            if (event.getClickedInventory() == event.getView().getTopInventory()) {
                slots = List.range(0, event.getClickedInventory().getSize()).asJavaMutable();
            } else {
                slots = new ArrayList();
                for (int layer = 0; layer < 4; ++layer) {
                    for (int i = 8; i >= 0; --i) {
                        slots.add(layer * 9 + i);
                    }
                }
            }
            ShiftClickResult.calculateShiftClick((ItemStack)event.getCurrentItem(), (Inventory)destination, slots, new HashSet<Integer>(), (boolean)false, (boolean)this.infoService.isDebug()).slotStatuses.forEach((slot, slotStatus) -> {
                if (slotStatus.wasBefore) {
                    return;
                }
                movedItem.setAmount(slotStatus.itemsAdded);
                movedSlots.put((Integer)slot, movedItem);
            });
        }
        if (this.infoService.isDebug()) {
            LOGGER.info("Handling movement to the other inventory");
            LOGGER.info("Destination " + String.valueOf(destination) + " slot: " + event.getSlot() + " \nact: " + String.valueOf(event.getAction()) + "\nclick: " + String.valueOf(event.getClick()) + "\nisPlayerInventory: " + (event.getView().getType() == InventoryType.CRAFTING) + "\ntype: " + String.valueOf(event.getView().getType()) + "\nmoved-slots: " + movedSlots.entrySet().stream().map(e -> String.valueOf(e.getKey()) + " " + String.valueOf(((ItemStack)e.getValue()).getType())).collect(Collectors.joining("\n")));
        }
    }

    private void handleHotbarSwap(InventoryClickEvent event, Map<Integer, ItemStack> movedSlots, Player player) {
        int hotbarSlot = event.getHotbarButton();
        if (hotbarSlot == -1) {
            hotbarSlot = 40;
        }
        ItemStack hotbarItem = player.getInventory().getItem(hotbarSlot);
        int clickedSlot = event.getSlot();
        Inventory clickedInventory = event.getClickedInventory();
        if (ItemCopy.isAir(clickedInventory.getItem(clickedSlot)) && !ItemCopy.isAir(hotbarItem)) {
            movedSlots.put(clickedSlot, hotbarItem.clone());
        }
    }

    private void handleSwapWithCursor(InventoryClickEvent event, Map<Integer, ItemStack> movedSlots) {
        ItemStack cursorItem = event.getCursor();
        int clickedSlot = event.getSlot();
        Inventory clickedInventory = event.getClickedInventory();
        if (ItemCopy.isAir(clickedInventory.getItem(clickedSlot)) && !ItemCopy.isAir(cursorItem)) {
            movedSlots.put(clickedSlot, cursorItem.clone());
        }
    }

    private void handlePlaceActions(InventoryClickEvent event, Map<Integer, ItemStack> movedSlots) {
        int clickedSlot = event.getSlot();
        Inventory clickedInventory = event.getClickedInventory();
        ItemStack originalItem = clickedInventory.getItem(clickedSlot);
        ItemStack cursorItem = event.getCursor();
        if (ItemCopy.isAir(originalItem) && !ItemCopy.isAir(cursorItem)) {
            ItemStack newItem = cursorItem.clone();
            if (event.getAction() == InventoryAction.PLACE_ONE) {
                newItem.setAmount(1);
            } else {
                int maxStack = newItem.getMaxStackSize();
                newItem.setAmount(Math.min(cursorItem.getAmount(), maxStack));
            }
            movedSlots.put(clickedSlot, newItem);
        }
    }

    private ItemMovement findFirstAvailableSlot(ItemStack item, Inventory inventory, int prevSlot, int startSlot, int endSlot) {
        int amount = item.getAmount();
        int stackSize = item.getMaxStackSize();
        ArrayList<ItemMovement.NewItemInfo> newItemInfos = new ArrayList<ItemMovement.NewItemInfo>();
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack existingItem = inventory.getItem(i);
            if (existingItem == null || existingItem.getType().name().endsWith("AIR")) {
                return new ItemMovement(prevSlot, 0, (List<ItemMovement.NewItemInfo>)List.of(Collections.singleton(new ItemMovement.NewItemInfo(i, existingItem.getAmount() + amount, true)), newItemInfos).flatMap(c -> c));
            }
            if (!existingItem.isSimilar(item)) continue;
            if (existingItem.getAmount() + amount <= stackSize) {
                return new ItemMovement(prevSlot, 0, (List<ItemMovement.NewItemInfo>)List.of(Collections.singleton(new ItemMovement.NewItemInfo(i, existingItem.getAmount() + amount, true)), newItemInfos).flatMap(c -> c));
            }
            int availableAmount = stackSize - existingItem.getAmount();
            newItemInfos.add(new ItemMovement.NewItemInfo(i, stackSize, true));
            if ((amount -= availableAmount) != 0) continue;
            return new ItemMovement(prevSlot, 0, (List<ItemMovement.NewItemInfo>)List.of(newItemInfos).flatMap(c -> c));
        }
        return new ItemMovement(prevSlot, amount, (List<ItemMovement.NewItemInfo>)List.of(newItemInfos).flatMap(c -> c));
    }

    @EventHandler(priority=EventPriority.HIGH)
    private void onUsage(PlayerInteractEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        long currentTick = this.tickerTime.getTick();
        Long lastDropTick = this.lastDropTick.get(event.getPlayer());
        Long lastPlayerClickTick = this.lastPlayerClickTick.get(event.getPlayer());
        if (lastDropTick != null && currentTick == lastDropTick) {
            return;
        }
        if (lastPlayerClickTick != null && currentTick == lastPlayerClickTick) {
            return;
        }
        Option customItemOpt = Option.of(event.getItem()).flatMap(NBTCustomItem::getCustomItemId);
        EquipmentSlot equipmentSlot = event.getHand();
        int currentMainHandSlot = event.getPlayer().getInventory().getHeldItemSlot();
        ItemUsageResultDTO result = this.itemService.useItem(new ItemUsageBlockDTO(event.getPlayer(), event.getAction(), event.getItem(), event.getClickedBlock(), BukkitBridge.bridge(event.getBlockFace()), new SlotPredicate.Input(EquipmentToSlotConverter.convert(equipmentSlot, currentMainHandSlot), equipmentSlot, true), this.tickerTime.getTick()), PipelineDebug.root("PlayerInteractEvent " + String.valueOf(event.getAction()), new PipelineDebug.Tag[0]));
        this.handleResult(result, event.getItem(), event.getPlayer(), (Cancellable)event, true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onWorkbench(PrepareItemCraftEvent event) {
        boolean shouldCancel;
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        boolean bl = shouldCancel = !Arrays.stream(event.getInventory().getMatrix()).filter(Objects::nonNull).allMatch(this.itemService::canBeUsedInCraft);
        if (shouldCancel) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    private void onPlayerInventoryDrop(InventoryClickEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        if (event.getClick() == ClickType.CREATIVE || event.getClick() == ClickType.DROP) {
            this.playerTickSlotMap.put((Player)event.getWhoClicked(), Tuple.of(this.tickerTime.getTick(), event.getSlot()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    private void onDrop(PlayerDropItemEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        Player player = event.getPlayer();
        this.lastDropTick.put(player, this.tickerTime.getTick());
        ItemStack itemStack = event.getItemDrop().getItemStack();
        Tuple2<Long, Integer> tuple = this.playerTickSlotMap.get(player);
        int slot = tuple != null && tuple._1().longValue() == this.tickerTime.getTick() ? tuple._2().intValue() : player.getInventory().getHeldItemSlot();
        boolean isHeldItem = slot == player.getInventory().getHeldItemSlot();
        this.handleResult(this.itemService.dropItem(new ItemUsageGeneralDTO(player, itemStack, this.tickerTime.getTick(), new SlotPredicate.Input(slot, (EquipmentSlot)EquipmentToSlotConverter.convert(slot, player).getOrNull(), true)), PipelineDebug.root("PlayerDropItemEvent", new PipelineDebug.Tag[0])), itemStack, player, (Cancellable)event, false);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    private void onInteractAt(PlayerInteractAtEntityEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        long currentTick = this.tickerTime.getTick();
        Long lastPlayerClickTickValue = this.lastPlayerClickTick.get(event.getPlayer());
        if (lastPlayerClickTickValue != null && currentTick == lastPlayerClickTickValue) {
            return;
        }
        int clickedSlot = (event.getPlayer().getItemInHand() == null || event.getPlayer().getItemInHand().getType().name().endsWith("AIR")) && FeatureSupport.MODERN_COMBAT ? 40 : event.getPlayer().getInventory().getHeldItemSlot();
        this.lastPlayerClickTick.put(event.getPlayer(), this.tickerTime.getTick());
        ItemUsageResultDTO result = this.itemService.useItemAt(new ItemUsageEntityDTO(event.getPlayer(), true, event.getRightClicked(), event.getPlayer().getItemInHand(), new SlotPredicate.Input(clickedSlot, (EquipmentSlot)EquipmentToSlotConverter.convert(clickedSlot, event.getPlayer()).getOrNull(), true), this.tickerTime.getTick()), PipelineDebug.root("PlayerInteractAtEntityEvent", new PipelineDebug.Tag[0]));
        this.handleResult(result, event.getPlayer().getItemInHand(), event.getPlayer(), (Cancellable)event, false);
    }

    @EventHandler(priority=EventPriority.HIGH)
    private void onDamage(EntityDamageByEntityEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        boolean isCancelled = event.isCancelled();
        ItemUsageResultDTO result = this.itemService.useItemAt(new ItemUsageEntityDTO(player, false, event.getEntity(), player.getItemInHand(), new SlotPredicate.Input(player.getInventory().getHeldItemSlot(), EquipmentSlot.HAND, true), this.tickerTime.getTick()), PipelineDebug.root("EntityDamageByEntityEvent", new PipelineDebug.Tag[0]));
        this.handleResult(result, player.getItemInHand(), player, (Cancellable)event, false);
        if (isCancelled) {
            event.setCancelled(true);
        }
    }

    private void handleResult(ItemUsageResultDTO result, ItemStack item, Player player, Cancellable event, boolean omitEventCancellation) {
        if (this.infoService.isDebug()) {
            result.getPipelineDebug().print(new PipelineDebug.Tag[0]);
        }
        if (!event.isCancelled()) {
            event.setCancelled(result.isShouldCancel() || event.isCancelled() && !omitEventCancellation);
        }
        result.getCommands().forEach(commands -> {
            ConsoleCommandSender sender = commands.isExecuteAsConsole() ? Bukkit.getConsoleSender() : player;
            try {
                Bukkit.dispatchCommand((CommandSender)sender, (String)commands.getCommand());
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error while executing command " + commands.getCommand() + ":\n", e.getMessage());
            }
        });
        result.getMessage().peek(message -> KyoriHelper.sendMessage((CommandSender)player, message));
        if (!result.getConsume().isNone() && item != null) {
            ItemStack clonedItem = item.clone();
            if (result.getConsume().isAmount()) {
                AtomicInteger totalAmount = new AtomicInteger(result.getConsume().getAmount());
                player.getInventory().forEach(itemCons -> {
                    if (itemCons == null || itemCons.getType().name().endsWith("AIR")) {
                        return;
                    }
                    if (this.itemService.areNotEqual((ItemStack)itemCons, clonedItem)) {
                        return;
                    }
                    if (totalAmount.get() <= 0) {
                        return;
                    }
                    int toRemove = Math.min(totalAmount.get(), itemCons.getAmount());
                    itemCons.setAmount(itemCons.getAmount() - toRemove);
                    totalAmount.set(totalAmount.get() - toRemove);
                });
            } else {
                boolean onlyStack;
                boolean bl = onlyStack = result.getConsume().getConsumeType() == UsageEntity.ConsumeType.STACK;
                if (onlyStack) {
                    item.setAmount(0);
                } else {
                    player.getInventory().forEach(itemCons -> {
                        if (itemCons == null || itemCons.getType().name().endsWith("AIR")) {
                            return;
                        }
                        if (this.itemService.areNotEqual((ItemStack)itemCons, clonedItem)) {
                            return;
                        }
                        itemCons.setAmount(0);
                    });
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    private void onInventoryDrag(InventoryDragEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        boolean canBePutInvInventory = event.getNewItems().values().stream().anyMatch(this.itemService::canBePutInInventory);
        if (canBePutInvInventory) {
            return;
        }
        boolean shouldCancel = event.getNewItems().keySet().stream().anyMatch(slot -> slot < event.getView().getTopInventory().getSize());
        if (shouldCancel) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    private void onDeath(PlayerDeathEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        event.getDrops().removeIf(this.itemService::shouldRemoveOnDeath);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    private void onPickup(PlayerPickupItemEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        if (event.getRemaining() != 0) {
            return;
        }
        if (!event.getItem().getItemStack().hasItemMeta()) {
            return;
        }
        this.itemService.updateItem(event.getItem().getItemStack(), event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    private void replaceItemOnDrop(PlayerDropItemEvent event) {
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        if (!event.getItemDrop().getItemStack().hasItemMeta()) {
            return;
        }
        this.itemService.updateItem(event.getItemDrop().getItemStack(), null).peek(arg_0 -> ((Item)event.getItemDrop()).setItemStack(arg_0));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    private void onInventoryClick(InventoryClickEvent event) {
        CraftingInventory craftingInventory;
        int button;
        if (this.checkDebugExclusion((Event)event)) {
            return;
        }
        ItemStack carriedItem = event.getCursor();
        ItemStack clickedItem = event.getCurrentItem();
        if (!this.itemService.canBeMoved(clickedItem)) {
            event.setCancelled(true);
            return;
        }
        Player player = (Player)event.getWhoClicked();
        boolean isSwap = Arrays.asList(InventoryAction.HOTBAR_SWAP, InventoryAction.HOTBAR_MOVE_AND_READD).contains(event.getAction());
        ItemStack clickedWithItem = isSwap ? ((button = event.getHotbarButton()) >= 0 ? player.getInventory().getItem(button) : player.getInventory().getItem(40)) : null;
        HashSet<ItemStack> forbiddenForInventorySwap = new HashSet<ItemStack>();
        if (!this.itemService.canBePutInInventory(clickedWithItem)) {
            forbiddenForInventorySwap.add(clickedWithItem);
        }
        if (!this.itemService.canBePutInInventory(carriedItem)) {
            forbiddenForInventorySwap.add(carriedItem);
        }
        if (!this.itemService.canBePutInInventory(clickedItem)) {
            forbiddenForInventorySwap.add(clickedItem);
        }
        if (event.getView().getTopInventory() instanceof PlayerInventory) {
            return;
        }
        boolean topInventoryIsPlayers = event.getView().getTopInventory() instanceof CraftingInventory ? (craftingInventory = (CraftingInventory)event.getView().getTopInventory()).getMatrix().length == 4 : false;
        boolean isPlayerInventory = event.getClickedInventory() instanceof PlayerInventory;
        if (forbiddenForInventorySwap.isEmpty()) {
            return;
        }
        if (forbiddenForInventorySwap.contains(clickedItem) && event.getClick().isShiftClick() && isPlayerInventory && !topInventoryIsPlayers) {
            event.setCancelled(true);
            return;
        }
        if ((forbiddenForInventorySwap.contains(clickedWithItem) || forbiddenForInventorySwap.contains(carriedItem)) && !isPlayerInventory) {
            event.setCancelled(true);
        }
    }

    private static class ShiftClickResult {
        private final int remaining;
        private final Map<Integer, SlotStatus> slotStatuses;

        public static ShiftClickResult calculateShiftClick(ItemStack item, Inventory destination, Iterable<Integer> slotSequence, Set<Integer> blacklistedSlots, boolean startFromEnd, boolean isDebug) {
            int firstEmpty = -1;
            int remaining = item.getAmount();
            if (isDebug) {
                LOGGER.info(String.valueOf(destination) + " " + destination.getSize() + " bl: " + String.valueOf(blacklistedSlots));
            }
            HashMap<Integer, SlotStatus> slotStatusMap = new HashMap<Integer, SlotStatus>();
            for (int i : slotSequence) {
                int slotAvailable;
                int slotMaxStackSize;
                int available;
                if (isDebug) {
                    LOGGER.info("Checking slot: " + i + " " + startFromEnd);
                }
                if (blacklistedSlots.contains(i)) continue;
                if (isDebug) {
                    LOGGER.info("pass1");
                }
                ItemStack itemFromInventory = destination.getItem(i);
                if (firstEmpty == -1 && ItemCopy.isAir(itemFromInventory)) {
                    firstEmpty = i;
                }
                if (!item.isSimilar(itemFromInventory) || (available = (slotMaxStackSize = itemFromInventory.getMaxStackSize()) - (slotAvailable = itemFromInventory.getAmount())) <= 0) continue;
                int addedItems = Math.min(remaining, available);
                slotStatusMap.put(i, new SlotStatus(true, addedItems));
                if ((remaining -= addedItems) > 0) continue;
                break;
            }
            if (firstEmpty >= 0 && remaining > 0) {
                slotStatusMap.put(firstEmpty, new SlotStatus(false, remaining));
                remaining = 0;
            }
            return new ShiftClickResult(remaining, slotStatusMap);
        }

        @Generated
        public ShiftClickResult(int remaining, Map<Integer, SlotStatus> slotStatuses) {
            this.remaining = remaining;
            this.slotStatuses = slotStatuses;
        }

        private static class SlotStatus {
            private final boolean wasBefore;
            private final int itemsAdded;

            @Generated
            public SlotStatus(boolean wasBefore, int itemsAdded) {
                this.wasBefore = wasBefore;
                this.itemsAdded = itemsAdded;
            }
        }
    }

    private static class ItemMovement {
        private final int prevSlot;
        private final int prevSlotNewAmount;
        private final List<NewItemInfo> newItemInfos;

        @Generated
        public int getPrevSlot() {
            return this.prevSlot;
        }

        @Generated
        public int getPrevSlotNewAmount() {
            return this.prevSlotNewAmount;
        }

        @Generated
        public List<NewItemInfo> getNewItemInfos() {
            return this.newItemInfos;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemMovement)) {
                return false;
            }
            ItemMovement other = (ItemMovement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPrevSlot() != other.getPrevSlot()) {
                return false;
            }
            if (this.getPrevSlotNewAmount() != other.getPrevSlotNewAmount()) {
                return false;
            }
            List<NewItemInfo> this$newItemInfos = this.getNewItemInfos();
            List<NewItemInfo> other$newItemInfos = other.getNewItemInfos();
            return !(this$newItemInfos == null ? other$newItemInfos != null : !this$newItemInfos.equals(other$newItemInfos));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ItemMovement;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPrevSlot();
            result = result * 59 + this.getPrevSlotNewAmount();
            List<NewItemInfo> $newItemInfos = this.getNewItemInfos();
            result = result * 59 + ($newItemInfos == null ? 43 : $newItemInfos.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EventsController.ItemMovement(prevSlot=" + this.getPrevSlot() + ", prevSlotNewAmount=" + this.getPrevSlotNewAmount() + ", newItemInfos=" + String.valueOf(this.getNewItemInfos()) + ")";
        }

        @Generated
        public ItemMovement(int prevSlot, int prevSlotNewAmount, List<NewItemInfo> newItemInfos) {
            this.prevSlot = prevSlot;
            this.prevSlotNewAmount = prevSlotNewAmount;
            this.newItemInfos = newItemInfos;
        }

        private static class NewItemInfo {
            private final int newSlot;
            private final int newSlotNewAmount;
            private final boolean existedBefore;

            @Generated
            public NewItemInfo(int newSlot, int newSlotNewAmount, boolean existedBefore) {
                this.newSlot = newSlot;
                this.newSlotNewAmount = newSlotNewAmount;
                this.existedBefore = existedBefore;
            }

            @Generated
            public int getNewSlot() {
                return this.newSlot;
            }

            @Generated
            public int getNewSlotNewAmount() {
                return this.newSlotNewAmount;
            }

            @Generated
            public boolean isExistedBefore() {
                return this.existedBefore;
            }
        }
    }
}

