/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class SemanticVersion
implements Comparable<SemanticVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(\\.(\\d+))?.*");
    public static final SemanticVersion CURRENT_MINECRAFT = SemanticVersion.parse(Bukkit.getBukkitVersion());
    private final int major;
    private final int minor;
    private final int patch;

    public SemanticVersion(int major, int minor) {
        this(major, minor, 0);
    }

    @Override
    public int compareTo(@NotNull SemanticVersion o) {
        if (this.major > o.major) {
            return 1;
        }
        if (this.major < o.major) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        return Integer.compare(this.patch, o.patch);
    }

    public String toString() {
        String lastPart = this.patch == 0 ? "" : "." + this.patch;
        return this.major + "." + this.minor + lastPart;
    }

    public String toFullString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public boolean isAtLeast(SemanticVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isAtLeast(int major, int minor, int patch) {
        return this.isAtLeast(new SemanticVersion(major, minor, patch));
    }

    public boolean isAtLeast(int major, int minor) {
        return this.isAtLeast(major, minor, 0);
    }

    public void assertAtLeast(int major, int minor, int patch) {
        this.assertAtLeast(new SemanticVersion(major, minor, patch));
    }

    public void assertAtLeast(int major, int minor) {
        this.assertAtLeast(major, minor, 0);
    }

    public void assertAtLeast(SemanticVersion other) {
        if (!this.isAtLeast(other)) {
            throw new IllegalStateException("Feature is supported from " + String.valueOf(other) + ". Current version " + String.valueOf(this));
        }
    }

    public static SemanticVersion parse(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        String subVersion = matcher.group(4);
        return new SemanticVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), subVersion != null ? Integer.parseInt(matcher.group(4)) : 0);
    }

    @Generated
    public SemanticVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @Generated
    public int getMajor() {
        return this.major;
    }

    @Generated
    public int getMinor() {
        return this.minor;
    }

    @Generated
    public int getPatch() {
        return this.patch;
    }
}

