/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.usage.predicate;

import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.common.debug.PipelineDebug;

public abstract class SlotPredicate {
    private static final boolean DEBUG = false;
    private final boolean negate;

    private static void printDebug(String msg) {
    }

    public static SlotPredicate slot(boolean negate, int slot) {
        return new StaticSlotPredicate(negate, slot);
    }

    public static SlotPredicate slot(int slot) {
        return SlotPredicate.slot(false, slot);
    }

    public static SlotPredicate range(boolean negate, int slot1, int slot2) {
        if (slot1 == slot2) {
            return SlotPredicate.slot(negate, slot1);
        }
        return new SlotRangePredicate(negate, slot1, slot2);
    }

    public static SlotPredicate range(int slot1, int slot2) {
        return SlotPredicate.range(false, slot1, slot2);
    }

    public static SlotPredicate equipment(boolean negate, EquipmentSlot slot) {
        return new EquipmentSlotPredicate(negate, slot);
    }

    public static SlotPredicate equipment(EquipmentSlot slot) {
        return SlotPredicate.equipment(false, slot);
    }

    public static SlotPredicate union(boolean negate, Collection<SlotPredicate> predicates) {
        if (predicates.size() == 1) {
            return predicates.iterator().next();
        }
        return new UnionSlotPredicate(negate, predicates);
    }

    public static SlotPredicate union(Collection<SlotPredicate> predicates) {
        return SlotPredicate.union(false, predicates);
    }

    public static SlotPredicate union(boolean negate, SlotPredicate ... predicates) {
        return SlotPredicate.union(negate, io.vavr.collection.List.of(predicates).toJavaList());
    }

    public static SlotPredicate union(SlotPredicate ... predicates) {
        return SlotPredicate.union(false, predicates);
    }

    public static SlotPredicate any() {
        return AnySlotPredicate.INSTANCE;
    }

    public static SlotPredicate negate(SlotPredicate predicate) {
        return new WrapperPredicate(!predicate.isNegate(), predicate);
    }

    public static Input input(int clickedSlot, @Nullable EquipmentSlot equipmentSlot, boolean isOccupied) {
        return new Input(clickedSlot, equipmentSlot, isOccupied);
    }

    public PredicateResult matches(Input input) {
        PredicateResult basicMatch = this._matches(input);
        ArrayList<PipelineDebug> debugs = new ArrayList<PipelineDebug>();
        if (this.negate) {
            debugs.add(PipelineDebug.root("Negating result, was " + basicMatch.result + " became " + !basicMatch.result, new PipelineDebug.Tag[0]).appendAllAndReturnSelf(basicMatch.pipelineDebugs));
        } else {
            debugs.addAll(basicMatch.pipelineDebugs);
        }
        return new PredicateResult(basicMatch.result ^ this.negate, debugs);
    }

    protected abstract PredicateResult _matches(Input var1);

    @Generated
    private SlotPredicate(boolean negate) {
        this.negate = negate;
    }

    @Generated
    public boolean isNegate() {
        return this.negate;
    }

    private static class StaticSlotPredicate
    extends SlotPredicate {
        private final int slot;

        private StaticSlotPredicate(boolean negate, int slot) {
            super(negate);
            this.slot = slot;
        }

        @Override
        public PredicateResult _matches(Input input) {
            return new PredicateResult(input.clickedSlot == this.slot, Collections.singletonList(PipelineDebug.root("Static slot, clicked slot " + input.clickedSlot + " configured slot " + this.slot + " result: " + (input.clickedSlot == this.slot), new PipelineDebug.Tag[0])));
        }
    }

    private static class SlotRangePredicate
    extends SlotPredicate {
        private final int start;
        private final int end;

        private SlotRangePredicate(boolean negate, int slot1, int slot2) {
            super(negate);
            this.start = Math.min(slot1, slot2);
            this.end = Math.max(slot1, slot2);
        }

        @Override
        public PredicateResult _matches(Input input) {
            boolean result = input.clickedSlot >= this.start && input.clickedSlot <= this.end;
            return new PredicateResult(result, Collections.singletonList(PipelineDebug.root("Slot range, " + this.start + " <= " + input.clickedSlot + " <= " + this.end + ", result: " + result, new PipelineDebug.Tag[0])));
        }
    }

    private static class EquipmentSlotPredicate
    extends SlotPredicate {
        private final EquipmentSlot slot;

        private EquipmentSlotPredicate(boolean negate, EquipmentSlot slot) {
            super(negate);
            this.slot = slot;
        }

        @Override
        public PredicateResult _matches(Input input) {
            boolean result = input.getEquipmentSlot().map(slot -> slot == this.slot).getOrElse(false);
            return new PredicateResult(result, Collections.singletonList(PipelineDebug.root("Equipment slot predicate, input " + input.getEquipmentSlot().map(Enum::name).getOrElse("null") + ", configured " + String.valueOf(this.slot) + " result " + result, new PipelineDebug.Tag[0])));
        }
    }

    private static class UnionSlotPredicate
    extends SlotPredicate {
        private final List<SlotPredicate> predicates;

        private UnionSlotPredicate(boolean negate, Collection<SlotPredicate> predicates) {
            super(negate);
            this.predicates = new ArrayList<SlotPredicate>(predicates);
        }

        @Override
        public PredicateResult _matches(Input input) {
            boolean anyMatch = false;
            boolean anyNonNegateMatch = false;
            ArrayList<PipelineDebug> pipelineDebugs = new ArrayList<PipelineDebug>();
            for (SlotPredicate predicate : this.predicates) {
                int indexOf = this.predicates.indexOf(predicate);
                PredicateResult predicateResult = predicate.matches(input);
                if (predicate.isNegate() && !predicateResult.result) {
                    return new PredicateResult(false, Collections.singletonList(PipelineDebug.root("Predicate is negated and its result is not true - " + indexOf, new PipelineDebug.Tag[0]).appendAllAndReturnSelf(predicateResult.pipelineDebugs)));
                }
                if (!predicate.isNegate()) {
                    if (predicateResult.result) {
                        anyMatch = true;
                    }
                    anyNonNegateMatch = true;
                    pipelineDebugs.add(PipelineDebug.root("Found match: " + predicateResult.result + " anyMatch: " + anyMatch, new PipelineDebug.Tag[0]).appendAllAndReturnSelf(predicateResult.getPipelineDebugs()));
                    continue;
                }
                pipelineDebugs.add(PipelineDebug.root("Negate predicate, skipping it, data so far anyMatch: " + anyMatch + " nonNegateMatch: " + anyNonNegateMatch, new PipelineDebug.Tag[0]).appendAllAndReturnSelf(predicateResult.getPipelineDebugs()));
            }
            if (!anyMatch && !anyNonNegateMatch) {
                pipelineDebugs.add(PipelineDebug.root("No match, also there is no negates, so its true", new PipelineDebug.Tag[0]));
                return new PredicateResult(true, pipelineDebugs);
            }
            pipelineDebugs.add(PipelineDebug.root("Unification is done, result " + anyMatch, new PipelineDebug.Tag[0]));
            return new PredicateResult(anyMatch, pipelineDebugs);
        }
    }

    private static class AnySlotPredicate
    extends SlotPredicate {
        private static final AnySlotPredicate INSTANCE = new AnySlotPredicate();

        private AnySlotPredicate() {
            super(false);
        }

        @Override
        protected PredicateResult _matches(Input input) {
            return new PredicateResult(true, Collections.singletonList(PipelineDebug.root("Any slot - true", new PipelineDebug.Tag[0])));
        }
    }

    private static class WrapperPredicate
    extends SlotPredicate {
        SlotPredicate predicate;

        private WrapperPredicate(boolean negate, SlotPredicate predicate) {
            super(negate);
            this.predicate = predicate;
        }

        @Override
        protected PredicateResult _matches(Input input) {
            PredicateResult result = this.predicate.matches(input);
            return new PredicateResult(result.result, result.pipelineDebugs);
        }
    }

    public static class Input {
        private final int clickedSlot;
        @Nullable
        private final EquipmentSlot equipmentSlot;
        private final boolean isOccupied;

        public Option<EquipmentSlot> getEquipmentSlot() {
            return Option.of(this.equipmentSlot);
        }

        @Generated
        public Input(int clickedSlot, @Nullable EquipmentSlot equipmentSlot, boolean isOccupied) {
            this.clickedSlot = clickedSlot;
            this.equipmentSlot = equipmentSlot;
            this.isOccupied = isOccupied;
        }

        @Generated
        public int getClickedSlot() {
            return this.clickedSlot;
        }

        @Generated
        public boolean isOccupied() {
            return this.isOccupied;
        }

        @Generated
        public String toString() {
            return "SlotPredicate.Input(clickedSlot=" + this.getClickedSlot() + ", equipmentSlot=" + String.valueOf(this.getEquipmentSlot()) + ", isOccupied=" + this.isOccupied() + ")";
        }
    }

    public static class PredicateResult {
        private final boolean result;
        private final List<PipelineDebug> pipelineDebugs;

        @Generated
        public PredicateResult(boolean result, List<PipelineDebug> pipelineDebugs) {
            this.result = result;
            this.pipelineDebugs = pipelineDebugs;
        }

        @Generated
        public boolean isResult() {
            return this.result;
        }

        @Generated
        public List<PipelineDebug> getPipelineDebugs() {
            return this.pipelineDebugs;
        }
    }
}

