/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.text;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringSimilarityUtils {
    public static List<String> getSuggestions(String input, Stream<String> options) {
        return options.map(s -> new AbstractMap.SimpleEntry<String, Double>((String)s, StringSimilarityUtils.jaroDistance(s, input))).sorted(Comparator.comparingDouble(entry -> -((Double)entry.getValue()).doubleValue())).limit(5L).map(AbstractMap.SimpleEntry::getKey).collect(Collectors.toList());
    }

    public static double jaroDistance(String s1, String s2) {
        if (s1 == s2) {
            return 1.0;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int max_dist = (int)(Math.floor(Math.max(len1, len2) / 2) - 1.0);
        int match = 0;
        int[] hash_s1 = new int[s1.length()];
        int[] hash_s2 = new int[s2.length()];
        block0: for (int i = 0; i < len1; ++i) {
            for (int j = Math.max(0, i - max_dist); j < Math.min(len2, i + max_dist + 1); ++j) {
                if (s1.charAt(i) != s2.charAt(j) || hash_s2[j] != 0) continue;
                hash_s1[i] = 1;
                hash_s2[j] = 1;
                ++match;
                continue block0;
            }
        }
        if (match == 0) {
            return 0.0;
        }
        double t = 0.0;
        int point = 0;
        for (int i = 0; i < len1; ++i) {
            if (hash_s1[i] != 1) continue;
            while (hash_s2[point] == 0) {
                ++point;
            }
            if (s1.charAt(i) == s2.charAt(point++)) continue;
            t += 1.0;
        }
        return ((double)match / (double)len1 + (double)match / (double)len2 + ((double)match - (t /= 2.0)) / (double)match) / 3.0;
    }
}

