/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.support;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.session.SessionManager;
import io.vavr.control.Validation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;

public class WorldGuardSupport {
    private static final String NAME = "WorldGuard";

    public static boolean isPluginEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled(NAME);
    }

    public static void ensureStateFlagIsValid(String flagName) {
        if (!WorldGuardSupport.isPluginEnabled()) {
            throw new InvalidConfigurationException("Plugin WorldGuard is not enabled!");
        }
        Flag<?> flag = WorldGuardSupport.getFlag(flagName);
        if (flag == null) {
            throw new InvalidConfigurationException("Unknown state flag: " + flagName);
        }
        if (!(flag instanceof StateFlag)) {
            throw new InvalidConfigurationException("Flag " + flagName + " is not a state flag!");
        }
    }

    public static Validation<StateTestError, Boolean> checkState(@Nullable Player player, Location location, String flagName) {
        if (!WorldGuardSupport.isPluginEnabled()) {
            return StateTestError.PLUGIN_NOT_ENABLED.asInvalid();
        }
        Flag<?> flag = WorldGuardSupport.getFlag(flagName);
        if (flag == null) {
            return StateTestError.UNKNOWN_FLAG.asInvalid();
        }
        if (flag instanceof StateFlag) {
            return Validation.valid(WorldGuardSupport.test(player, location, (StateFlag)flag));
        }
        return StateTestError.NOT_A_STATE_FLAG.asInvalid();
    }

    private static SessionManager getSessionManager() {
        return WorldGuard.getInstance().getPlatform().getSessionManager();
    }

    private static Flag<?> getFlag(String flagName) {
        return Flags.fuzzyMatchFlag((FlagRegistry)WorldGuard.getInstance().getFlagRegistry(), (String)flagName);
    }

    private static boolean test(@Nullable Player player, Location location, StateFlag flag) {
        if (WorldGuardSupport.hasBypass(player)) {
            return true;
        }
        LocalPlayer localPlayer = player == null ? null : WorldGuardPlugin.inst().wrapPlayer(player);
        return WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().testState(BukkitAdapter.adapt((Location)location), localPlayer, new StateFlag[]{flag});
    }

    private static boolean hasBypass(Player player) {
        return WorldGuardSupport.getSessionManager().hasBypass(WorldGuardPlugin.inst().wrapPlayer(player), BukkitAdapter.adapt((World)player.getWorld()));
    }

    public static enum StateTestError {
        PLUGIN_NOT_ENABLED,
        UNKNOWN_FLAG,
        NOT_A_STATE_FLAG;


        public <R> Validation<StateTestError, R> asInvalid() {
            return Validation.invalid(this);
        }
    }
}

