/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.support;

import io.vavr.Lazy;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class OraxenSupport {
    private static final String NAME = "Oraxen";
    private static final String MAIN_PACKAGE = "io.th0rgal.oraxen";
    private static final String MAIN_API_PACKAGE = "io.th0rgal.oraxen.api";
    private static final Lazy<Class<?>> ORAXEN_ITEMS_CLASS_LAZY = Lazy.of(() -> {
        try {
            return Class.forName(MAIN_API_PACKAGE + ".OraxenItems");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    });

    public static ItemStack getItem(String key) {
        OraxenSupport.ensureEnabled();
        Class<?> nexoItemsClass = ORAXEN_ITEMS_CLASS_LAZY.get();
        Optional<ItemStack> instance = ((Optional)nexoItemsClass.getMethod("getOptionalItemById", String.class).invoke(null, key)).map(itemBuilder -> {
            try {
                return (ItemStack)itemBuilder.getClass().getMethod("build", new Class[0]).invoke(itemBuilder, new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        return instance.orElseThrow(() -> new IllegalArgumentException("Unknown item: " + key));
    }

    public static void ensureEnabled() {
        if (!OraxenSupport.isPluginEnabled()) {
            throw new IllegalStateException("Plugin Oraxen is not enabled!");
        }
    }

    public static boolean isPluginEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled(NAME);
    }
}

