/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.slot;

import io.vavr.control.Option;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

public class EquipmentToSlotConverter {
    public static int convert(EquipmentSlot equipmentSlot, int handSlot) {
        if (equipmentSlot.name().equals("OFF_HAND")) {
            return 40;
        }
        switch (equipmentSlot) {
            case HAND: {
                return handSlot;
            }
            case FEET: {
                return 36;
            }
            case LEGS: {
                return 37;
            }
            case CHEST: {
                return 38;
            }
            case HEAD: {
                return 39;
            }
        }
        throw new IllegalStateException("Unknown equipment slot: " + String.valueOf(equipmentSlot));
    }

    public static Option<EquipmentSlot> convert(int slot, Player player) {
        switch (slot) {
            case 40: {
                return Option.some(EquipmentSlot.valueOf((String)"OFF_HAND"));
            }
            case 36: {
                return Option.some(EquipmentSlot.FEET);
            }
            case 37: {
                return Option.some(EquipmentSlot.LEGS);
            }
            case 38: {
                return Option.some(EquipmentSlot.CHEST);
            }
            case 39: {
                return Option.some(EquipmentSlot.HEAD);
            }
        }
        if (player.getInventory().getHeldItemSlot() == slot) {
            return Option.of(EquipmentSlot.HAND);
        }
        return Option.none();
    }
}

