/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.raytrace;

import io.vavr.Tuple;
import io.vavr.control.Option;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import ua.valeriishymchuk.simpleitemgenerator.common.boundingbox.BoundingBox;
import ua.valeriishymchuk.simpleitemgenerator.common.raytrace.IRayTraceResult;
import ua.valeriishymchuk.simpleitemgenerator.common.raytrace.RayTraceBlockResult;
import ua.valeriishymchuk.simpleitemgenerator.common.raytrace.RayTraceEntityResult;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectedRepresentations;
import ua.valeriishymchuk.simpleitemgenerator.joml.Math;
import ua.valeriishymchuk.simpleitemgenerator.joml.Matrix3d;
import ua.valeriishymchuk.simpleitemgenerator.joml.Vector2d;
import ua.valeriishymchuk.simpleitemgenerator.joml.Vector3d;

public class RayTraceHelper {
    public static final double EPSILON = 1.0E-7;

    public static IRayTraceResult rayTrace(LivingEntity entity, Set<Material> transparent, int distance, int blockDistance) {
        RayTraceBlockResult rayTraceBlockResult = (RayTraceBlockResult)RayTraceHelper.getFirstBlockOnTheLine(entity, transparent, blockDistance).getOrNull();
        RayTraceEntityResult rayTraceEntityResult = (RayTraceEntityResult)RayTraceHelper.getFirstEntityOnTheLine(entity, distance).getOrNull();
        if (rayTraceBlockResult == null) {
            return Option.of(rayTraceEntityResult).getOrElse((RayTraceEntityResult)IRayTraceResult.MISS);
        }
        if (rayTraceEntityResult == null) {
            return rayTraceBlockResult;
        }
        Location entityIntersection = rayTraceEntityResult.getHitLocation();
        Location blockIntersection = rayTraceBlockResult.getHitLocation();
        Location casterLoc = entity.getEyeLocation();
        if (entityIntersection.distanceSquared(casterLoc) < blockIntersection.distanceSquared(casterLoc)) {
            return rayTraceEntityResult;
        }
        return rayTraceBlockResult;
    }

    private static Option<RayTraceBlockResult> getFirstBlockOnTheLine(LivingEntity livingEntity, Set<Material> transparent, int distance) {
        Block block = livingEntity.getLineOfSight(transparent, distance).stream().filter(b -> !transparent.contains(b.getType())).findFirst().orElse(null);
        if (block == null) {
            return Option.none();
        }
        Location startLoc = livingEntity.getEyeLocation();
        Vector3d startLine = new Vector3d(startLoc.getX(), startLoc.getY(), startLoc.getZ());
        Vector lookVectorBukkit = livingEntity.getLocation().getDirection();
        Vector3d lookVector = new Vector3d(lookVectorBukkit.getX(), lookVectorBukkit.getY(), lookVectorBukkit.getZ());
        Vector3d endLine = startLine.add(lookVector.mul(distance), new Vector3d());
        BoundingBox blocksBox = new BoundingBox(block.getX(), block.getY(), block.getZ(), block.getX() + 1, block.getY() + 1, block.getZ() + 1);
        return blocksBox.intersects(startLine, endLine).map(point -> new RayTraceBlockResult(block, new Location(livingEntity.getWorld(), point.getPoint().x(), point.getPoint().y(), point.getPoint().z()), point.getFace()));
    }

    private static Option<RayTraceEntityResult> getFirstEntityOnTheLine(LivingEntity livingEntity, int distance) {
        Location startLoc = livingEntity.getEyeLocation();
        Vector3d startLine = new Vector3d(startLoc.getX(), startLoc.getY(), startLoc.getZ());
        Vector lookVectorBukkit = livingEntity.getLocation().getDirection();
        Vector3d lookVector = new Vector3d(lookVectorBukkit.getX(), lookVectorBukkit.getY(), lookVectorBukkit.getZ());
        Vector3d endLine = startLine.add(lookVector.mul(distance), new Vector3d());
        Optional<RayTraceEntityResult> opt = livingEntity.getNearbyEntities((double)distance, (double)distance, (double)distance).stream().map(entity -> {
            BoundingBox boundingBox = ReflectedRepresentations.Entity.getEntitiesBoundingBox(entity);
            return Tuple.of((BoundingBox.IntersectResult)boundingBox.intersects(startLine, endLine).getOrNull(), entity);
        }).filter(tuple -> tuple._1() != null).map(tuple -> new RayTraceEntityResult((Entity)tuple._2(), new Location(livingEntity.getWorld(), ((BoundingBox.IntersectResult)tuple._1()).getPoint().x(), ((BoundingBox.IntersectResult)tuple._1()).getPoint().y(), ((BoundingBox.IntersectResult)tuple._1()).getPoint().z()))).min(Comparator.comparingDouble(res -> livingEntity.getEyeLocation().distance(res.hitLocation)));
        return Option.ofOptional(opt);
    }

    private static Matrix3d getMinecraftPlaneMatrix(Vector3d planeNormal) {
        Vector3d upVector = new Vector3d(0.0, 1.0, 0.0);
        double dot = (planeNormal = planeNormal.normalize(new Vector3d())).dot(upVector);
        if (Math.abs(dot) == 1.0) {
            return new Matrix3d(new Vector3d(1.0, 0.0, 0.0), planeNormal, new Vector3d(0.0, 0.0, dot));
        }
        Vector3d nupvort = upVector.cross(planeNormal, new Vector3d()).normalize();
        Vector3d yland = planeNormal.cross(nupvort, new Vector3d()).normalize();
        Vector3d xland = planeNormal.cross(yland, new Vector3d()).normalize();
        return new Matrix3d(xland, planeNormal, yland);
    }

    public static Option<Vector3d> findLineAndPlaneIntersection(Vector3d la, Vector3d lb, Vector3d origin, Vector3d normal) {
        Vector3d pointOnPlaneA = RayTraceHelper.getPointOfPlane(origin, normal, new Vector2d(1.0, 0.0));
        Vector3d pointOnPlaneB = RayTraceHelper.getPointOfPlane(origin, normal, new Vector2d(0.0, 1.0));
        return RayTraceHelper.findLineAndPlaneIntersection(la, lb, origin, pointOnPlaneA, pointOnPlaneB);
    }

    public static Vector3d getPointOfPlane(Vector3d point, Vector3d normal, Vector2d pointOnPlane) {
        Vector3d pointOnPlane3d = new Vector3d(pointOnPlane.x, 0.0, pointOnPlane.y);
        Matrix3d matrix3d = RayTraceHelper.getMinecraftPlaneMatrix(normal);
        return matrix3d.transform(pointOnPlane3d).add(point);
    }

    public static Vector2d getPointFromPlane(Vector3d planeOrigin, Vector3d planeNormal, Vector3d pointOnPlane) {
        Matrix3d inverseMatrix3d = RayTraceHelper.getMinecraftPlaneMatrix(planeNormal).invert();
        Vector3d transformedPoint = pointOnPlane.sub(planeOrigin, new Vector3d()).mul(inverseMatrix3d);
        return new Vector2d(transformedPoint.x, transformedPoint.z);
    }

    public static Option<Vector3d> findLineAndPlaneIntersection(Vector3d la, Vector3d lb, Vector3d p0, Vector3d p1, Vector3d p2) {
        Vector3d lab = lb.sub(la, new Vector3d());
        Vector3d p01 = p1.sub(p0, new Vector3d());
        Vector3d p02 = p2.sub(p0, new Vector3d());
        double denominator = new Matrix3d(lab.mul(-1.0, new Vector3d()), p01, p02).determinant();
        if (denominator == 0.0) {
            return Option.none();
        }
        double t = p01.cross(p02, new Vector3d()).dot(la.sub(p0, new Vector3d())) / lab.mul(-1.0, new Vector3d()).dot(p01.cross(p02, new Vector3d()));
        return Option.some(la.add(lab.mul(t, new Vector3d()), new Vector3d()));
    }

    private static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    private static long lfloor(double value) {
        long l = (long)value;
        return value < (double)l ? l - 1L : l;
    }

    private static double frac(double value) {
        return value - (double)RayTraceHelper.lfloor(value);
    }
}

