/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.metrics;

import java.util.function.Supplier;
import org.bukkit.plugin.java.JavaPlugin;
import ua.valeriishymchuk.simpleitemgenerator.bstats.bukkit.Metrics;
import ua.valeriishymchuk.simpleitemgenerator.bstats.charts.SingleLineChart;

public class MetricsHelper {
    private static final int PLUGIN_ID = 24157;
    private static Metrics METRICS = null;

    public static void init(JavaPlugin plugin) {
        if (METRICS != null) {
            throw new IllegalStateException("Metrics already initialized!");
        }
        METRICS = new Metrics(plugin, 24157);
    }

    public static void initTotalItemsChart(Supplier<Integer> itemAmountCallback) {
        MetricsHelper.ensureInitialized();
        METRICS.addCustomChart(new SingleLineChart("custom-items", itemAmountCallback::get));
    }

    public static void initPluginActivityChart(Supplier<Boolean> callback) {
        MetricsHelper.ensureInitialized();
        METRICS.addCustomChart(new SingleLineChart("plugin_activity", () -> (Boolean)callback.get() != false ? 1 : 0));
    }

    private static void ensureInitialized() {
        if (METRICS == null) {
            throw new IllegalStateException("Metrics not initialized!");
        }
    }

    public static void shutdown() {
        if (METRICS != null) {
            METRICS.shutdown();
        }
    }
}

