/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.item;

import com.google.common.primitives.Floats;
import io.vavr.API;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.common.config.DefaultLoader;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.common.custommodeldata.CustomModelDataHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.item.Attribute;
import ua.valeriishymchuk.simpleitemgenerator.common.item.AttributeApplier;
import ua.valeriishymchuk.simpleitemgenerator.common.message.KyoriHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ReflectedRepresentations;
import ua.valeriishymchuk.simpleitemgenerator.common.text.StringSimilarityUtils;
import ua.valeriishymchuk.simpleitemgenerator.common.time.TimeTokenParser;
import ua.valeriishymchuk.simpleitemgenerator.common.version.FeatureSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SemanticVersion;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.color.Color;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.component.builtin.item.ItemCustomModelData;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurationNode;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.ConfigSerializable;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public class RawItem
implements Cloneable {
    public static final RawItem EMPTY = new RawItem();
    private static final Pattern COLOR_PATTERN = Pattern.compile("^ *\\[(?<type>dye|hex|decimal)] *(?<value>#?\\w+) *$");
    private String material;
    @Nullable
    private String name;
    private List<String> lore;
    @Setting(value="cmd")
    @Nullable
    private ConfigurationNode customModelData;
    @Nullable
    private Boolean unbreakable;
    private List<String> itemFlags;
    private Map<String, Integer> enchantments;
    private List<ConfigurationNode> attributes;
    @Nullable
    private ConfigurationNode color;
    @Nullable
    private ConfigurationNode potion;
    @Nullable
    private Integer durability;

    private RawItem() {
        this(null, null, Collections.emptyList(), null, null, Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), null, null, null);
    }

    private List<PotionEffect> getPotionEffects() throws InvalidConfigurationException {
        int i = -1;
        try {
            if (this.potion == null || this.potion.isNull()) {
                return Collections.emptyList();
            }
            if (!this.potion.isList()) {
                throw new InvalidConfigurationException("Potion node should be a list");
            }
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
            List<ConfigurationNode> rawList = this.potion.getList(ConfigurationNode.class);
            ++i;
            for (ConfigurationNode node : rawList) {
                if (!node.isMap()) {
                    throw new InvalidConfigurationException("Not a map");
                }
                List<String> allowedKeys = Arrays.asList("type", "duration", "amplifier", "show-particles", "show-icon", "ambient");
                List unknownKeys = node.childrenMap().keySet().stream().map(Object::toString).filter(s -> !allowedKeys.contains(s)).collect(Collectors.toList());
                if (!unknownKeys.isEmpty()) {
                    throw new InvalidConfigurationException("Unknown keys in potion: " + String.valueOf(unknownKeys));
                }
                String rawType = node.node("type").getString();
                if (rawType == null) {
                    throw new InvalidConfigurationException("'type' property is not defined");
                }
                Try<PotionEffectType> potionTry = Try.of(() -> PotionEffectType.getByName((String)rawType)).filter(Objects::nonNull).mapFailure(API.Case(API.$(), e -> {
                    List<String> list = StringSimilarityUtils.getSuggestions(rawType, Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getName));
                    return InvalidConfigurationException.unknownOption("potion type", rawType, list);
                }));
                PotionEffectType potion = potionTry.get();
                int duration = (Integer)Try.of(() -> node.node("duration").getString("1s")).map(TimeTokenParser::parse).map(l -> l / 50L).map(Long::intValue).getOrElseThrow(e -> InvalidConfigurationException.path("duration", e));
                int amplifier = Try.of(() -> node.node("amplifier").getString()).map(s -> s == null ? "1" : s).mapTry(Integer::parseInt).filter(n -> n > 0 && n <= 256).getOrElseThrow(e -> new InvalidConfigurationException("'amplifier' is invalid. Should be an integer from 1 to 256")) - 1;
                boolean showParticles = Try.of(() -> node.node("show-particles").getBoolean(true)).getOrElseThrow(e -> new InvalidConfigurationException("'show-particles' is invalid. Should be true or false"));
                boolean showIcon = Try.of(() -> node.node("show-icon").getBoolean(true)).getOrElseThrow(e -> new InvalidConfigurationException("'show-icon' is invalid. Should be true or false"));
                boolean ambient = Try.of(() -> node.node("ambient").getBoolean(true)).getOrElseThrow(e -> new InvalidConfigurationException("'ambient' is invalid. Should be true or false"));
                PotionEffect effect = ReflectedRepresentations.PotionEffect.create(potion, duration, amplifier, ambient, showParticles, showIcon).getOrElse(new PotionEffect(potion, duration, amplifier, ambient, showParticles));
                effects.add(effect);
                ++i;
            }
            return effects;
        }
        catch (Exception e2) {
            if (i == -1) {
                throw InvalidConfigurationException.path("potion", e2);
            }
            throw InvalidConfigurationException.path("potion, " + i, e2);
        }
    }

    private Option<org.bukkit.Color> getColor() {
        try {
            if (this.color == null) {
                return Option.none();
            }
            if (this.color.isNull()) {
                return Option.none();
            }
            if (this.color.isList()) {
                throw new InvalidConfigurationException("Color node should be a value or a map");
            }
            if (!this.color.isMap()) {
                int colorInt;
                String rawValue = this.color.getString();
                Matcher matcher = COLOR_PATTERN.matcher(rawValue);
                if (!matcher.matches()) {
                    throw new InvalidConfigurationException("Invalid color value: " + rawValue + ". Expected: [dye|hex|decimal] <value>");
                }
                String type = matcher.group("type");
                String value = matcher.group("value").toUpperCase();
                if (type.equals("dye")) {
                    Try<DyeColor> colorTry = Try.of(() -> DyeColor.valueOf((String)value)).mapFailure(API.Case(API.$(), e -> {
                        List<String> list = StringSimilarityUtils.getSuggestions(value, Arrays.stream(DyeColor.values()).map(Enum::name));
                        return InvalidConfigurationException.unknownOption("dye color", value, list);
                    }));
                    DyeColor dyeColor = colorTry.get();
                    return Option.some(dyeColor.getColor());
                }
                boolean isHex = type.equals("hex");
                try {
                    if (isHex) {
                        String hex = value.startsWith("0X") ? value.substring(2) : (value.startsWith("#") ? value.substring(1) : value);
                        if (hex.isEmpty()) {
                            throw new InvalidConfigurationException("Invalid hexadecimal value: " + value + ". Should be like ffff00 or 0xffff00");
                        }
                        colorInt = Integer.parseInt(hex, 16);
                    } else {
                        colorInt = Integer.parseInt(value);
                    }
                }
                catch (NumberFormatException e2) {
                    if (isHex) {
                        throw new InvalidConfigurationException("Invalid hexadecimal value: " + value + ". Should be like ffff00 or 0xffff00");
                    }
                    throw new InvalidConfigurationException("Invalid int value: " + value + ". Should be an integer value");
                }
                return Option.some(org.bukkit.Color.fromRGB((int)colorInt));
            }
            if (!this.color.hasChild("red")) {
                throw new InvalidConfigurationException("'red' property is missing");
            }
            if (!this.color.hasChild("green")) {
                throw new InvalidConfigurationException("'green' property is missing");
            }
            if (!this.color.hasChild("blue")) {
                throw new InvalidConfigurationException("'blue' property is missing");
            }
            long nonColorProperties = this.color.childrenMap().keySet().stream().map(Object::toString).filter(s -> !s.equals("red") && !s.equals("green") && !s.equals("blue")).count();
            if (nonColorProperties > 0L) {
                throw new InvalidConfigurationException("Only 'red', 'green' and 'blue' properties are allowed");
            }
            int red = (Integer)Try.of(() -> this.color.node("red").get(Integer.class)).filter(Objects::nonNull).filter(i -> i >= 0 && i <= 255).getOrElseThrow(() -> new InvalidConfigurationException("red property should be an integer from 0 to 255"));
            int blue = (Integer)Try.of(() -> this.color.node("blue").get(Integer.class)).filter(Objects::nonNull).filter(i -> i >= 0 && i <= 255).getOrElseThrow(() -> new InvalidConfigurationException("blue property should be an integer from 0 to 255"));
            int green = (Integer)Try.of(() -> this.color.node("green").get(Integer.class)).filter(Objects::nonNull).filter(i -> i >= 0 && i <= 255).getOrElseThrow(() -> new InvalidConfigurationException("green property should be an integer from 0 to 255"));
            return Option.some(org.bukkit.Color.fromRGB((int)red, (int)green, (int)blue));
        }
        catch (Exception e3) {
            throw InvalidConfigurationException.path("color", e3);
        }
    }

    public RawItem clone() {
        return this.withName(this.name);
    }

    public RawItem withCmd(int cmd) {
        RawItem.ensureCmdSupport();
        Object rawCmd = DefaultLoader.yaml().createNode();
        rawCmd.set(cmd);
        return this.withCustomModelData((ConfigurationNode)rawCmd);
    }

    public RawItem withCmd(float ... cmds) {
        RawItem.ensureModernCmdSupport();
        Object rawCmd = DefaultLoader.yaml().createNode();
        if (cmds.length == 0) {
            return this;
        }
        if (cmds.length == 1) {
            rawCmd.set(Float.valueOf(cmds[0]));
        } else {
            rawCmd.setList(Float.class, (List<Float>)Floats.asList((float[])cmds));
        }
        return this.withCustomModelData((ConfigurationNode)rawCmd);
    }

    private static void ensureModernCmdSupport() {
        if (!FeatureSupport.MODERN_CMD_SUPPORT) {
            throw new UnsupportedOperationException("Modern custom model data is supported from >=1.21.4. Current version " + String.valueOf(SemanticVersion.CURRENT_MINECRAFT));
        }
    }

    private static void ensureCmdSupport() {
        if (!FeatureSupport.CMD_SUPPORT) {
            throw new UnsupportedOperationException("Custom model data is supported from >=1.14. Current version " + String.valueOf(SemanticVersion.CURRENT_MINECRAFT));
        }
    }

    private static int parseInt(ConfigurationNode s) throws InvalidConfigurationException {
        return Option.of(s.getString()).toTry(() -> new InvalidConfigurationException("Invalid custom model data")).mapTry(Integer::parseInt).mapFailure(API.Case(API.$(e -> e instanceof NumberFormatException), e -> InvalidConfigurationException.format("Not a number: <white>%s</white>.", s.raw()))).get();
    }

    private static float parseFloat(ConfigurationNode s) throws InvalidConfigurationException {
        return Option.of(s.getString()).toTry(() -> new InvalidConfigurationException("Invalid custom model data")).mapTry(Float::parseFloat).mapFailure(API.Case(API.$(e -> e instanceof NumberFormatException), e -> InvalidConfigurationException.format("Not a number: <white>%s</white>.", s.raw()))).get().floatValue();
    }

    public Option<ItemCustomModelData> getCustomModelData() throws InvalidConfigurationException {
        ItemCustomModelData cmd;
        if (this.customModelData == null || this.customModelData.isNull()) {
            return Option.none();
        }
        boolean isCmdSupported = FeatureSupport.CMD_SUPPORT;
        boolean isModernCmdSupported = FeatureSupport.MODERN_CMD_SUPPORT;
        try {
            boolean isScalar;
            if (!isCmdSupported) {
                throw new InvalidConfigurationException("Custom model data is supported from >=1.14. Current version " + String.valueOf(SemanticVersion.CURRENT_MINECRAFT));
            }
            boolean nodeIsList = this.customModelData.isList();
            boolean nodeIsMap = this.customModelData.isMap();
            boolean bl = isScalar = !nodeIsList && !nodeIsMap;
            if (!isScalar && !isModernCmdSupported) {
                throw new InvalidConfigurationException("Modern custom model data(list of floats) is supported from >=1.21.4. Current version " + String.valueOf(SemanticVersion.CURRENT_MINECRAFT));
            }
            if (!isModernCmdSupported) {
                cmd = new ItemCustomModelData(RawItem.parseInt(this.customModelData));
            } else if (nodeIsList) {
                List<Float> floats = this.customModelData.getList(ConfigurationNode.class).stream().map(RawItem::parseFloat).collect(Collectors.toList());
                cmd = new ItemCustomModelData(floats, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            } else if (isScalar) {
                cmd = new ItemCustomModelData(Collections.singletonList(Float.valueOf(RawItem.parseFloat(this.customModelData))), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            } else {
                List<String> stringList;
                List<Boolean> flagList;
                List<Float> floatList;
                ConfigurationNode floats = this.customModelData.node("floats");
                ConfigurationNode flags = this.customModelData.node("flags");
                ConfigurationNode strings = this.customModelData.node("strings");
                ConfigurationNode colors = this.customModelData.node("colors");
                List<Float> list = floats.isNull() ? Collections.emptyList() : (floatList = floats.isList() ? floats.getList(ConfigurationNode.class).stream().map(RawItem::parseFloat).collect(Collectors.toList()) : Collections.singletonList(Float.valueOf(RawItem.parseFloat(floats))));
                List<Boolean> list2 = flags.isNull() ? Collections.emptyList() : (flagList = flags.isList() ? flags.getList(Boolean.class) : Collections.singletonList(flags.getBoolean()));
                List<String> list3 = strings.isNull() ? Collections.emptyList() : (stringList = strings.isList() ? strings.getList(String.class) : Collections.singletonList(strings.getString()));
                List colorList = colors.isNull() ? Collections.emptyList() : (colors.isList() ? colors.getList(ConfigurationNode.class).stream().map(RawItem::parseInt).collect(Collectors.toList()) : Collections.singletonList(RawItem.parseInt(colors)));
                cmd = new ItemCustomModelData(floatList, flagList, stringList, colorList.stream().map(Color::new).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            throw InvalidConfigurationException.path("cmd", e);
        }
        return Option.some(cmd);
    }

    public List<Float> getModernCmd() {
        if (this.customModelData == null || this.customModelData.isNull()) {
            return Collections.emptyList();
        }
        if (this.customModelData.isList()) {
            return this.customModelData.getList(Float.class);
        }
        return Collections.singletonList(Float.valueOf(this.customModelData.getFloat()));
    }

    public RawItem replace(String placeholder, String value) {
        return this.withName((String)Option.of(this.name).map(s -> s.replace(placeholder, value)).getOrNull()).withLore(this.lore.stream().map(s -> s.replace(placeholder, value)).collect(Collectors.toList()));
    }

    public List<ItemFlag> getFlags() throws InvalidConfigurationException {
        if (this.itemFlags == null || this.itemFlags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>();
        int i = 0;
        for (String flag : this.itemFlags) {
            String rawFlag = flag.toUpperCase();
            Try<ItemFlag> flagTry = Try.of(() -> ItemFlag.valueOf((String)rawFlag)).mapFailure(API.Case(API.$(), e -> {
                List<String> list = Arrays.stream(ItemFlag.values()).map(Enum::name).map(m -> new AbstractMap.SimpleEntry<String, Double>((String)m, StringSimilarityUtils.jaroDistance(m, rawFlag))).filter(m -> (Double)m.getValue() > 0.8).sorted(Comparator.comparingDouble(entry -> -((Double)entry.getValue()).doubleValue())).limit(5L).map(AbstractMap.SimpleEntry::getKey).toList();
                return InvalidConfigurationException.format("Unknown flag <white>%s</white>. %s", flag, !list.isEmpty() ? "Did you mean: <white>" + String.valueOf(list) : "</white>");
            }));
            try {
                if (!flagTry.isSuccess()) {
                    throw flagTry.getCause();
                }
                flags.add(flagTry.get());
            }
            catch (Throwable e2) {
                throw InvalidConfigurationException.path("item-flags, " + i, e2);
            }
            ++i;
        }
        return flags;
    }

    public Material getMaterial() throws InvalidConfigurationException {
        try {
            if (this.material == null) {
                throw new InvalidConfigurationException("Property is not defined");
            }
            String rawMaterial = this.material.toUpperCase();
            Try<Material> materialTry = Try.of(() -> Material.valueOf((String)rawMaterial)).filter(Material::isItem).mapFailure(API.Case(API.$(), e -> {
                List<String> list = Arrays.stream(Material.values()).filter(Material::isItem).map(Enum::name).filter(m -> !m.startsWith("LEGACY_")).map(m -> new AbstractMap.SimpleEntry<String, Double>((String)m, StringSimilarityUtils.jaroDistance(m, rawMaterial))).filter(m -> (Double)m.getValue() > 0.8).sorted(Comparator.comparingDouble(entry -> -((Double)entry.getValue()).doubleValue())).limit(5L).map(AbstractMap.SimpleEntry::getKey).toList();
                return InvalidConfigurationException.format("Unknown material <white>%s</white>. %s", this.material, !list.isEmpty() ? "Did you mean: <white>" + String.valueOf(list) : "</white>");
            }));
            if (materialTry.isFailure()) {
                throw (InvalidConfigurationException)materialTry.getCause();
            }
            return materialTry.get();
        }
        catch (Exception e2) {
            throw InvalidConfigurationException.path("material", e2);
        }
    }

    public ItemStack bake() throws InvalidConfigurationException {
        ItemStack item;
        ItemStack preparedItem = ReflectedRepresentations.ItemStack.createItemStack(this.getMaterial());
        if (!this.attributes.isEmpty()) {
            AtomicInteger increment = new AtomicInteger();
            try {
                item = io.vavr.collection.List.ofAll(this.attributes.stream().map(attribute -> {
                    Attribute a = Attribute.fromNode(attribute);
                    increment.incrementAndGet();
                    return a;
                })).transform(list -> AttributeApplier.applyOnItem(list.toJavaList(), preparedItem));
            }
            catch (Throwable e2) {
                throw InvalidConfigurationException.path("attributes, " + increment.get(), e2);
            }
        } else {
            item = preparedItem;
        }
        ItemCustomModelData cmd = (ItemCustomModelData)this.getCustomModelData().getOrNull();
        if (FeatureSupport.MODERN_CMD_SUPPORT && cmd != null) {
            item = CustomModelDataHelper.applyModernCmd(item, cmd);
        }
        ItemMeta meta = item.getItemMeta();
        if (this.durability != null) {
            int damage = item.getType().getMaxDurability() - this.durability;
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                damageable.setDamage(damage);
            }
        }
        if (this.name != null) {
            meta.displayName(KyoriHelper.convert(KyoriHelper.parseMiniMessage(this.name)));
        }
        if (!this.lore.isEmpty()) {
            meta.lore(this.lore.stream().map(KyoriHelper::parseMiniMessage).map(KyoriHelper::convert).toList());
        }
        Option<org.bukkit.Color> colorOpt = this.getColor();
        if (meta instanceof LeatherArmorMeta && colorOpt.isDefined()) {
            ((LeatherArmorMeta)meta).setColor(colorOpt.get());
        } else if (meta instanceof PotionMeta && colorOpt.isDefined()) {
            boolean setColorSuccess = ReflectedRepresentations.PotionMeta.setColor((PotionMeta)meta, colorOpt.get());
            if (!setColorSuccess) {
                throw new InvalidConfigurationException("'color' node is not supported for potions until 1.11.");
            }
        } else if (colorOpt.isDefined()) {
            throw new InvalidConfigurationException("'color' node is not supported for this material.");
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            this.getPotionEffects().forEach(e -> potionMeta.addCustomEffect(e, true));
        }
        if (FeatureSupport.CMD_SUPPORT && !FeatureSupport.MODERN_CMD_SUPPORT && cmd != null) {
            this.setLegacyCustomModelData(meta, cmd.getLegacyId());
        }
        meta.addItemFlags(this.getFlags().toArray(new ItemFlag[0]));
        this.getEnchantments().forEach((ench, level) -> {
            if (meta instanceof EnchantmentStorageMeta) {
                ((EnchantmentStorageMeta)meta).addStoredEnchant(ench, level.intValue(), true);
            } else {
                meta.addEnchant(ench, level.intValue(), true);
            }
        });
        if (this.unbreakable != null) {
            meta.setUnbreakable(this.unbreakable.booleanValue());
        }
        item.setItemMeta(meta);
        return item;
    }

    private Map<Enchantment, Integer> getEnchantments() throws InvalidConfigurationException {
        if (this.enchantments == null || this.enchantments.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        try {
            for (Map.Entry<String, Integer> entry : this.enchantments.entrySet()) {
                try {
                    int level = entry.getValue();
                    String rawEnchantment = entry.getKey().toUpperCase();
                    Enchantment enchantment = Try.of(() -> Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)((String)entry.getKey())))).map(Option::of).toOption().flatMap(Function.identity()).getOrElse(Enchantment.getByName((String)rawEnchantment));
                    if (enchantment == null) {
                        List<String> list = Arrays.stream(Enchantment.values()).map(e -> e.getKey().asString()).map(e -> new AbstractMap.SimpleEntry<String, Double>((String)e, StringSimilarityUtils.jaroDistance(e, FeatureSupport.NAMESPACED_ENCHANTMENTS_SUPPORT ? (String)entry.getKey() : rawEnchantment))).filter(m -> (Double)m.getValue() > 0.8).sorted(Comparator.comparingDouble(e -> -((Double)e.getValue()).doubleValue())).limit(5L).map(AbstractMap.SimpleEntry::getKey).toList();
                        throw InvalidConfigurationException.format("Unknown enchantment <white>%s</white>. %s", entry.getKey(), !list.isEmpty() ? "Did you mean: <white>" + String.valueOf(list) + "</white>" : "");
                    }
                    map.put(enchantment, level);
                }
                catch (Throwable e2) {
                    throw InvalidConfigurationException.path(entry.getKey(), e2);
                }
            }
            return map;
        }
        catch (Exception e3) {
            throw InvalidConfigurationException.path("enchantments", e3);
        }
    }

    private void setLegacyCustomModelData(ItemMeta itemMeta, int cmd) {
        itemMeta.setCustomModelData(Integer.valueOf(cmd));
    }

    @Generated
    public RawItem(String material, @Nullable String name, List<String> lore, @Nullable ConfigurationNode customModelData, @Nullable Boolean unbreakable, List<String> itemFlags, Map<String, Integer> enchantments, List<ConfigurationNode> attributes, @Nullable ConfigurationNode color, @Nullable ConfigurationNode potion, @Nullable Integer durability) {
        this.material = material;
        this.name = name;
        this.lore = lore;
        this.customModelData = customModelData;
        this.unbreakable = unbreakable;
        this.itemFlags = itemFlags;
        this.enchantments = enchantments;
        this.attributes = attributes;
        this.color = color;
        this.potion = potion;
        this.durability = durability;
    }

    @Generated
    public RawItem withMaterial(String material) {
        return this.material == material ? this : new RawItem(material, this.name, this.lore, this.customModelData, this.unbreakable, this.itemFlags, this.enchantments, this.attributes, this.color, this.potion, this.durability);
    }

    @Generated
    public RawItem withName(@Nullable String name) {
        return this.name == name ? this : new RawItem(this.material, name, this.lore, this.customModelData, this.unbreakable, this.itemFlags, this.enchantments, this.attributes, this.color, this.potion, this.durability);
    }

    @Generated
    public RawItem withLore(List<String> lore) {
        return this.lore == lore ? this : new RawItem(this.material, this.name, lore, this.customModelData, this.unbreakable, this.itemFlags, this.enchantments, this.attributes, this.color, this.potion, this.durability);
    }

    @Generated
    public RawItem withCustomModelData(@Nullable ConfigurationNode customModelData) {
        return this.customModelData == customModelData ? this : new RawItem(this.material, this.name, this.lore, customModelData, this.unbreakable, this.itemFlags, this.enchantments, this.attributes, this.color, this.potion, this.durability);
    }

    @Generated
    public RawItem withUnbreakable(@Nullable Boolean unbreakable) {
        return this.unbreakable == unbreakable ? this : new RawItem(this.material, this.name, this.lore, this.customModelData, unbreakable, this.itemFlags, this.enchantments, this.attributes, this.color, this.potion, this.durability);
    }

    @Generated
    public RawItem withItemFlags(List<String> itemFlags) {
        return this.itemFlags == itemFlags ? this : new RawItem(this.material, this.name, this.lore, this.customModelData, this.unbreakable, itemFlags, this.enchantments, this.attributes, this.color, this.potion, this.durability);
    }

    @Generated
    public RawItem withEnchantments(Map<String, Integer> enchantments) {
        return this.enchantments == enchantments ? this : new RawItem(this.material, this.name, this.lore, this.customModelData, this.unbreakable, this.itemFlags, enchantments, this.attributes, this.color, this.potion, this.durability);
    }

    @Generated
    public RawItem withAttributes(List<ConfigurationNode> attributes) {
        return this.attributes == attributes ? this : new RawItem(this.material, this.name, this.lore, this.customModelData, this.unbreakable, this.itemFlags, this.enchantments, attributes, this.color, this.potion, this.durability);
    }

    @Generated
    public RawItem withColor(@Nullable ConfigurationNode color) {
        return this.color == color ? this : new RawItem(this.material, this.name, this.lore, this.customModelData, this.unbreakable, this.itemFlags, this.enchantments, this.attributes, color, this.potion, this.durability);
    }

    @Generated
    public RawItem withPotion(@Nullable ConfigurationNode potion) {
        return this.potion == potion ? this : new RawItem(this.material, this.name, this.lore, this.customModelData, this.unbreakable, this.itemFlags, this.enchantments, this.attributes, this.color, potion, this.durability);
    }

    @Generated
    public RawItem withDurability(@Nullable Integer durability) {
        return this.durability == durability ? this : new RawItem(this.material, this.name, this.lore, this.customModelData, this.unbreakable, this.itemFlags, this.enchantments, this.attributes, this.color, this.potion, durability);
    }
}

