/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.item;

import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import ua.valeriishymchuk.simpleitemgenerator.common.annotation.UsesBukkit;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.common.item.HeadTexture;
import ua.valeriishymchuk.simpleitemgenerator.common.support.HeadDatabaseSupport;
import ua.valeriishymchuk.simpleitemgenerator.io.packetevents.util.SpigotConversionUtil;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.NBT;
import ua.valeriishymchuk.simpleitemgenerator.nbtapi.iface.ReadWriteNBT;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.component.ComponentTypes;
import ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.component.builtin.item.ItemProfile;

@UsesBukkit
public class HeadTextureApplier {
    public static ItemStack apply(HeadTexture headTexture, ItemStack inputItem, UnaryOperator<String> valuePreProcessor) {
        try {
            String value = (String)valuePreProcessor.apply(headTexture.getValue());
            if (!(inputItem.getItemMeta() instanceof SkullMeta)) {
                Material playerHeadMaterial = Arrays.stream(Material.values()).filter(Material::isItem).filter(m -> !m.name().endsWith("AIR")).map(ItemStack::new).filter(ItemStack::hasItemMeta).filter(i -> i.getItemMeta() instanceof SkullMeta).map(ItemStack::getType).findFirst().get();
                throw new InvalidConfigurationException("Item's material should be " + String.valueOf(playerHeadMaterial));
            }
            inputItem.setDurability((short)3);
            switch (headTexture.getType()) {
                case HEADDB: {
                    try {
                        String id = HeadDatabaseSupport.getBase64(value);
                        return HeadTextureApplier.setInternal(inputItem, id);
                    }
                    catch (Exception e) {
                        if (!HeadDatabaseSupport.isPluginEnabled()) {
                            throw new InvalidConfigurationException("HeadDatabase plugin is not enabled");
                        }
                        throw new InvalidConfigurationException("Can't find head: " + value);
                    }
                }
                case NICKNAME: {
                    ItemMeta meta = inputItem.getItemMeta();
                    SkullMeta skullMeta = (SkullMeta)meta;
                    skullMeta.setOwner(value);
                    inputItem.setItemMeta((ItemMeta)skullMeta);
                    return inputItem;
                }
                case BASE64: {
                    return HeadTextureApplier.setInternal(inputItem, value);
                }
                case URL: {
                    return HeadTextureApplier.setInternal(inputItem, HeadTextureApplier.toBase64Texture(value));
                }
            }
            throw new RuntimeException("Not implemented for " + String.valueOf((Object)headTexture.getType()) + ". Report to the author immediately.\nGH issues: https://github.com/ValeraShimchuck/SimpleItemGenerator/issues");
        }
        catch (Throwable e) {
            throw InvalidConfigurationException.nestedPath(e, "item", "head-texture");
        }
    }

    private static ItemStack setInternal(ItemStack item, String base64) {
        if (HeadTexture.USE_COMPONENTS) {
            return HeadTextureApplier.setComponent(item, base64);
        }
        HeadTextureApplier.setNBT(item, base64);
        return item;
    }

    private static void setNBT(ItemStack item, String base64) {
        NBT.modify(item, nbt -> {
            ReadWriteNBT skullNbt = nbt.getOrCreateCompound("SkullOwner");
            if (!HeadTexture.USE_MODERN_UUID) {
                skullNbt.setString("Id", HeadTexture.OWNER_UUID.toString());
            } else {
                skullNbt.setIntArray("Id", HeadTextureApplier.uuidToIntArray(HeadTexture.OWNER_UUID));
            }
            skullNbt.getOrCreateCompound("Properties").getCompoundList("textures").addCompound().setString("Value", base64);
        });
    }

    private static ItemStack setComponent(ItemStack item, String base64) {
        ua.valeriishymchuk.simpleitemgenerator.packetevents.protocol.item.ItemStack packetItem = SpigotConversionUtil.fromBukkitItemStack(item);
        packetItem.setComponent(ComponentTypes.PROFILE, new ItemProfile(null, null, Arrays.asList(new ItemProfile.Property("textures", base64, null))));
        return SpigotConversionUtil.toBukkitItemStack(packetItem);
    }

    private static int[] uuidToIntArray(UUID uuid) {
        long l = uuid.getMostSignificantBits();
        long m = uuid.getLeastSignificantBits();
        return HeadTextureApplier.leastMostToIntArray(l, m);
    }

    private static int[] leastMostToIntArray(long uuidMost, long uuidLeast) {
        return new int[]{(int)(uuidMost >> 32), (int)uuidMost, (int)(uuidLeast >> 32), (int)uuidLeast};
    }

    private static String toBase64Texture(String url) {
        return Base64.getEncoder().encodeToString("{\"textures\":{\"SKIN\":{\"url\":\"%url%\"}}}".replace("%url%", url).getBytes());
    }
}

