/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.item;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SemanticVersion;

public class HeadTexture {
    protected static final UUID OWNER_UUID = UUID.fromString("687b38a7-5505-4253-9e15-733e387fc2f2");
    protected static final String TEXTURE_JSON = "{\"textures\":{\"SKIN\":{\"url\":\"%url%\"}}}";
    protected static final Pattern MOJANG_TEXTURES_URL_PATTERN = Pattern.compile("^https?://\\w+\\.minecraft\\.net/\\S+$");
    protected static final Pattern PATTERN = Pattern.compile("^ *\\[(?<type>headdb|url|base64|nickname)] *(?<value>\\S*) *$");
    protected static final boolean USE_MODERN_UUID = SemanticVersion.CURRENT_MINECRAFT.isAtLeast(1, 16);
    protected static final boolean USE_COMPONENTS = SemanticVersion.CURRENT_MINECRAFT.isAtLeast(1, 20, 5);
    private final Type type;
    private final String value;

    public static HeadTexture fromString(String rawValue) throws InvalidConfigurationException {
        Matcher matcher = PATTERN.matcher(rawValue);
        try {
            if (!matcher.matches()) {
                throw new InvalidConfigurationException("Invalid head texture: " + rawValue + ". Expected: [headdb|url|base64|nickname] <value>.");
            }
            Type type = Type.valueOf(matcher.group("type").toUpperCase());
            String value = matcher.group("value");
            if (type == Type.URL && !MOJANG_TEXTURES_URL_PATTERN.matcher(value).matches()) {
                throw InvalidConfigurationException.format("Invalid url %s. Only *.minecraft.net domains are supported. Examples:\nhttp://textures.minecraft.net/texture/84da09279307027a4a57cb49784ba634b155d51531fba9ed334461e5de140766\nhttp://textures.minecraft.net/texture/da91846245a7342cc5aea8f548525ae5260b028f85ed183245731e40a514e4c6", value);
            }
            return new HeadTexture(type, value);
        }
        catch (Throwable e) {
            throw InvalidConfigurationException.nestedPath(e, "item", "head-texture");
        }
    }

    @Generated
    public HeadTexture(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    public static enum Type {
        HEADDB,
        URL,
        BASE64,
        NICKNAME;

    }
}

