/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.item;

import io.vavr.API;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import ua.valeriishymchuk.libs.net.kyori.adventure.key.Key;
import ua.valeriishymchuk.simpleitemgenerator.common.config.DefaultLoader;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.common.slot.EquipmentSlotWrapper;
import ua.valeriishymchuk.simpleitemgenerator.common.text.StringSimilarityUtils;
import ua.valeriishymchuk.simpleitemgenerator.common.version.FeatureSupport;
import ua.valeriishymchuk.simpleitemgenerator.common.version.SemanticVersion;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurationNode;

public class Attribute {
    protected static final String ATTRIBUTE_MODIFIERS = "AttributeModifiers";
    protected static final String ATTRIBUTE_MODIFIERS_1_21 = "attribute_modifiers";
    protected static final String ATTRIBUTE_NAME = "AttributeName";
    protected static final String ATTRIBUTE_NAME_1_21 = "type";
    protected static final String ID = "id";
    protected static final String SLOT = "Slot";
    protected static final String NAME = "Name";
    protected static final String AMOUNT = "Amount";
    protected static final String OPERATION = "Operation";
    protected static final String UUID = "UUID";
    private final Operation operation;
    private final Modifiers modifier;
    private final double amount;
    @Nullable
    private final UUID uuid;
    @Nullable
    private final String name;
    @Nullable
    private final EquipmentSlotWrapper slot;

    public ConfigurationNode toNode() {
        Object node = DefaultLoader.yaml().createNode();
        node.node("operation").set(this.operation.name());
        node.node("amount").set(this.amount);
        boolean is1_9 = SemanticVersion.CURRENT_MINECRAFT.isAtLeast(1, 9);
        if (this.modifier.isSupported()) {
            node.node("attribute").set(this.modifier.name());
        }
        if (this.name != null) {
            node.node("name").set(this.name);
        }
        if (is1_9 && this.slot != null) {
            node.node("slot").set(this.slot.name());
        }
        return node;
    }

    private static Operation getOperation(ConfigurationNode node) throws InvalidConfigurationException {
        return Try.ofSupplier(() -> node.node("operation").getString()).filter(Objects::nonNull, () -> new InvalidConfigurationException("Operation is not present.")).map(String::toUpperCase).mapTry(Operation::valueOf).mapFailure(API.Case(API.$(e -> e instanceof IllegalArgumentException), e -> {
            List<String> suggestions = StringSimilarityUtils.getSuggestions(node.node("operation").getString(), Arrays.stream(Operation.values()).map(Enum::name));
            return InvalidConfigurationException.unknownOption("operation", node.node("operation").getString(), suggestions);
        })).getOrElseThrow(x -> InvalidConfigurationException.path("operation", x));
    }

    private static Modifiers getModifier(ConfigurationNode node) throws InvalidConfigurationException {
        return Try.ofSupplier(() -> node.node("attribute").getString()).filter(Objects::nonNull, () -> new InvalidConfigurationException("Attribute is not present.")).map(String::toUpperCase).mapTry(Modifiers::valueOf).mapFailure(API.Case(API.$(e -> e instanceof IllegalArgumentException), e -> {
            List<String> suggestions = StringSimilarityUtils.getSuggestions(node.node("attribute").getString(), Arrays.stream(Modifiers.values()).map(Enum::name));
            return InvalidConfigurationException.unknownOption("attribute", node.node("attribute").getString(), suggestions);
        })).andThenTry(modifier -> {
            if (!modifier.isSupported()) {
                throw new InvalidConfigurationException("Attribute " + String.valueOf(modifier) + " is supported since " + String.valueOf(modifier.availableSince) + ". Current version is " + String.valueOf(SemanticVersion.CURRENT_MINECRAFT));
            }
        }).getOrElseThrow(x -> InvalidConfigurationException.path("attribute", x));
    }

    private static Option<EquipmentSlotWrapper> getSlot(ConfigurationNode node) throws InvalidConfigurationException {
        return Try.ofSupplier(() -> node.node("slot").getString()).map(Option::of).map(slotOpt -> slotOpt.map(String::toUpperCase)).mapTry(slotOpt -> slotOpt.map(EquipmentSlotWrapper::valueOf)).mapFailure(API.Case(API.$(e -> e instanceof IllegalArgumentException), e -> {
            List<String> suggestions = StringSimilarityUtils.getSuggestions(node.node("slot").getString(), Arrays.stream(EquipmentSlotWrapper.values()).map(Enum::name));
            return InvalidConfigurationException.unknownOption("slot", node.node("slot").getString(), suggestions);
        })).andThenTry(slot -> {
            if (slot.isEmpty()) {
                return;
            }
            if (!FeatureSupport.MODERN_COMBAT) {
                throw new InvalidConfigurationException("Slot is supported since 1.9. Current version is " + String.valueOf(SemanticVersion.CURRENT_MINECRAFT));
            }
            if (FeatureSupport.SLOT_GROUP_SUPPORT) {
                return;
            }
            List<EquipmentSlotWrapper> forbiddenSlots = Arrays.asList(EquipmentSlotWrapper.BODY, EquipmentSlotWrapper.ARMOR, EquipmentSlotWrapper.HAND);
            if (forbiddenSlots.contains(slot.get())) {
                throw new InvalidConfigurationException("Slot " + String.valueOf(slot.get()) + " is not available up until 1.20.5. Current version is " + String.valueOf(SemanticVersion.CURRENT_MINECRAFT));
            }
        }).getOrElseThrow(x -> InvalidConfigurationException.path("slot", x));
    }

    public static Attribute fromNode(ConfigurationNode node) throws InvalidConfigurationException {
        Operation operation = Attribute.getOperation(node);
        String name = node.node("name").getString();
        Modifiers modifier = Attribute.getModifier(node);
        double amount = Try.ofSupplier(() -> node.node("amount").getString()).filter(Objects::nonNull, () -> new InvalidConfigurationException("Amount is not present.")).mapTry(Double::parseDouble).mapFailure(API.Case(API.$(e -> e instanceof NumberFormatException), e -> InvalidConfigurationException.format("Not a number: <white>%s</white>.", node.node("amount").getString()))).getOrElseThrow(x -> InvalidConfigurationException.path("amount", x));
        EquipmentSlotWrapper slot = Attribute.getSlot(node).getOrElse(EquipmentSlotWrapper.ANY);
        return new Attribute(operation, modifier, amount, null, name, slot);
    }

    @Generated
    public Attribute(Operation operation, Modifiers modifier, double amount, @Nullable UUID uuid, @Nullable String name, @Nullable EquipmentSlotWrapper slot) {
        this.operation = operation;
        this.modifier = modifier;
        this.amount = amount;
        this.uuid = uuid;
        this.name = name;
        this.slot = slot;
    }

    @Generated
    public Operation getOperation() {
        return this.operation;
    }

    @Generated
    public Modifiers getModifier() {
        return this.modifier;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Nullable
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public EquipmentSlotWrapper getSlot() {
        return this.slot;
    }

    public static enum Operation {
        ADD_VALUE,
        ADD_MULTIPLIED_BASE,
        ADD_MULTIPLIED_TOTAL;

    }

    public static enum Modifiers {
        ATTACK_DAMAGE("generic.attackDamage"),
        MAX_HEALTH("generic.maxHealth"),
        FOLLOW_RANGE("generic.followRange"),
        KNOCKBACK_RESISTANCE("generic.knockbackResistance"),
        MOVEMENT_SPEED("generic.movementSpeed"),
        JUMP_STRENGTH("horse.jumpStrength", new SemanticVersion(1, 8), HashMap.of(new SemanticVersion(1, 20, 5), Key.key("generic.jump_strength").asString()).toJavaMap()),
        ZOMBIE_SPAWN_REINFORCEMENTS("zombie.spawnReinforcements"),
        ATTACK_SPEED("generic.attackSpeed", new SemanticVersion(1, 9)),
        ARMOR("generic.armor", new SemanticVersion(1, 9)),
        ARMOR_TOUGHNESS("generic.armorToughness", new SemanticVersion(1, 9)),
        LUCK("generic.luck", new SemanticVersion(1, 9)),
        FLYING_SPEED("generic.flyingSpeed", new SemanticVersion(1, 12)),
        ATTACK_KNOCKBACK("generic.attackKnockback", new SemanticVersion(1, 14)),
        MAX_ABSORPTION("generic.max_absorption", new SemanticVersion(1, 20, 2)),
        SCALE("generic.scale", new SemanticVersion(1, 20, 5)),
        STEP_HEIGHT("generic.step_height", new SemanticVersion(1, 20, 5)),
        ENTITY_INTERACTION_RANGE("player.entity_interaction_range", new SemanticVersion(1, 20, 5)),
        BLOCK_INTERACTION_RANGE("player.block_interaction_range", new SemanticVersion(1, 20, 5)),
        GRAVITY("generic.gravity", new SemanticVersion(1, 20, 5)),
        SAFE_FALL_DISTANCE("generic.safe_fall_distance", new SemanticVersion(1, 20, 5)),
        BLOCK_BREAK_SPEED("player.block_break_speed", new SemanticVersion(1, 20, 5)),
        BURNING_TIME("generic.burning_time", new SemanticVersion(1, 21)),
        EXPLOSION_KNOCKBACK_RESISTANCE("generic.explosion_knockback_resistance", new SemanticVersion(1, 21)),
        MINING_EFFICIENCY("player.mining_efficiency", new SemanticVersion(1, 21)),
        MOVEMENT_EFFICIENCY("generic.movement_efficiency", new SemanticVersion(1, 21)),
        OXYGEN_BONUS("generic.oxygen_bonus", new SemanticVersion(1, 21)),
        SNEAKING_SPEED("player.sneaking_speed", new SemanticVersion(1, 21)),
        SUBMERGED_MINING_SPEED("player.submerged_mining_speed", new SemanticVersion(1, 21)),
        SWEEPING_DAMAGE_RATION("player.sweeping_damage_ration", new SemanticVersion(1, 21)),
        WATER_MOVEMENT_EFFICIENCY("generic.water_movement_efficiency", new SemanticVersion(1, 21)),
        TEMPT_RANGE(".tempt_range", new SemanticVersion(1, 21, 2));

        private final String oldNotation;
        private final SemanticVersion availableSince;
        private final Map<SemanticVersion, String> notationPerVersion;

        private Modifiers(String oldNotation) {
            this(oldNotation, new SemanticVersion(1, 8));
        }

        private Modifiers(String oldNotation, SemanticVersion availableSince) {
            this.oldNotation = oldNotation;
            this.availableSince = availableSince;
            this.notationPerVersion = new java.util.HashMap<SemanticVersion, String>();
            Key _116Notation = Key.key(Modifiers.to116Notation(oldNotation));
            this.notationPerVersion.put(new SemanticVersion(1, 16), _116Notation.asString());
            this.notationPerVersion.put(new SemanticVersion(1, 21, 2), Modifiers.to1212Notation(_116Notation));
        }

        private Modifiers(String oldNotation, SemanticVersion availableSince, Map<SemanticVersion, String> notationPerVersion) {
            this(oldNotation, availableSince);
            this.notationPerVersion.putAll(notationPerVersion);
        }

        private static String to116Notation(String oldNotation) {
            StringBuilder sb = new StringBuilder();
            oldNotation.chars().mapToObj(c -> Character.valueOf((char)c)).forEach(c -> {
                if (Character.isUpperCase(c.charValue())) {
                    sb.append("_").append(Character.toLowerCase(c.charValue()));
                } else {
                    sb.append(c);
                }
            });
            return sb.toString();
        }

        private static String to1212Notation(Key oldNotation) {
            String value = oldNotation.value();
            String[] splitParts = value.split("\\.");
            return splitParts[1];
        }

        public String getNotation(SemanticVersion version) {
            if (version.compareTo(new SemanticVersion(1, 16)) < 0) {
                return this.oldNotation;
            }
            return (String)this.notationPerVersion.entrySet().stream().filter(entry -> version.isAtLeast((SemanticVersion)entry.getKey())).max(Map.Entry.comparingByKey()).get().getValue();
        }

        public boolean isSupported() {
            return SemanticVersion.CURRENT_MINECRAFT.isAtLeast(this.availableSince);
        }
    }
}

