/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.error;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.snakeyaml.parser.ParserException;
import ua.valeriishymchuk.simpleitemgenerator.snakeyaml.scanner.ScannerException;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurateException;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.loader.ParsingException;

public class ErrorVisitor {
    private final Logger logger;
    private final Consumer<String> errorConsumer;

    public void visitError(Throwable e) {
        if (e == null) {
            return;
        }
        List<Class<ParsingException>> silentExceptions = List.of(ParsingException.class);
        List<Class> knownExceptions = Arrays.asList(ConfigurateException.class, InvalidConfigurationException.class, ScannerException.class, NumberFormatException.class, ParserException.class);
        boolean isKnownException = knownExceptions.stream().anyMatch(c -> c.isAssignableFrom(e.getClass()));
        boolean isSilent = silentExceptions.stream().anyMatch(c -> c.isAssignableFrom(e.getClass()));
        if (isKnownException && !isSilent) {
            this.errorConsumer.accept(String.format("<red>[SimpleItemGenerator] %s</red>", e.getMessage()));
        } else if (!isSilent) {
            this.logger.log(Level.SEVERE, "An unknown error occurred", e);
            this.errorConsumer.accept("<red>[SimpleItemGenerator] Please report this error there: https://github.com/ValeraShimchuck/SimpleItemGenerator/issues</red>");
        }
        this.visitError(e.getCause());
    }

    @Generated
    public ErrorVisitor(Logger logger, Consumer<String> errorConsumer) {
        this.logger = logger;
        this.errorConsumer = errorConsumer;
    }
}

