/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.config.serializer.nbt.v2;

import com.florianingerl.util.regex.Matcher;
import com.florianingerl.util.regex.Pattern;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.vavr.Tuple;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.ArrayUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.BinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.BinaryTagType;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.BinaryTagTypes;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.ByteArrayBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.ByteBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.CompoundBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.DoubleBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.FloatBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.IntArrayBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.IntBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.ListBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.LongArrayBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.LongBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.ShortBinaryTag;
import ua.valeriishymchuk.libs.net.kyori.adventure.nbt.StringBinaryTag;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurationNode;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.ConfigurationOptions;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.serialize.SerializationException;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.serialize.TypeSerializer;

public class CompoundBinaryTagTypeSerializer
implements TypeSerializer<CompoundBinaryTag> {
    private static final Pattern TYPE_PATTERN = Pattern.compile("(?<type>byte|short|int|long|float|double|string|byte_array|int_array|long_array|compound|list:(?<list_type>(?'type')))");
    private static final Pattern KEY_PATTERN = Pattern.compile("^(?<key>.*)\\[(?<type>byte|short|int|long|float|double|string|byte_array|int_array|long_array|compound|list:(?'type'))]$");
    public static final BiMap<String, BinaryTagInfo> TYPES_IDS = (BiMap)io.vavr.collection.List.of(BinaryTagInfo.of("byte", BinaryTagTypes.BYTE, o -> ByteBinaryTag.byteBinaryTag(Byte.parseByte(o.toString())), b -> ((ByteBinaryTag)b).value()), BinaryTagInfo.of("short", BinaryTagTypes.SHORT, o -> ShortBinaryTag.shortBinaryTag(Short.parseShort(o.toString())), b -> ((ShortBinaryTag)b).value()), BinaryTagInfo.of("int", BinaryTagTypes.INT, o -> IntBinaryTag.intBinaryTag(Integer.parseInt(o.toString())), b -> ((IntBinaryTag)b).value()), BinaryTagInfo.of("long", BinaryTagTypes.LONG, o -> LongBinaryTag.longBinaryTag(Long.parseLong(o.toString())), b -> ((LongBinaryTag)b).value()), BinaryTagInfo.of("float", BinaryTagTypes.FLOAT, o -> FloatBinaryTag.floatBinaryTag(Float.parseFloat(o.toString())), b -> Float.valueOf(((FloatBinaryTag)b).value())), BinaryTagInfo.of("double", BinaryTagTypes.DOUBLE, o -> DoubleBinaryTag.doubleBinaryTag(Double.parseDouble(o.toString())), b -> ((DoubleBinaryTag)b).value()), BinaryTagInfo.of("string", BinaryTagTypes.STRING, o -> StringBinaryTag.stringBinaryTag(o.toString()), b -> ((StringBinaryTag)b).value()), BinaryTagInfo.of("byte_array", BinaryTagTypes.BYTE_ARRAY, o -> {
        byte[] bytes = ArrayUtils.toPrimitive((Byte[])((Byte[])((List)o).stream().map(Object::toString).map(Byte::parseByte).toArray(Byte[]::new)));
        return ByteArrayBinaryTag.byteArrayBinaryTag(bytes);
    }, b -> {
        byte[] array = ((ByteArrayBinaryTag)b).value();
        return ArrayUtils.toObject((byte[])array);
    }), BinaryTagInfo.of("int_array", BinaryTagTypes.INT_ARRAY, o -> {
        int[] bytes = ArrayUtils.toPrimitive((Integer[])((Integer[])((List)o).stream().map(Object::toString).map(Integer::parseInt).toArray(Integer[]::new)));
        return IntArrayBinaryTag.intArrayBinaryTag(bytes);
    }, b -> {
        int[] array = ((IntArrayBinaryTag)b).value();
        return ArrayUtils.toObject((int[])array);
    }), BinaryTagInfo.of("long_array", BinaryTagTypes.LONG_ARRAY, o -> {
        long[] bytes = ArrayUtils.toPrimitive((Long[])((Long[])((List)o).stream().map(Object::toString).map(Long::parseLong).toArray(Long[]::new)));
        return LongArrayBinaryTag.longArrayBinaryTag(bytes);
    }, b -> {
        long[] array = ((LongArrayBinaryTag)b).value();
        return ArrayUtils.toObject((long[])array);
    }), BinaryTagInfo.of("list", BinaryTagTypes.LIST, o -> {
        throw new IllegalArgumentException("List");
    }, b -> {
        throw new IllegalArgumentException("List");
    }), BinaryTagInfo.of("compound", BinaryTagTypes.COMPOUND, o -> {
        throw new IllegalArgumentException("Compound");
    }, b -> {
        throw new IllegalArgumentException("Compound");
    })).transform(m -> ImmutableBiMap.copyOf(m.toJavaMap(t -> Tuple.of(t.key, t))));
    public static final Map<? extends BinaryTagType<? extends BinaryTag>, String> TYPES_IDS_BY_TYPE = ((io.vavr.collection.HashMap)io.vavr.collection.HashMap.ofAll(TYPES_IDS.inverse()).mapKeys(k -> k.type)).toJavaMap();

    @Override
    public CompoundBinaryTag deserialize(Type type, ConfigurationNode node) throws SerializationException {
        if (node.isNull()) {
            return CompoundBinaryTag.empty();
        }
        if (!node.isMap()) {
            throw new SerializationException("Must be a map");
        }
        Map rawCompound = (Map)node.raw();
        return this.parseCompound(rawCompound);
    }

    @Override
    public @Nullable CompoundBinaryTag emptyValue(Type specificType, ConfigurationOptions options) {
        return CompoundBinaryTag.empty();
    }

    private CompoundBinaryTag parseCompound(Map<String, Object> rawCompound) {
        CompoundBinaryTag.Builder compound = CompoundBinaryTag.builder();
        for (Map.Entry<String, Object> entry : rawCompound.entrySet()) {
            Matcher keyMatcher = KEY_PATTERN.matcher(entry.getKey());
            if (!keyMatcher.matches()) {
                throw new IllegalArgumentException("Invalid compound key: " + entry.getKey());
            }
            String internalKey = keyMatcher.group("key");
            String internalType = keyMatcher.group("type");
            compound.put(internalKey, this.sneakyParse(internalType, entry.getValue()));
        }
        return compound.build();
    }

    private BinaryTag sneakyParse(String type, Object value) {
        return this.parse(type, value);
    }

    private BinaryTag parse(String type, Object value) throws SerializationException {
        if (value == null) {
            throw new SerializationException("Must provide a value");
        }
        Matcher matcher = TYPE_PATTERN.matcher(type);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        String listType = matcher.group("list_type");
        if (listType != null) {
            List rawList = (List)value;
            Matcher listTypeMatcher = TYPE_PATTERN.matcher(listType);
            if (!listTypeMatcher.matches()) {
                throw new IllegalArgumentException("Invalid list type: " + listType);
            }
            String listTypeFirst = listType.split(":")[0];
            BinaryTagType<? extends BinaryTag> binaryListType = ((BinaryTagInfo)TYPES_IDS.get((Object)listTypeFirst)).getType();
            return ListBinaryTag.listBinaryTag(binaryListType, rawList.stream().map(obj -> this.sneakyParse(listType, obj)).collect(Collectors.toList()));
        }
        if (type.equals("compound")) {
            Map rawCompound = (Map)value;
            return this.parseCompound(rawCompound);
        }
        return ((BinaryTagInfo)TYPES_IDS.get((Object)type)).getParser().apply(value);
    }

    @Override
    public void serialize(Type type, @Nullable CompoundBinaryTag obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        Map<String, Object> rawCompound = this.serializeCompound(obj);
        node.set(rawCompound);
    }

    private Map<String, Object> serializeCompound(CompoundBinaryTag obj) {
        HashMap<String, Object> rawCompound = new HashMap<String, Object>();
        obj.forEach(entry -> {
            String key = (String)entry.getKey();
            BinaryTag value = (BinaryTag)entry.getValue();
            rawCompound.put(key + "[" + this.getType(value) + "]", this.serializeTag(value));
        });
        return rawCompound;
    }

    private String getType(BinaryTag tag) {
        if (tag instanceof ListBinaryTag) {
            return "list:" + TYPES_IDS_BY_TYPE.get(((ListBinaryTag)tag).type());
        }
        return TYPES_IDS_BY_TYPE.get(tag.type());
    }

    private Object serializeTag(BinaryTag value) {
        if (value instanceof ListBinaryTag) {
            ListBinaryTag listBinaryTag = (ListBinaryTag)value;
            BinaryTagType<ListBinaryTag> type = listBinaryTag.type();
            return listBinaryTag.stream().map(this::serializeTag).collect(Collectors.toList());
        }
        if (value instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundBinaryTag = (CompoundBinaryTag)value;
            return this.serializeCompound(compoundBinaryTag);
        }
        String type = TYPES_IDS_BY_TYPE.get(value.type());
        return ((BinaryTagInfo)TYPES_IDS.get((Object)type)).getSerializer().apply(value);
    }

    public static class BinaryTagInfo {
        private final String key;
        private final BinaryTagType<? extends BinaryTag> type;
        private final Function<Object, BinaryTag> parser;
        private final Function<BinaryTag, Object> serializer;

        @Generated
        private BinaryTagInfo(String key, BinaryTagType<? extends BinaryTag> type, Function<Object, BinaryTag> parser, Function<BinaryTag, Object> serializer) {
            this.key = key;
            this.type = type;
            this.parser = parser;
            this.serializer = serializer;
        }

        @Generated
        public static BinaryTagInfo of(String key, BinaryTagType<? extends BinaryTag> type, Function<Object, BinaryTag> parser, Function<BinaryTag, Object> serializer) {
            return new BinaryTagInfo(key, type, parser, serializer);
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public BinaryTagType<? extends BinaryTag> getType() {
            return this.type;
        }

        @Generated
        public Function<Object, BinaryTag> getParser() {
            return this.parser;
        }

        @Generated
        public Function<BinaryTag, Object> getSerializer() {
            return this.serializer;
        }
    }
}

