/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.config.error;

import io.vavr.control.Validation;
import java.nio.charset.MalformedInputException;
import lombok.Generated;
import ua.valeriishymchuk.simpleitemgenerator.common.config.exception.InvalidConfigurationException;
import ua.valeriishymchuk.simpleitemgenerator.snakeyaml.scanner.ScannerException;
import ua.valeriishymchuk.simpleitemgenerator.spongepowered.configurate.loader.ParsingException;

public abstract class ConfigurationError {
    private ConfigurationError() {
    }

    public boolean isFileNotPresent() {
        return this instanceof FileNotPresent;
    }

    public abstract InvalidConfigurationException asConfigException();

    public static <T> Validation<ConfigurationError, T> handleValidationException(Throwable e) {
        return Validation.invalid(ConfigurationError.handleException(e));
    }

    public static ConfigurationError handleException(Throwable e) {
        if (e instanceof MalformedInputException) {
            return new MalformedInput(e.getMessage());
        }
        if (e instanceof ScannerException) {
            return new InvalidSyntax(e.getMessage());
        }
        if (e instanceof ParsingException) {
            if (e.getCause() == null) {
                return new UnknownException(e);
            }
            return ConfigurationError.handleException(e.getCause());
        }
        return new UnknownException(e);
    }

    public static final class FileNotPresent
    extends ConfigurationError {
        public static final FileNotPresent INSTANCE = new FileNotPresent();

        @Override
        public InvalidConfigurationException asConfigException() {
            return InvalidConfigurationException.format("File is not present.", new Object[0]);
        }
    }

    public static final class MalformedInput
    extends ConfigurationError {
        private final String message;

        @Override
        public InvalidConfigurationException asConfigException() {
            return InvalidConfigurationException.format("An invalid character were found. Make sure you saved your configuration in UTF-8 encoding! \nMalformedInput message: %s", this.message);
        }

        @Generated
        public MalformedInput(String message) {
            this.message = message;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }
    }

    public static final class InvalidSyntax
    extends ConfigurationError {
        private final String message;

        @Override
        public InvalidConfigurationException asConfigException() {
            return InvalidConfigurationException.format("Check syntax in your configuration: \n%s", this.message);
        }

        @Generated
        public InvalidSyntax(String message) {
            this.message = message;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }
    }

    public static final class UnknownException
    extends ConfigurationError {
        private final Throwable originalError;

        public UnknownException(Throwable err) {
            this.originalError = err;
        }

        @Override
        public InvalidConfigurationException asConfigException() {
            return InvalidConfigurationException.unhandledException(this.originalError);
        }

        @Generated
        public Throwable getOriginalError() {
            return this.originalError;
        }
    }
}

