/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.boundingbox;

import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import ua.valeriishymchuk.simpleitemgenerator.common.raytrace.RayTraceHelper;
import ua.valeriishymchuk.simpleitemgenerator.common.wrapper.BlockFaceWrapper;
import ua.valeriishymchuk.simpleitemgenerator.joml.Vector2d;
import ua.valeriishymchuk.simpleitemgenerator.joml.Vector3d;
import ua.valeriishymchuk.simpleitemgenerator.joml.Vector3dc;

public class BoundingBox {
    private final Vector3d min;
    private final Vector3d max;

    public BoundingBox(Vector3d min, Vector3d max) {
        this.min = new Vector3d(Math.min(min.x(), max.x()), Math.min(min.y(), max.y()), Math.min(min.z(), max.z()));
        this.max = new Vector3d(Math.max(min.x(), max.x()), Math.max(min.y(), max.y()), Math.max(min.z(), max.z()));
    }

    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this(new Vector3d(minX, minY, minZ), new Vector3d(maxX, maxY, maxZ));
    }

    public Option<IntersectResult> intersects(Vector3d lineStart, Vector3d lineEnd) {
        Map<BlockFaceWrapper, BoxPlane> planes = this.getBlockPlanes();
        return ((HashMap)HashMap.ofAll(planes).map((face, boxPlane) -> Tuple.of(face, (Vector3d)boxPlane.intersects(lineStart, lineEnd).getOrNull()))).filterValues(Objects::nonNull).minBy(t -> lineStart.distance((Vector3dc)t._2())).map(t -> new IntersectResult((Vector3d)t._2(), (BlockFaceWrapper)((Object)((Object)t._1()))));
    }

    private Map<BlockFaceWrapper, BoxPlane> getBlockPlanes() {
        Vector3d faceVector = new Vector3d(0.0, -1.0, 0.0);
        Vector3d originVector = new Vector3d(this.min.x(), this.min.y(), this.max.z());
        BoxPlane down = new BoxPlane(faceVector, originVector, RayTraceHelper.getPointFromPlane(originVector, faceVector, originVector), RayTraceHelper.getPointFromPlane(originVector, faceVector, new Vector3d(this.max.x(), this.min.y(), this.min.z())));
        faceVector = new Vector3d(0.0, 1.0, 0.0);
        originVector = new Vector3d(this.min.x(), this.max.y(), this.min.z());
        BoxPlane up = new BoxPlane(faceVector, originVector, RayTraceHelper.getPointFromPlane(originVector, faceVector, originVector), RayTraceHelper.getPointFromPlane(originVector, faceVector, this.max));
        faceVector = new Vector3d(0.0, 0.0, -1.0);
        originVector = this.min;
        BoxPlane north = new BoxPlane(faceVector, originVector, RayTraceHelper.getPointFromPlane(originVector, faceVector, originVector), RayTraceHelper.getPointFromPlane(originVector, faceVector, new Vector3d(this.max.x(), this.max.y(), this.min.z())));
        faceVector = new Vector3d(1.0, 0.0, 0.0);
        originVector = new Vector3d(this.max.x(), this.min.y(), this.min.z());
        BoxPlane east = new BoxPlane(faceVector, originVector, RayTraceHelper.getPointFromPlane(originVector, faceVector, originVector), RayTraceHelper.getPointFromPlane(originVector, faceVector, this.max));
        faceVector = new Vector3d(-1.0, 0.0, 0.0);
        originVector = new Vector3d(this.min.x(), this.min.y(), this.max.z());
        BoxPlane west = new BoxPlane(faceVector, originVector, RayTraceHelper.getPointFromPlane(originVector, faceVector, originVector), RayTraceHelper.getPointFromPlane(originVector, faceVector, new Vector3d(this.min.x(), this.max.y(), this.min.z())));
        faceVector = new Vector3d(0.0, 0.0, 1.0);
        originVector = new Vector3d(this.max.x(), this.min.y(), this.max.z());
        BoxPlane south = new BoxPlane(faceVector, originVector, RayTraceHelper.getPointFromPlane(originVector, faceVector, originVector), RayTraceHelper.getPointFromPlane(originVector, faceVector, new Vector3d(this.min.x(), this.max.y(), this.max.z())));
        return HashMap.of(BlockFaceWrapper.DOWN, down, BlockFaceWrapper.UP, up, BlockFaceWrapper.NORTH, north, BlockFaceWrapper.EAST, east, BlockFaceWrapper.WEST, west, BlockFaceWrapper.SOUTH, south).toJavaMap();
    }

    public String toString() {
        return "BoundingBox{min=" + this.min.toString(NumberFormat.getNumberInstance()) + ", max=" + this.max.toString(NumberFormat.getNumberInstance()) + "}";
    }

    private static class BoxPlane {
        private final Vector3d normal;
        private final Vector3d origin;
        private final Vector2d start;
        private final Vector2d end;

        private boolean within(Vector2d point) {
            return point.x >= this.start.x && point.x <= this.end.x && point.y >= this.start.y && point.y <= this.end.y;
        }

        private boolean within(Vector3d point) {
            return this.within(RayTraceHelper.getPointFromPlane(this.origin, this.normal, point));
        }

        private Option<Vector3d> intersects(Vector3d lineStart, Vector3d lineEnd) {
            double distance = lineStart.distance(lineEnd);
            return RayTraceHelper.findLineAndPlaneIntersection(lineStart, lineEnd, this.origin, this.normal).filter(this::within).filter(point -> lineStart.distance((Vector3dc)point) <= distance && lineEnd.distance((Vector3dc)point) <= distance);
        }

        @Generated
        public BoxPlane(Vector3d normal, Vector3d origin, Vector2d start, Vector2d end) {
            this.normal = normal;
            this.origin = origin;
            this.start = start;
            this.end = end;
        }
    }

    public static class IntersectResult {
        private final Vector3d point;
        private final BlockFaceWrapper face;

        @Generated
        public IntersectResult(Vector3d point, BlockFaceWrapper face) {
            this.point = point;
            this.face = face;
        }

        @Generated
        public Vector3d getPoint() {
            return this.point;
        }

        @Generated
        public BlockFaceWrapper getFace() {
            return this.face;
        }
    }
}

