/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.common.block;

import io.vavr.control.Option;
import io.vavr.control.Try;
import java.lang.reflect.Method;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.common.reflection.ClassHelper;

public class BlockDataWrapper {
    private static final Class<Block> BLOCK_CLASS = Block.class;
    private static final Option<Class<?>> BLOCK_DATA_CLASS_OPTION = ClassHelper.tryGetClass("org.bukkit.block.data.BlockData");
    private static final Option<Method> GET_BLOCK_DATA_METHOD_OPTION = ClassHelper.tryGetMethod(BLOCK_CLASS, "getBlockData", new Class[0]);
    private final Block block;
    @Nullable
    private final Object blockData;

    public BlockDataWrapper(Block block) {
        this.block = block;
        this.blockData = GET_BLOCK_DATA_METHOD_OPTION.flatMap(m -> Try.of(() -> m.invoke((Object)block, new Object[0])).onFailure(Throwable::printStackTrace).toOption()).getOrNull();
    }

    public Option<Object> getBlockData() {
        return Option.of(this.blockData);
    }

    public Option<Boolean> isInstanceOf(String className) {
        return ClassHelper.tryGetClass(className).flatMap(clazz -> this.getBlockData().map(clazz::isInstance));
    }
}

