/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.execution.CommandSuggestionProcessor;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.execution.preprocessor.CommandPreprocessingContext;

@API(status=API.Status.STABLE)
public final class FilteringCommandSuggestionProcessor<C>
implements CommandSuggestionProcessor<C> {
    private final @NonNull Filter<C> filter;

    @API(status=API.Status.STABLE)
    public FilteringCommandSuggestionProcessor() {
        this(Filter.startsWith(false));
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public FilteringCommandSuggestionProcessor(@NonNull Filter<C> filter) {
        this.filter = filter;
    }

    @Override
    public @NonNull List<@NonNull String> apply(@NonNull CommandPreprocessingContext<C> context, @NonNull List<@NonNull String> strings) {
        String input = context.getInputQueue().isEmpty() ? "" : String.join((CharSequence)" ", context.getInputQueue());
        ArrayList<String> suggestions = new ArrayList<String>(strings.size());
        for (String suggestion : strings) {
            @Nullable String filtered = this.filter.filter(context, suggestion, input);
            if (filtered == null) continue;
            suggestions.add(filtered);
        }
        return suggestions;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    @FunctionalInterface
    public static interface Filter<C> {
        @API(status=API.Status.STABLE, since="1.8.0")
        public @Nullable String filter(@NonNull CommandPreprocessingContext<C> var1, @NonNull String var2, @NonNull String var3);

        @API(status=API.Status.STABLE, since="1.8.0")
        default public @NonNull Filter<C> and(@NonNull Filter<C> and) {
            return (ctx, suggestion, input) -> {
                @Nullable String filtered = this.filter(ctx, suggestion, input);
                if (filtered == null) {
                    return null;
                }
                return and.filter(ctx, filtered, input);
            };
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        default public Filter<C> andTrimBeforeLastSpace() {
            return this.and(Filter.trimBeforeLastSpace());
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        public static <C> @NonNull Simple<C> startsWith(boolean ignoreCase) {
            BiPredicate<String, String> test = ignoreCase ? (suggestion, input) -> suggestion.toLowerCase(Locale.ROOT).startsWith(input.toLowerCase(Locale.ROOT)) : String::startsWith;
            return Simple.contextFree(test);
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        public static <C> @NonNull Simple<C> contains(boolean ignoreCase) {
            BiPredicate<String, String> test = ignoreCase ? (suggestion, input) -> suggestion.toLowerCase(Locale.ROOT).contains(input.toLowerCase(Locale.ROOT)) : String::contains;
            return Simple.contextFree(test);
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        public static <C> @NonNull Filter<C> trimBeforeLastSpace() {
            return (context, suggestion, input) -> {
                int lastSpace = input.lastIndexOf(32);
                if (lastSpace == -1) {
                    return suggestion;
                }
                if (suggestion.toLowerCase(Locale.ROOT).startsWith(input.toLowerCase(Locale.ROOT).substring(0, lastSpace))) {
                    return suggestion.substring(lastSpace + 1);
                }
                return null;
            };
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        public static <C> @NonNull Filter<C> contextFree(@NonNull BiFunction<String, String, @Nullable String> function) {
            return (ctx, suggestion, input) -> (String)function.apply(suggestion, input);
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        public static <C> @NonNull Simple<C> simple(Simple<C> filter) {
            return filter;
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        @FunctionalInterface
        public static interface Simple<C>
        extends Filter<C> {
            @API(status=API.Status.STABLE, since="1.8.0")
            public boolean test(@NonNull CommandPreprocessingContext<C> var1, @NonNull String var2, @NonNull String var3);

            @Override
            default public @Nullable String filter(@NonNull CommandPreprocessingContext<C> context, @NonNull String suggestion, @NonNull String input) {
                if (this.test(context, suggestion, input)) {
                    return suggestion;
                }
                return null;
            }

            @API(status=API.Status.STABLE, since="1.8.0")
            public static <C> @NonNull Simple<C> contextFree(@NonNull BiPredicate<String, String> test) {
                return (ctx, suggestion, input) -> test.test(suggestion, input);
            }
        }
    }
}

