/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.brigadier.argument;

import com.mojang.brigadier.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.checkerframework.checker.nullness.qual.NonNull;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.brigadier.argument.StringReaderAsQueueImpl;

public interface StringReaderAsQueue
extends Queue<String> {
    public static StringReaderAsQueue from(StringReader reader) {
        if (reader instanceof StringReaderAsQueue) {
            return (StringReaderAsQueue)reader;
        }
        return new StringReaderAsQueueImpl.Wrapping(reader);
    }

    public StringReader getOriginal();

    @Override
    default public boolean isEmpty() {
        return !this.getOriginal().canRead();
    }

    @Override
    default public boolean contains(Object element) {
        if (element == null) {
            return false;
        }
        int cursor = this.getOriginal().getCursor();
        String contents = this.getOriginal().getString();
        int idx = contents.indexOf((String)element, cursor);
        if (idx == -1) {
            return false;
        }
        int length = this.getOriginal().getTotalLength();
        int end = idx + contents.length();
        return !(idx != cursor && !Character.isWhitespace(contents.charAt(idx - 1)) || end != length && !Character.isWhitespace(contents.charAt(end)));
    }

    @Override
    default public @NonNull Iterator<String> iterator() {
        return new Iterator<String>(){
            private final String contents;
            private int rangeStart;
            private int rangeEnd;
            {
                this.contents = StringReaderAsQueue.this.getOriginal().getString();
                this.rangeStart = StringReaderAsQueue.this.getOriginal().getCursor();
                this.rangeEnd = this.calculateNextEnd();
            }

            private int calculateNextEnd() {
                if (this.rangeStart >= this.contents.length()) {
                    return -1;
                }
                int nextSpace = StringReaderAsQueueImpl.nextWhitespace(this.contents, this.rangeStart);
                return nextSpace == -1 ? this.contents.length() : nextSpace;
            }

            private void computeNext() {
                this.rangeStart = this.rangeEnd + 1;
                this.rangeEnd = this.calculateNextEnd();
            }

            @Override
            public boolean hasNext() {
                return this.rangeEnd > 0;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String next = this.contents.substring(this.rangeStart, this.rangeEnd);
                this.computeNext();
                return next;
            }
        };
    }

    @Override
    default public Object[] toArray() {
        if (this.isEmpty()) {
            return new Object[0];
        }
        ArrayList<String> out = new ArrayList<String>(5);
        for (String element : this) {
            out.add(element);
        }
        return out.toArray();
    }

    @Override
    default public <T> T[] toArray(T[] a) {
        if (this.isEmpty()) {
            return Arrays.copyOf(a, 0);
        }
        ArrayList<String> out = new ArrayList<String>(5);
        for (String element : this) {
            out.add(element);
        }
        return out.toArray(a);
    }

    @Override
    default public boolean add(String element) {
        throw new IllegalStateException("StringReaders cannot have elements appended");
    }

    @Override
    default public boolean offer(String element) {
        return false;
    }

    @Override
    default public String remove() {
        String result = (String)this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    default public String element() {
        String result = (String)this.peek();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    default public boolean containsAll(@NonNull Collection<?> elements) {
        throw new UnsupportedOperationException("Complex Queue operations are not yet implemented in Cloud");
    }

    @Override
    default public boolean addAll(@NonNull Collection<? extends String> elements) {
        throw new UnsupportedOperationException("Complex Queue operations are not yet implemented in Cloud");
    }

    @Override
    default public boolean removeAll(@NonNull Collection<?> elements) {
        throw new UnsupportedOperationException("Complex Queue operations are not yet implemented in Cloud");
    }

    @Override
    default public boolean retainAll(@NonNull Collection<?> elements) {
        throw new UnsupportedOperationException("Complex Queue operations are not yet implemented in Cloud");
    }

    @Override
    default public void clear() {
        this.getOriginal().setCursor(this.getOriginal().getTotalLength());
    }
}

