/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser;

import io.leangen.geantyref.AnnotatedTypeMap;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.annotations.specifier.FlagYielding;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.annotations.specifier.Greedy;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.annotations.specifier.Liberal;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.annotations.specifier.Quoted;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.annotations.specifier.Range;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ArgumentParser;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ParserParameters;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.ParserRegistry;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.parser.StandardParameters;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.BooleanArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.ByteArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.CharArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.DoubleArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.DurationArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.EnumArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.FloatArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.IntegerArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.LongArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.ShortArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.StringArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.StringArrayArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.standard.UUIDArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;

@API(status=API.Status.STABLE)
public final class StandardParserRegistry<C>
implements ParserRegistry<C> {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_MAPPINGS = new HashMap<Class<?>, Class<?>>(){
        private static final long serialVersionUID = 958977651563195489L;
        {
            this.put(Character.TYPE, Character.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Short.TYPE, Short.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
            this.put(Long.TYPE, Long.class);
            this.put(Boolean.TYPE, Boolean.class);
        }
    };
    private final Map<String, Function<ParserParameters, ArgumentParser<C, ?>>> namedParsers = new HashMap();
    private final Map<AnnotatedType, Function<ParserParameters, ArgumentParser<C, ?>>> parserSuppliers = new AnnotatedTypeMap();
    private final Map<Class<? extends Annotation>, BiFunction<? extends Annotation, TypeToken<?>, ParserParameters>> annotationMappers = new HashMap();
    private final Map<String, BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>>> namedSuggestionProviders = new HashMap<String, BiFunction<CommandContext<C>, String, List<String>>>();

    public StandardParserRegistry() {
        this.registerAnnotationMapper(Range.class, new RangeMapper());
        this.registerAnnotationMapper(Greedy.class, new GreedyMapper());
        this.registerAnnotationMapper(Quoted.class, (quoted, typeToken) -> ParserParameters.single(StandardParameters.QUOTED, true));
        this.registerAnnotationMapper(Liberal.class, (liberal, typeToken) -> ParserParameters.single(StandardParameters.LIBERAL, true));
        this.registerAnnotationMapper(FlagYielding.class, (flagYielding, typeToken) -> ParserParameters.single(StandardParameters.FLAG_YIELDING, true));
        this.registerParserSupplier(TypeToken.get(Byte.class), options -> new ByteArgument.ByteParser((Byte)((Number)options.get(StandardParameters.RANGE_MIN, (byte)-128)), (Byte)((Number)options.get(StandardParameters.RANGE_MAX, (byte)127))));
        this.registerParserSupplier(TypeToken.get(Short.class), options -> new ShortArgument.ShortParser((Short)((Number)options.get(StandardParameters.RANGE_MIN, (short)Short.MIN_VALUE)), (Short)((Number)options.get(StandardParameters.RANGE_MAX, (short)Short.MAX_VALUE))));
        this.registerParserSupplier(TypeToken.get(Integer.class), options -> new IntegerArgument.IntegerParser((Integer)((Number)options.get(StandardParameters.RANGE_MIN, Integer.MIN_VALUE)), (Integer)((Number)options.get(StandardParameters.RANGE_MAX, Integer.MAX_VALUE))));
        this.registerParserSupplier(TypeToken.get(Long.class), options -> new LongArgument.LongParser((Long)((Number)options.get(StandardParameters.RANGE_MIN, Long.MIN_VALUE)), (Long)((Number)options.get(StandardParameters.RANGE_MAX, Long.MAX_VALUE))));
        this.registerParserSupplier(TypeToken.get(Float.class), options -> new FloatArgument.FloatParser(((Float)((Number)options.get(StandardParameters.RANGE_MIN, Float.valueOf(Float.NEGATIVE_INFINITY)))).floatValue(), ((Float)((Number)options.get(StandardParameters.RANGE_MAX, Float.valueOf(Float.POSITIVE_INFINITY)))).floatValue()));
        this.registerParserSupplier(TypeToken.get(Double.class), options -> new DoubleArgument.DoubleParser((Double)((Number)options.get(StandardParameters.RANGE_MIN, Double.NEGATIVE_INFINITY)), (Double)((Number)options.get(StandardParameters.RANGE_MAX, Double.POSITIVE_INFINITY))));
        this.registerParserSupplier(TypeToken.get(Character.class), options -> new CharArgument.CharacterParser());
        this.registerParserSupplier(TypeToken.get(String[].class), options -> new StringArrayArgument.StringArrayParser(options.get(StandardParameters.FLAG_YIELDING, false)));
        this.registerParserSupplier(TypeToken.get(String.class), options -> {
            boolean greedy = options.get(StandardParameters.GREEDY, false);
            boolean greedyFlagAware = options.get(StandardParameters.FLAG_YIELDING, false);
            boolean quoted = options.get(StandardParameters.QUOTED, false);
            if (greedyFlagAware && quoted) {
                throw new IllegalArgumentException("Don't know whether to create GREEDY_FLAG_YIELDING or QUOTED StringArgument.StringParser, both specified.");
            }
            if (greedy && quoted) {
                throw new IllegalArgumentException("Don't know whether to create GREEDY or QUOTED StringArgument.StringParser, both specified.");
            }
            StringArgument.StringMode stringMode = greedyFlagAware ? StringArgument.StringMode.GREEDY_FLAG_YIELDING : (greedy ? StringArgument.StringMode.GREEDY : (quoted ? StringArgument.StringMode.QUOTED : StringArgument.StringMode.SINGLE));
            return new StringArgument.StringParser(stringMode, (context, s) -> Arrays.asList(options.get(StandardParameters.COMPLETIONS, new String[0])));
        });
        this.registerParserSupplier(TypeToken.get(Boolean.class), options -> {
            boolean liberal = options.get(StandardParameters.LIBERAL, false);
            return new BooleanArgument.BooleanParser(liberal);
        });
        this.registerParserSupplier(TypeToken.get(UUID.class), options -> new UUIDArgument.UUIDParser());
        this.registerParserSupplier(TypeToken.get(Duration.class), options -> new DurationArgument.Parser());
    }

    private static boolean isPrimitive(@NonNull TypeToken<?> type) {
        return GenericTypeReflector.erase(type.getType()).isPrimitive();
    }

    @Override
    public <T> void registerParserSupplier(@NonNull TypeToken<T> type, @NonNull Function<@NonNull ParserParameters, @NonNull ArgumentParser<C, ?>> supplier) {
        this.parserSuppliers.put(type.getAnnotatedType(), supplier);
    }

    @Override
    public void registerNamedParserSupplier(@NonNull String name, @NonNull Function<@NonNull ParserParameters, @NonNull ArgumentParser<C, ?>> supplier) {
        this.namedParsers.put(name, supplier);
    }

    @Override
    public <A extends Annotation, T> void registerAnnotationMapper(@NonNull Class<A> annotation, @NonNull BiFunction<@NonNull A, @NonNull TypeToken<?>, @NonNull ParserParameters> mapper) {
        this.annotationMappers.put(annotation, mapper);
    }

    @Override
    public @NonNull ParserParameters parseAnnotations(@NonNull TypeToken<?> parsingType, @NonNull Collection<@NonNull ? extends Annotation> annotations) {
        ParserParameters parserParameters = new ParserParameters();
        annotations.forEach(annotation -> {
            BiFunction<Annotation, TypeToken<?>, ParserParameters> mapper = this.annotationMappers.get(annotation.annotationType());
            if (mapper == null) {
                return;
            }
            ParserParameters parserParametersCasted = mapper.apply((Annotation)annotation, parsingType);
            parserParameters.merge(parserParametersCasted);
        });
        return parserParameters;
    }

    @Override
    public <T> @NonNull Optional<ArgumentParser<C, T>> createParser(@NonNull TypeToken<T> type, @NonNull ParserParameters parserParameters) {
        TypeToken<Object> actualType = GenericTypeReflector.erase(type.getType()).isPrimitive() ? TypeToken.get(PRIMITIVE_MAPPINGS.get(GenericTypeReflector.erase(type.getType()))) : type;
        Function<ParserParameters, ArgumentParser<C, ?>> producer = this.parserSuppliers.get(actualType.getAnnotatedType());
        if (producer == null) {
            if (GenericTypeReflector.isSuperType(Enum.class, actualType.getType())) {
                EnumArgument.EnumParser enumArgument = new EnumArgument.EnumParser(GenericTypeReflector.erase(actualType.getType()));
                return Optional.of(enumArgument);
            }
            return Optional.empty();
        }
        ArgumentParser<C, ?> parser = producer.apply(parserParameters);
        return Optional.of(parser);
    }

    @Override
    public <T> @NonNull Optional<ArgumentParser<C, T>> createParser(@NonNull String name, @NonNull ParserParameters parserParameters) {
        Function<ParserParameters, ArgumentParser<C, ?>> producer = this.namedParsers.get(name);
        if (producer == null) {
            return Optional.empty();
        }
        ArgumentParser<C, ?> parser = producer.apply(parserParameters);
        return Optional.of(parser);
    }

    @Override
    public void registerSuggestionProvider(@NonNull String name, @NonNull BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> suggestionsProvider) {
        this.namedSuggestionProviders.put(name.toLowerCase(Locale.ENGLISH), suggestionsProvider);
    }

    @Override
    public @NonNull Optional<BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>>> getSuggestionProvider(@NonNull String name) {
        BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<String>> suggestionProvider = this.namedSuggestionProviders.get(name.toLowerCase(Locale.ENGLISH));
        return Optional.ofNullable(suggestionProvider);
    }

    private static final class RangeMapper
    implements BiFunction<Range, TypeToken<?>, ParserParameters> {
        private RangeMapper() {
        }

        @Override
        public @NonNull ParserParameters apply(@NonNull Range range, @NonNull TypeToken<?> type) {
            Class clazz = StandardParserRegistry.isPrimitive(type) ? (Class)PRIMITIVE_MAPPINGS.get(GenericTypeReflector.erase(type.getType())) : GenericTypeReflector.erase(type.getType());
            if (!Number.class.isAssignableFrom(clazz)) {
                return ParserParameters.empty();
            }
            Number min = null;
            Number max = null;
            if (clazz.equals(Byte.class)) {
                if (!range.min().isEmpty()) {
                    min = Byte.parseByte(range.min());
                }
                if (!range.max().isEmpty()) {
                    max = Byte.parseByte(range.max());
                }
            } else if (clazz.equals(Short.class)) {
                if (!range.min().isEmpty()) {
                    min = Short.parseShort(range.min());
                }
                if (!range.max().isEmpty()) {
                    max = Short.parseShort(range.max());
                }
            } else if (clazz.equals(Integer.class)) {
                if (!range.min().isEmpty()) {
                    min = Integer.parseInt(range.min());
                }
                if (!range.max().isEmpty()) {
                    max = Integer.parseInt(range.max());
                }
            } else if (clazz.equals(Long.class)) {
                if (!range.min().isEmpty()) {
                    min = Long.parseLong(range.min());
                }
                if (!range.max().isEmpty()) {
                    max = Long.parseLong(range.max());
                }
            } else if (clazz.equals(Float.class)) {
                if (!range.min().isEmpty()) {
                    min = Float.valueOf(Float.parseFloat(range.min()));
                }
                if (!range.max().isEmpty()) {
                    max = Float.valueOf(Float.parseFloat(range.max()));
                }
            } else if (clazz.equals(Double.class)) {
                if (!range.min().isEmpty()) {
                    min = Double.parseDouble(range.min());
                }
                if (!range.max().isEmpty()) {
                    max = Double.parseDouble(range.max());
                }
            }
            ParserParameters parserParameters = new ParserParameters();
            if (min != null) {
                parserParameters.store(StandardParameters.RANGE_MIN, min);
            }
            if (max != null) {
                parserParameters.store(StandardParameters.RANGE_MAX, max);
            }
            return parserParameters;
        }
    }

    private static final class GreedyMapper
    implements BiFunction<Greedy, TypeToken<?>, ParserParameters> {
        private GreedyMapper() {
        }

        @Override
        public @NonNull ParserParameters apply(@NonNull Greedy greedy, @NonNull TypeToken<?> typeToken) {
            return ParserParameters.single(StandardParameters.GREEDY, true);
        }
    }
}

