/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.flags;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.ArgumentDescription;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.Description;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.permission.CommandPermission;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.permission.Permission;

@API(status=API.Status.STABLE)
public final class CommandFlag<T> {
    private final @NonNull String name;
    private final @NonNull String @NonNull [] aliases;
    private final @NonNull ArgumentDescription description;
    private final @NonNull CommandPermission permission;
    private final @NonNull FlagMode mode;
    private final @Nullable CommandArgument<?, T> commandArgument;

    private CommandFlag(@NonNull String name, @NonNull String @NonNull [] aliases, @NonNull ArgumentDescription description, @NonNull CommandPermission permission, @Nullable CommandArgument<?, T> commandArgument, @NonNull FlagMode mode) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.aliases = Objects.requireNonNull(aliases, "aliases cannot be null");
        this.description = Objects.requireNonNull(description, "description cannot be null");
        this.permission = Objects.requireNonNull(permission, "permission cannot be null");
        this.commandArgument = commandArgument;
        this.mode = Objects.requireNonNull(mode, "mode cannot be null");
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static @NonNull Builder<Void> builder(@NonNull String name) {
        return new Builder<Void>(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static @NonNull Builder<Void> newBuilder(@NonNull String name) {
        return new Builder<Void>(name);
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Collection<@NonNull String> getAliases() {
        return Arrays.asList(this.aliases);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public @NonNull FlagMode mode() {
        return this.mode;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public @NonNull Description getDescription() {
        if (this.description instanceof Description) {
            return (Description)this.description;
        }
        return Description.of(this.description.getDescription());
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public @NonNull ArgumentDescription getArgumentDescription() {
        return this.description;
    }

    public @Nullable CommandArgument<?, T> getCommandArgument() {
        return this.commandArgument;
    }

    @API(status=API.Status.STABLE, since="1.6.0")
    public CommandPermission permission() {
        return this.permission;
    }

    public String toString() {
        return String.format("--%s", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandFlag that = (CommandFlag)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public static enum FlagMode {
        SINGLE,
        REPEATABLE;

    }

    @API(status=API.Status.STABLE)
    public static final class Builder<T> {
        private final String name;
        private final String[] aliases;
        private final ArgumentDescription description;
        private final CommandPermission permission;
        private final CommandArgument<?, T> commandArgument;
        private final FlagMode mode;

        private Builder(@NonNull String name, @NonNull String[] aliases, @NonNull ArgumentDescription description, @NonNull CommandPermission permission, @Nullable CommandArgument<?, T> commandArgument, @NonNull FlagMode mode) {
            this.name = name;
            this.aliases = aliases;
            this.description = description;
            this.permission = permission;
            this.commandArgument = commandArgument;
            this.mode = mode;
        }

        private Builder(@NonNull String name) {
            this(name, new String[0], ArgumentDescription.empty(), Permission.empty(), null, FlagMode.SINGLE);
        }

        public @NonNull Builder<T> withAliases(String ... aliases) {
            HashSet<String> filteredAliases = new HashSet<String>();
            for (String alias : aliases) {
                if (alias.isEmpty()) continue;
                if (alias.length() > 1) {
                    throw new IllegalArgumentException(String.format("Alias '%s' has name longer than one character. This is not allowed", alias));
                }
                filteredAliases.add(alias);
            }
            return new Builder<T>(this.name, filteredAliases.toArray(new String[0]), this.description, this.permission, this.commandArgument, this.mode);
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.4.0")
        public @NonNull Builder<T> withDescription(@NonNull Description description) {
            return this.withDescription((ArgumentDescription)description);
        }

        @API(status=API.Status.STABLE, since="1.4.0")
        public @NonNull Builder<T> withDescription(@NonNull ArgumentDescription description) {
            return new Builder<T>(this.name, this.aliases, description, this.permission, this.commandArgument, this.mode);
        }

        public <N> @NonNull Builder<N> withArgument(@NonNull CommandArgument<?, N> argument) {
            return new Builder<N>(this.name, this.aliases, this.description, this.permission, argument, this.mode);
        }

        public <N> @NonNull Builder<N> withArgument(@NonNull CommandArgument.Builder<?, N> builder) {
            return this.withArgument(builder.build());
        }

        @API(status=API.Status.STABLE, since="1.6.0")
        public @NonNull Builder<T> withPermission(@NonNull CommandPermission permission) {
            return new Builder<T>(this.name, this.aliases, this.description, permission, this.commandArgument, this.mode);
        }

        @API(status=API.Status.STABLE, since="1.7.0")
        public @NonNull Builder<T> asRepeatable() {
            return new Builder<T>(this.name, this.aliases, this.description, this.permission, this.commandArgument, FlagMode.REPEATABLE);
        }

        public @NonNull CommandFlag<T> build() {
            return new CommandFlag(this.name, this.aliases, this.description, this.permission, this.commandArgument, this.mode);
        }
    }
}

