/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework.annotations.injection;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.annotations.AnnotationAccessor;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.annotations.injection.InjectionService;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.context.CommandContext;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.types.tuples.Triplet;

@API(status=API.Status.STABLE, since="1.4.0")
public final class GuiceInjectionService<C>
implements InjectionService<C> {
    private final Injector injector;

    private GuiceInjectionService(@NonNull Injector injector) {
        this.injector = injector;
    }

    public static <C> GuiceInjectionService<C> create(@NonNull Injector injector) {
        return new GuiceInjectionService<C>(injector);
    }

    @Override
    public @Nullable Object handle(@NonNull Triplet<CommandContext<C>, Class<?>, AnnotationAccessor> triplet) {
        try {
            return this.injector.getInstance(triplet.getSecond());
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }
}

