/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.simpleitemgenerator.commandframework;

import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.ArgumentDescription;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.CommandComponent;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.CommandManager;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.Description;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.CommandArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.StaticArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.compound.ArgumentPair;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.compound.ArgumentTriplet;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.compound.FlagArgument;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.arguments.flags.CommandFlag;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.execution.CommandExecutionHandler;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.meta.CommandMeta;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.meta.SimpleCommandMeta;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.permission.CommandPermission;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.permission.Permission;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.permission.PredicatePermission;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.types.tuples.Pair;
import ua.valeriishymchuk.simpleitemgenerator.commandframework.types.tuples.Triplet;

@API(status=API.Status.STABLE)
public class Command<C> {
    private final List<@NonNull CommandComponent<C>> components;
    private final List<@NonNull CommandArgument<C, ?>> arguments;
    private final @Nullable FlagArgument<C> flagArgument;
    private final CommandExecutionHandler<C> commandExecutionHandler;
    private final Class<? extends C> senderType;
    private final CommandPermission commandPermission;
    private final CommandMeta commandMeta;

    @API(status=API.Status.STABLE, since="1.3.0")
    public Command(@NonNull List<@NonNull CommandComponent<C>> commandComponents, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this.components = Objects.requireNonNull(commandComponents, "Command components may not be null");
        this.arguments = this.components.stream().map(CommandComponent::getArgument).collect(Collectors.toList());
        if (this.components.isEmpty()) {
            throw new IllegalArgumentException("At least one command component is required");
        }
        this.flagArgument = this.arguments.stream().filter(ca -> ca instanceof FlagArgument).map(ca -> (FlagArgument)ca).findFirst().orElse(null);
        boolean foundOptional = false;
        for (CommandArgument<C, ?> argument : this.arguments) {
            if (argument.getName().isEmpty()) {
                throw new IllegalArgumentException("Argument names may not be empty");
            }
            if (foundOptional && argument.isRequired()) {
                throw new IllegalArgumentException(String.format("Command argument '%s' cannot be placed after an optional argument", argument.getName()));
            }
            if (argument.isRequired()) continue;
            foundOptional = true;
        }
        this.commandExecutionHandler = commandExecutionHandler;
        this.senderType = senderType;
        this.commandPermission = commandPermission;
        this.commandMeta = commandMeta;
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public Command(@NonNull List<@NonNull CommandComponent<C>> commandComponents, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandMeta commandMeta) {
        this(commandComponents, commandExecutionHandler, senderType, (CommandPermission)Permission.empty(), commandMeta);
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public Command(@NonNull List<@NonNull CommandComponent<C>> commandComponents, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this(commandComponents, commandExecutionHandler, null, commandPermission, commandMeta);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED)
    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this(Command.mapToComponents(commandArguments), commandExecutionHandler, senderType, commandPermission, commandMeta);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED)
    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @Nullable Class<? extends C> senderType, @NonNull CommandMeta commandMeta) {
        this(Command.mapToComponents(commandArguments), commandExecutionHandler, senderType, commandMeta);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED)
    public Command(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @NonNull CommandPermission commandPermission, @NonNull CommandMeta commandMeta) {
        this(Command.mapToComponents(commandArguments), commandExecutionHandler, commandPermission, commandMeta);
    }

    private static <C> @NonNull List<@NonNull CommandComponent<C>> mapToComponents(@NonNull Map<@NonNull CommandArgument<C, ?>, @NonNull Description> commandArguments) {
        return commandArguments.entrySet().stream().map(e -> CommandComponent.of((CommandArgument)e.getKey(), (Description)e.getValue())).collect(Collectors.toList());
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4.0")
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String commandName, @NonNull CommandMeta commandMeta, @NonNull Description description, String ... aliases) {
        return Command.newBuilder(commandName, commandMeta, (ArgumentDescription)description, aliases);
    }

    @API(status=API.Status.STABLE, since="1.4.0")
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String commandName, @NonNull CommandMeta commandMeta, @NonNull ArgumentDescription description, String ... aliases) {
        ArrayList commands = new ArrayList();
        commands.add(CommandComponent.of(StaticArgument.of(commandName, aliases), description));
        return new Builder(null, commandMeta, null, commands, new CommandExecutionHandler.NullCommandExecutionHandler(), Permission.empty(), Collections.emptyList());
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String commandName, @NonNull CommandMeta commandMeta, String ... aliases) {
        ArrayList commands = new ArrayList();
        commands.add(CommandComponent.of(StaticArgument.of(commandName, aliases), ArgumentDescription.empty()));
        return new Builder(null, commandMeta, null, commands, new CommandExecutionHandler.NullCommandExecutionHandler(), Permission.empty(), Collections.emptyList());
    }

    public @NonNull List<CommandArgument<@NonNull C, @NonNull ?>> getArguments() {
        return new ArrayList(this.arguments);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.8.0")
    public @NonNull List<CommandArgument<@NonNull C, @NonNull ?>> nonFlagArguments() {
        ArrayList arguments = new ArrayList(this.arguments);
        if (this.flagArgument != null) {
            arguments.remove(this.flagArgument);
        }
        return arguments;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.8.0")
    public @Nullable FlagArgument<@NonNull C> flagArgument() {
        return this.flagArgument;
    }

    @API(status=API.Status.STABLE, since="1.3.0")
    public @NonNull List<CommandComponent<@NonNull C>> getComponents() {
        return new ArrayList<CommandComponent<C>>(this.components);
    }

    public CommandExecutionHandler<@NonNull C> getCommandExecutionHandler() {
        return this.commandExecutionHandler;
    }

    public @NonNull Optional<Class<? extends C>> getSenderType() {
        return Optional.ofNullable(this.senderType);
    }

    public @NonNull CommandPermission getCommandPermission() {
        return this.commandPermission;
    }

    public @NonNull CommandMeta getCommandMeta() {
        return this.commandMeta;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED)
    public @NonNull String getArgumentDescription(@NonNull CommandArgument<C, ?> argument) {
        for (CommandComponent<C> component : this.components) {
            if (!component.getArgument().equals(argument)) continue;
            return component.getArgumentDescription().getDescription();
        }
        throw new IllegalArgumentException("Command argument not found: " + argument);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CommandArgument<C, ?> argument : this.getArguments()) {
            stringBuilder.append(argument.getName()).append(' ');
        }
        String build = stringBuilder.toString();
        return build.substring(0, build.length() - 1);
    }

    public boolean isHidden() {
        return this.getCommandMeta().getOrDefault(CommandMeta.HIDDEN, false);
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C> {
        private final CommandMeta commandMeta;
        private final List<CommandComponent<C>> commandComponents;
        private final CommandExecutionHandler<C> commandExecutionHandler;
        private final Class<? extends C> senderType;
        private final CommandPermission commandPermission;
        private final CommandManager<C> commandManager;
        private final Collection<CommandFlag<?>> flags;

        private Builder(@Nullable CommandManager<C> commandManager, @NonNull CommandMeta commandMeta, @Nullable Class<? extends C> senderType, @NonNull List<@NonNull CommandComponent<C>> commandComponents, @NonNull CommandExecutionHandler<@NonNull C> commandExecutionHandler, @NonNull CommandPermission commandPermission, @NonNull Collection<CommandFlag<?>> flags) {
            this.commandManager = commandManager;
            this.senderType = senderType;
            this.commandComponents = Objects.requireNonNull(commandComponents, "Components may not be null");
            this.commandExecutionHandler = Objects.requireNonNull(commandExecutionHandler, "Execution handler may not be null");
            this.commandPermission = Objects.requireNonNull(commandPermission, "Permission may not be null");
            this.commandMeta = Objects.requireNonNull(commandMeta, "Meta may not be null");
            this.flags = Objects.requireNonNull(flags, "Flags may not be null");
        }

        @API(status=API.Status.STABLE, since="1.3.0")
        public @Nullable Class<? extends C> senderType() {
            return this.senderType;
        }

        @API(status=API.Status.STABLE, since="1.3.0")
        public @NonNull CommandPermission commandPermission() {
            return this.commandPermission;
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        public @NonNull Builder<@NonNull C> apply(@NonNull Applicable<@NonNull C> applicable) {
            return applicable.applyToCommandBuilder(this);
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.2.0")
        public @NonNull Builder<C> meta(@NonNull String key, @NonNull String value) {
            SimpleCommandMeta commandMeta = SimpleCommandMeta.builder().with(this.commandMeta).with(key, value).build();
            return new Builder<C>(this.commandManager, commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        @API(status=API.Status.STABLE, since="1.3.0")
        public <V> @NonNull Builder<C> meta(@NonNull CommandMeta.Key<V> key, @NonNull V value) {
            SimpleCommandMeta commandMeta = SimpleCommandMeta.builder().with(this.commandMeta).with(key, value).build();
            return new Builder<C>(this.commandManager, commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> manager(@Nullable CommandManager<C> commandManager) {
            return new Builder<C>(commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> literal(@NonNull String main, String ... aliases) {
            return this.argument(StaticArgument.of(main, aliases));
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.4.0")
        public @NonNull Builder<C> literal(@NonNull String main, @NonNull Description description, String ... aliases) {
            return this.argument(StaticArgument.of(main, aliases), description);
        }

        @API(status=API.Status.STABLE, since="1.4.0")
        public @NonNull Builder<C> literal(@NonNull String main, @NonNull ArgumentDescription description, String ... aliases) {
            return this.argument(StaticArgument.of(main, aliases), description);
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument.Builder<C, T> builder) {
            return this.argument(builder.build());
        }

        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument<C, T> argument) {
            return this.argument(argument, argument.getDefaultDescription());
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.4.0")
        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument<C, T> argument, @NonNull Description description) {
            return this.argument(argument, (ArgumentDescription)description);
        }

        @API(status=API.Status.STABLE, since="1.4.0")
        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument<C, T> argument, @NonNull ArgumentDescription description) {
            if (argument.isArgumentRegistered()) {
                throw new IllegalArgumentException("The provided argument has already been associated with a command. Use CommandArgument#copy to create a copy of the argument.");
            }
            argument.setArgumentRegistered();
            ArrayList<CommandComponent<C>> commandComponents = new ArrayList<CommandComponent<C>>(this.commandComponents);
            commandComponents.add(CommandComponent.of(argument, description));
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.4.0")
        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument.Builder<C, T> builder, @NonNull Description description) {
            return this.argument(builder, (ArgumentDescription)description);
        }

        @API(status=API.Status.STABLE, since="1.4.0")
        public <T> @NonNull Builder<C> argument(@NonNull CommandArgument.Builder<C, T> builder, @NonNull ArgumentDescription description) {
            ArrayList<CommandComponent<C>> commandComponents = new ArrayList<CommandComponent<C>>(this.commandComponents);
            commandComponents.add(CommandComponent.of(builder.build(), description));
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public <T> @NonNull Builder<C> argument(@NonNull Class<T> clazz, @NonNull String name, @NonNull Consumer<CommandArgument.Builder<C, T>> builderConsumer) {
            CommandArgument.Builder<C, T> builder = CommandArgument.ofType(clazz, name);
            if (this.commandManager != null) {
                builder.manager(this.commandManager);
            }
            builderConsumer.accept(builder);
            return this.argument(builder.build());
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.4.0")
        public <U, V> @NonNull Builder<C> argumentPair(@NonNull String name, @NonNull Pair<@NonNull String, @NonNull String> names, @NonNull Pair<@NonNull Class<U>, @NonNull Class<V>> parserPair, @NonNull Description description) {
            return this.argumentPair(name, names, parserPair, (ArgumentDescription)description);
        }

        @API(status=API.Status.STABLE, since="1.4.0")
        public <U, V> @NonNull Builder<C> argumentPair(@NonNull String name, @NonNull Pair<@NonNull String, @NonNull String> names, @NonNull Pair<@NonNull Class<U>, @NonNull Class<V>> parserPair, @NonNull ArgumentDescription description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentPair.of(this.commandManager, name, names, parserPair).simple(), description);
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.4.0")
        public <U, V, O> @NonNull Builder<C> argumentPair(@NonNull String name, @NonNull TypeToken<O> outputType, @NonNull Pair<String, String> names, @NonNull Pair<Class<U>, Class<V>> parserPair, @NonNull BiFunction<C, Pair<U, V>, O> mapper, @NonNull Description description) {
            return this.argumentPair(name, outputType, names, parserPair, mapper, (ArgumentDescription)description);
        }

        @API(status=API.Status.STABLE, since="1.4.0")
        public <U, V, O> @NonNull Builder<C> argumentPair(@NonNull String name, @NonNull TypeToken<O> outputType, @NonNull Pair<String, String> names, @NonNull Pair<Class<U>, Class<V>> parserPair, @NonNull BiFunction<C, Pair<U, V>, O> mapper, @NonNull ArgumentDescription description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentPair.of(this.commandManager, name, names, parserPair).withMapper(outputType, mapper), description);
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.4.0")
        public <U, V, W> @NonNull Builder<C> argumentTriplet(@NonNull String name, @NonNull Triplet<String, String, String> names, @NonNull Triplet<Class<U>, Class<V>, Class<W>> parserTriplet, @NonNull Description description) {
            return this.argumentTriplet(name, names, parserTriplet, (ArgumentDescription)description);
        }

        @API(status=API.Status.STABLE, since="1.4.0")
        public <U, V, W> @NonNull Builder<C> argumentTriplet(@NonNull String name, @NonNull Triplet<String, String, String> names, @NonNull Triplet<Class<U>, Class<V>, Class<W>> parserTriplet, @NonNull ArgumentDescription description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentTriplet.of(this.commandManager, name, names, parserTriplet).simple(), description);
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.4.0")
        public <U, V, W, O> @NonNull Builder<C> argumentTriplet(@NonNull String name, @NonNull TypeToken<O> outputType, @NonNull Triplet<String, String, String> names, @NonNull Triplet<Class<U>, Class<V>, Class<W>> parserTriplet, @NonNull BiFunction<C, Triplet<U, V, W>, O> mapper, @NonNull Description description) {
            return this.argumentTriplet(name, outputType, names, parserTriplet, mapper, (ArgumentDescription)description);
        }

        @API(status=API.Status.STABLE, since="1.4.0")
        public <U, V, W, O> @NonNull Builder<C> argumentTriplet(@NonNull String name, @NonNull TypeToken<O> outputType, @NonNull Triplet<String, String, String> names, @NonNull Triplet<Class<U>, Class<V>, Class<W>> parserTriplet, @NonNull BiFunction<C, Triplet<U, V, W>, O> mapper, @NonNull ArgumentDescription description) {
            if (this.commandManager == null) {
                throw new IllegalStateException("This cannot be called from a command that has no command manager attached");
            }
            return this.argument(ArgumentTriplet.of(this.commandManager, name, names, parserTriplet).withMapper(outputType, mapper), description);
        }

        public @NonNull Builder<C> handler(@NonNull CommandExecutionHandler<C> commandExecutionHandler) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, commandExecutionHandler, this.commandPermission, this.flags);
        }

        @API(status=API.Status.STABLE, since="1.7.0")
        public @NonNull CommandExecutionHandler<C> handler() {
            return this.commandExecutionHandler;
        }

        public @NonNull Builder<C> senderType(@NonNull Class<? extends C> senderType) {
            return new Builder<C>(this.commandManager, this.commandMeta, senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, this.flags);
        }

        public @NonNull Builder<C> permission(@NonNull CommandPermission permission) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, permission, this.flags);
        }

        public @NonNull Builder<C> permission(@NonNull PredicatePermission<C> permission) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, permission, this.flags);
        }

        public @NonNull Builder<C> permission(@NonNull String permission) {
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, Permission.of(permission), this.flags);
        }

        public @NonNull Builder<C> proxies(@NonNull Command<C> command) {
            Builder<C> builder = this;
            for (CommandComponent<C> component : command.getComponents()) {
                CommandArgument<C, ?> argument = component.getArgument();
                if (argument instanceof StaticArgument) continue;
                CommandArgument<C, ?> builtArgument = argument.copy();
                builder = builder.argument(builtArgument, component.getArgumentDescription());
            }
            if (this.commandPermission.toString().isEmpty()) {
                builder = builder.permission(command.getCommandPermission());
            }
            return builder.handler(((Command)command).commandExecutionHandler);
        }

        public @NonNull Builder<C> hidden() {
            return this.meta(CommandMeta.HIDDEN, true);
        }

        public <T> @NonNull Builder<C> flag(@NonNull CommandFlag<T> flag) {
            ArrayList flags = new ArrayList(this.flags);
            flags.add(flag);
            return new Builder<C>(this.commandManager, this.commandMeta, this.senderType, this.commandComponents, this.commandExecutionHandler, this.commandPermission, Collections.unmodifiableList(flags));
        }

        public <T> @NonNull Builder<C> flag(@NonNull CommandFlag.Builder<T> builder) {
            return this.flag(builder.build());
        }

        public @NonNull Command<C> build() {
            ArrayList<CommandComponent<C>> commandComponents = new ArrayList<CommandComponent<C>>(this.commandComponents);
            if (!this.flags.isEmpty()) {
                FlagArgument flagArgument = new FlagArgument(this.flags);
                commandComponents.add(CommandComponent.of(flagArgument, ArgumentDescription.of("Command flags")));
            }
            return new Command<C>(Collections.unmodifiableList(commandComponents), this.commandExecutionHandler, this.senderType, this.commandPermission, this.commandMeta);
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        @FunctionalInterface
        public static interface Applicable<C> {
            @API(status=API.Status.STABLE, since="1.8.0")
            public @NonNull Builder<C> applyToCommandBuilder(@NonNull Builder<C> var1);
        }
    }
}

