/*
 * Decompiled with CFR 0.152.
 */
package ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.tag.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.Component;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.TranslatableComponent;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.TranslationArgument;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.format.StyleBuilderApplicable;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.Context;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.ParsingException;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.tag.Tag;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import ua.valeriishymchuk.libs.net.kyori.adventure.text.minimessage.tag.standard.StandardTags;

final class TranslatableFallbackTag {
    private static final String TR_OR = "tr_or";
    private static final String TRANSLATE_OR = "translate_or";
    private static final String LANG_OR = "lang_or";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(StandardTags.names("lang_or", "translate_or", "tr_or"), TranslatableFallbackTag::create, TranslatableFallbackTag::claim);

    private TranslatableFallbackTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        List with;
        String key = args.popOr("A translation key is required").value();
        String fallback = args.popOr("A fallback messages is required").value();
        if (args.hasNext()) {
            with = new ArrayList();
            while (args.hasNext()) {
                with.add(ctx.deserialize(args.pop().value()));
            }
        } else {
            with = Collections.emptyList();
        }
        return Tag.inserting(Component.translatable(key, fallback, with, new StyleBuilderApplicable[0]));
    }

    @Nullable
    static Emitable claim(Component input) {
        if (!(input instanceof TranslatableComponent) || ((TranslatableComponent)input).fallback() == null) {
            return null;
        }
        TranslatableComponent tr = (TranslatableComponent)input;
        return emit -> {
            emit.tag(LANG_OR);
            emit.argument(tr.key());
            emit.argument(tr.fallback());
            for (TranslationArgument with : tr.arguments()) {
                emit.argument(with.asComponent());
            }
        };
    }
}

