/*
 * Decompiled with CFR 0.152.
 */
package com.florianingerl.util.regex;

import com.florianingerl.util.regex.Capture;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class CaptureTreeNode {
    int groupNumber;
    String groupName;
    Capture capture;
    LinkedList<CaptureTreeNode> children = new LinkedList();
    CaptureTreeNode parent;
    boolean recursion;
    boolean inLookaround;

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Capture getCapture() {
        return this.capture;
    }

    public List<CaptureTreeNode> getChildren() {
        return this.children;
    }

    public CaptureTreeNode getParent() {
        return this.parent;
    }

    public boolean isRecursion() {
        return this.recursion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0);
        return sb.toString();
    }

    void setGroupName(Map<Integer, String> groupNames) {
        this.groupName = groupNames.get(this.groupNumber);
        for (CaptureTreeNode ctn : this.children) {
            ctn.setGroupName(groupNames);
        }
    }

    private void toString(StringBuilder sb, int numTabs) {
        int i = 0;
        while (i < numTabs) {
            sb.append("\t");
            ++i;
        }
        sb.append(this.groupName != null ? this.groupName : Integer.valueOf(this.groupNumber));
        sb.append("\n");
        for (CaptureTreeNode ctn : this.children) {
            ctn.toString(sb, numTabs + 1);
        }
    }

    Capture findGroup(int group) {
        return this.findGroup(group, true);
    }

    private Capture findGroup(int group, boolean searchParent) {
        ListIterator<CaptureTreeNode> it = this.children.listIterator(this.children.size());
        Capture c = this.findGroup(group, it);
        if (c != null) {
            return c;
        }
        if (searchParent) {
            CaptureTreeNode current = this;
            while (!current.recursion && current.parent != null) {
                current = current.parent;
                it = current.children.listIterator(current.children.size() - 1);
                c = this.findGroup(group, it);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    private Capture findGroup(int group, ListIterator<CaptureTreeNode> it) {
        while (it.hasPrevious()) {
            Capture c;
            CaptureTreeNode child = it.previous();
            if (child.groupNumber == group) {
                return child.capture;
            }
            if (child.recursion || (c = child.findGroup(group, false)) == null) continue;
            return c;
        }
        return null;
    }

    void shrinkChildrenTo(int size) {
        if (this.children.size() > size) {
            this.children.subList(size, this.children.size()).clear();
        }
    }
}

