/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.zombiehorse;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.world.MoonPhase;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="zombie-horse")
public final class ZombieHorseModule
extends PluginModule {
    public ZombieHorseModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLightningStrike(LightningStrikeEvent event) {
        if (event.getCause() != LightningStrikeEvent.Cause.WEATHER) {
            return;
        }
        Location location = event.getLightning().getLocation();
        if (ThreadLocalRandom.current().nextDouble() > this.spawnChance(location)) {
            return;
        }
        World world = location.getWorld();
        world.strikeLightningEffect(location);
        ZombieHorse horse = (ZombieHorse)world.spawn(location, ZombieHorse.class);
        horse.setNoDamageTicks(60);
        horse.setTamed(true);
        Zombie zombie = (Zombie)world.spawn(location, Zombie.class);
        zombie.setNoDamageTicks(60);
        horse.addPassenger((Entity)zombie);
        EntityEquipment equipment = zombie.getEquipment();
        equipment.setHelmet(ItemStack.of((Material)Material.IRON_HELMET));
        equipment.setChestplate(ItemStack.of((Material)Material.IRON_CHESTPLATE));
        equipment.setLeggings(ItemStack.of((Material)Material.IRON_LEGGINGS));
        equipment.setBoots(ItemStack.of((Material)Material.IRON_BOOTS));
        equipment.setItemInMainHand(ItemStack.of((Material)Material.IRON_SWORD));
        event.setCancelled(true);
    }

    private double spawnChance(@NotNull Location location) {
        World world = location.getWorld();
        Difficulty difficulty = world.getDifficulty();
        if (difficulty == Difficulty.PEACEFUL) {
            return 0.0;
        }
        long fullTime = world.getFullTime();
        double daytimeFactor = fullTime > 1512000L ? 0.25 : (fullTime < 72000L ? 0.0 : (double)(fullTime - 72000L) / 5760000.0);
        Chunk chunk = world.getChunkAt(location);
        long inhabitedTime = chunk.getInhabitedTime();
        double chunkFactor = inhabitedTime > TimeUnit.HOURS.toSeconds(50L) * 20L ? 1.0 : (double)inhabitedTime / 3600000.0;
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.EASY) {
            chunkFactor *= 0.75;
        }
        MoonPhase moonPhase = world.getMoonPhase();
        chunkFactor += Math.min((double)moonPhase.ordinal() / 4.0, daytimeFactor);
        if (difficulty == Difficulty.EASY) {
            chunkFactor *= 0.5;
        }
        double regionalDifficulty = 0.75 + daytimeFactor + chunkFactor;
        if (difficulty == Difficulty.NORMAL) {
            regionalDifficulty *= 2.0;
        } else if (difficulty == Difficulty.HARD) {
            regionalDifficulty *= 3.0;
        }
        return regionalDifficulty / 100.0;
    }
}

