/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.smoothsleeptransition;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.annotation.ConfigValue;
import com.uravgcode.survivalunlocked.module.PluginModule;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="smooth-sleep-transition")
public final class SmoothSleepTransitionModule
extends PluginModule {
    @ConfigValue(path="time-rate")
    private long timeRate = 120L;

    public SmoothSleepTransitionModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTimeSkip(TimeSkipEvent event) {
        if (event.getSkipReason() != TimeSkipEvent.SkipReason.NIGHT_SKIP) {
            return;
        }
        long skipAmount = event.getSkipAmount();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            long[] remaining = new long[]{skipAmount};
            player.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
                remaining[0] = Math.max(0L, remaining[0] - this.timeRate);
                player.setPlayerTime(-remaining[0], true);
                if (remaining[0] <= 0L) {
                    task.cancel();
                }
            }, null, 1L, 1L);
        }
    }
}

