/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.callyourpets;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.annotation.ConfigValue;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="call-your-pets")
public final class CallYourPetsModule
extends PluginModule {
    @ConfigValue(path="call-radius")
    private double callRadius = 64.0;
    @ConfigValue(path="stop-distance")
    private double stopDistance = 4.0;
    @ConfigValue(path="follow-time")
    private long followTime = 100L;

    public CallYourPetsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onHornBlow(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        if (hand == null) {
            return;
        }
        ItemStack item = player.getInventory().getItem(hand);
        if (item.getType() != Material.GOAT_HORN) {
            return;
        }
        if (player.hasCooldown(item)) {
            return;
        }
        Location location = player.getLocation();
        for (Entity entity : player.getNearbyEntities(this.callRadius, this.callRadius, this.callRadius)) {
            Sittable sittable;
            Tameable pet;
            if (!(entity instanceof Tameable) || (pet = (Tameable)entity) instanceof Sittable && (sittable = (Sittable)pet).isSitting() || !player.getUniqueId().equals(pet.getOwnerUniqueId())) continue;
            double speed = pet instanceof AbstractHorse ? 1.8 : 1.2;
            ScheduledTask followTask = pet.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
                if (pet.getLocation().distanceSquared(location) <= this.stopDistance * this.stopDistance) {
                    task.cancel();
                } else {
                    if (pet instanceof AbstractHorse) {
                        AbstractHorse horse = (AbstractHorse)pet;
                        horse.setEatingGrass(false);
                    }
                    pet.getPathfinder().moveTo(location, speed);
                }
            }, null, 1L, 10L);
            pet.getScheduler().runDelayed((Plugin)this.plugin, task -> {
                if (followTask != null) {
                    followTask.cancel();
                }
            }, null, this.followTime);
        }
    }
}

