/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.betterarmorstands;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import com.uravgcode.survivalunlocked.module.betterarmorstands.ArmorStandPose;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="better-armor-stands")
public final class BetterArmorStandsModule
extends PluginModule {
    private final NamespacedKey poseKey;

    public BetterArmorStandsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.poseKey = new NamespacedKey((Plugin)plugin, "pose");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onArmorStandSpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            armorStand.setArms(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onArmorStandClick(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ArmorStand)) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        if (!event.getPlayer().isSneaking()) {
            return;
        }
        ArmorStandPose pose = this.getPose(armorStand);
        ArmorStandPose[] poses = ArmorStandPose.values();
        int nextIndex = (pose.ordinal() + 1) % poses.length;
        ArmorStandPose nextPose = poses[nextIndex];
        this.setPose(armorStand, nextPose);
        event.setCancelled(true);
    }

    private ArmorStandPose getPose(@NotNull ArmorStand armorStand) {
        String poseData = (String)armorStand.getPersistentDataContainer().get(this.poseKey, PersistentDataType.STRING);
        return poseData != null ? ArmorStandPose.valueOf(poseData) : ArmorStandPose.DEFAULT;
    }

    private void setPose(@NotNull ArmorStand armorStand, @NotNull ArmorStandPose pose) {
        armorStand.getPersistentDataContainer().set(this.poseKey, PersistentDataType.STRING, (Object)pose.name());
        armorStand.setBodyPose(pose.body);
        armorStand.setHeadPose(pose.head);
        armorStand.setLeftArmPose(pose.leftArm);
        armorStand.setLeftLegPose(pose.leftLeg);
        armorStand.setRightArmPose(pose.rightArm);
        armorStand.setRightLegPose(pose.rightLeg);
    }
}

