/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.annotation.ConfigValue;
import java.lang.reflect.Field;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class PluginModule
implements Listener {
    protected final String name = this.getClass().getAnnotation(ConfigModule.class).path();
    protected final JavaPlugin plugin;
    protected boolean enabled;

    protected PluginModule(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.enabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        FileConfiguration config = this.plugin.getConfig();
        ComponentLogger logger = this.plugin.getComponentLogger();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigValue.class)) continue;
            ConfigValue annotation = field.getAnnotation(ConfigValue.class);
            String path = "modules." + this.name + "." + annotation.path();
            try {
                field.setAccessible(true);
                Object value = config.get(path, field.get(this));
                field.set(this, value);
            }
            catch (Exception exception) {
                logger.warn("failed to inject config value for {}: {}", (Object)field.getName(), (Object)exception.getMessage());
            }
            finally {
                field.setAccessible(false);
            }
        }
        if (config.getBoolean("modules." + this.name + ".enabled", false)) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        this.plugin.getComponentLogger().info((Component)Component.text((String)(this.name + " enabled"), (TextColor)NamedTextColor.GREEN));
        if (!this.enabled) {
            this.enabled = true;
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
    }

    public void disable() {
        this.plugin.getComponentLogger().info((Component)Component.text((String)(this.name + " disabled"), (TextColor)NamedTextColor.RED));
        if (this.enabled) {
            this.enabled = false;
            HandlerList.unregisterAll((Listener)this);
        }
    }
}

