/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.data;

import com.uravgcode.survivalunlocked.SurvivalUnlocked;
import java.io.IOException;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public final class BlockDataContainer
implements PersistentDataContainer {
    private final NamespacedKey key;
    private final PersistentDataContainer blockDataContainer;
    private final PersistentDataContainer chunkDataContainer;

    public BlockDataContainer(@NotNull Block block) {
        this(block.getLocation());
    }

    public BlockDataContainer(@NotNull Location location) {
        int x = location.getBlockX() & 0xF;
        int y = location.getBlockY();
        int z = location.getBlockZ() & 0xF;
        this.key = new NamespacedKey((Plugin)SurvivalUnlocked.instance(), "x" + x + "_y" + y + "_z" + z);
        this.chunkDataContainer = location.getChunk().getPersistentDataContainer();
        this.blockDataContainer = this.chunkDataContainer.has(this.key, PersistentDataType.TAG_CONTAINER) ? (PersistentDataContainer)this.chunkDataContainer.get(this.key, PersistentDataType.TAG_CONTAINER) : this.chunkDataContainer.getAdapterContext().newPersistentDataContainer();
    }

    public <P, C> void set(@NotNull NamespacedKey key, @NotNull PersistentDataType<P, C> type, @NotNull C value) {
        this.blockDataContainer.set(key, type, value);
        this.chunkDataContainer.set(this.key, PersistentDataType.TAG_CONTAINER, (Object)this.blockDataContainer);
    }

    public void remove(@NotNull NamespacedKey key) {
        this.blockDataContainer.remove(key);
        if (this.blockDataContainer.isEmpty()) {
            this.chunkDataContainer.remove(this.key);
        } else {
            this.chunkDataContainer.set(this.key, PersistentDataType.TAG_CONTAINER, (Object)this.blockDataContainer);
        }
    }

    public void readFromBytes(byte @NotNull [] bytes, boolean clear) throws IOException {
        this.blockDataContainer.readFromBytes(bytes, clear);
        if (this.blockDataContainer.isEmpty()) {
            this.chunkDataContainer.remove(this.key);
        } else {
            this.chunkDataContainer.set(this.key, PersistentDataType.TAG_CONTAINER, (Object)this.blockDataContainer);
        }
    }

    public <P, C> boolean has(@NotNull NamespacedKey key, @NotNull PersistentDataType<P, C> type) {
        return this.blockDataContainer.has(key, type);
    }

    public boolean has(@NotNull NamespacedKey key) {
        return this.blockDataContainer.has(key);
    }

    public <P, C> @Nullable C get(@NotNull NamespacedKey key, @NotNull PersistentDataType<P, C> type) {
        return (C)this.blockDataContainer.get(key, type);
    }

    public <P, C> C getOrDefault(@NotNull NamespacedKey key, @NotNull PersistentDataType<P, C> type, C defaultValue) {
        return (C)this.blockDataContainer.getOrDefault(key, type, defaultValue);
    }

    @NotNull
    public Set<NamespacedKey> getKeys() {
        return this.blockDataContainer.getKeys();
    }

    public boolean isEmpty() {
        return this.blockDataContainer.isEmpty();
    }

    public void copyTo(@NotNull PersistentDataContainer other, boolean replace) {
        this.blockDataContainer.copyTo(other, replace);
    }

    @NotNull
    public PersistentDataAdapterContext getAdapterContext() {
        return this.blockDataContainer.getAdapterContext();
    }

    public byte @NotNull [] serializeToBytes() throws IOException {
        return this.blockDataContainer.serializeToBytes();
    }

    public int getSize() {
        return this.blockDataContainer.getSize();
    }
}

