/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.update;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ConfigUpdater {
    private final JavaPlugin plugin;

    public ConfigUpdater(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void updateConfigs() {
        String configVersion;
        String pluginVersion = this.plugin.getPluginMeta().getVersion();
        if (!pluginVersion.equals(configVersion = this.plugin.getConfig().getString("config.version", "0.0.0"))) {
            this.updateResource("config.yml");
            this.updateResource("heads.yml");
            this.plugin.reloadConfig();
        }
    }

    private void updateResource(@NotNull String filename) {
        ComponentLogger logger = this.plugin.getComponentLogger();
        Path dataPath = this.plugin.getDataPath();
        Path configPath = dataPath.resolve(filename);
        Path backupPath = dataPath.resolve("backups").resolve(filename);
        try (InputStream resourceStream = Objects.requireNonNull(this.plugin.getResource(filename));){
            YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)configPath.toFile());
            YamlConfiguration updatedConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resourceStream));
            for (String key : currentConfig.getKeys(true)) {
                Object value;
                if (key.startsWith("config") || (value = currentConfig.get(key)) == null || value instanceof ConfigurationSection || !updatedConfig.contains(key) || updatedConfig.isConfigurationSection(key)) continue;
                updatedConfig.set(key, value);
            }
            Files.createDirectories(backupPath.getParent(), new FileAttribute[0]);
            Files.move(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            updatedConfig.save(configPath.toFile());
            logger.info("successfully updated {}", (Object)filename);
        }
        catch (IOException exception) {
            logger.warn("failed to update {}: {}", (Object)filename, (Object)exception.getMessage());
        }
    }
}

