/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.smoothsleeptransition;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.annotation.ConfigValue;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="smooth-sleep-transition")
public final class SmoothSleepTransitionModule
extends PluginModule {
    private static final long DAY_LENGTH = 24000L;
    @ConfigValue(path="time-rate")
    private long timeRate = 120L;
    private final Map<World, ScheduledTask> nightSkipTasks = new HashMap<World, ScheduledTask>();

    public SmoothSleepTransitionModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onPlayerSleep(PlayerDeepSleepEvent event) {
        this.updateNightSkipState(event.getPlayer().getWorld());
    }

    @EventHandler
    public void onBedLeave(PlayerBedLeaveEvent event) {
        this.updateNightSkipState(event.getPlayer().getWorld());
    }

    @EventHandler
    public static void onTimeSkip(TimeSkipEvent event) {
        if (event.getSkipReason() == TimeSkipEvent.SkipReason.NIGHT_SKIP) {
            event.setCancelled(true);
        }
    }

    private void updateNightSkipState(@NotNull World world) {
        this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, task -> {
            boolean isNightSkipping = this.nightSkipTasks.containsKey(world);
            boolean sleepingPercentageMet = this.playersSleepingPercentageMet(world);
            if (!isNightSkipping && sleepingPercentageMet) {
                this.startNightSkip(world);
            } else if (isNightSkipping && !sleepingPercentageMet) {
                this.stopNightSkip(world);
            }
        }, 1L);
    }

    private boolean playersSleepingPercentageMet(@NotNull World world) {
        Integer gameRuleValue = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
        double sleepingPercentage = (double)Objects.requireNonNullElse(gameRuleValue, 100).intValue() / 100.0;
        int total = 0;
        int sleeping = 0;
        for (Player player : world.getPlayers()) {
            if (player.isSleepingIgnored()) continue;
            if (player.isSleeping()) {
                ++sleeping;
            }
            ++total;
        }
        return (double)sleeping >= (double)total * sleepingPercentage;
    }

    private void startNightSkip(@NotNull World world) {
        ScheduledTask nightSkipTask = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            long time = world.getTime();
            if (time <= 24000L && time + this.timeRate >= 24000L) {
                world.setTime(0L);
                this.stopNightSkip(world);
                return;
            }
            world.setTime(time + this.timeRate);
        }, 1L, 1L);
        this.nightSkipTasks.put(world, nightSkipTask);
    }

    private void stopNightSkip(@NotNull World world) {
        ScheduledTask task = this.nightSkipTasks.remove(world);
        if (task != null) {
            task.cancel();
        }
    }
}

