/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.silktouchpaintings;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.datacomponent.DataComponentTypes;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="silk-touch-paintings")
public final class SilkTouchPaintingsModule
extends PluginModule {
    public SilkTouchPaintingsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPaintingBreak(HangingBreakByEntityEvent event) {
        Hanging hanging = event.getEntity();
        if (!(hanging instanceof Painting)) {
            return;
        }
        Painting painting = (Painting)hanging;
        Entity remover = event.getRemover();
        if (!(remover instanceof Player)) {
            return;
        }
        Player player = (Player)remover;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (!itemInHand.containsEnchantment(Enchantment.SILK_TOUCH)) {
            return;
        }
        ItemStack item = ItemStack.of((Material)Material.PAINTING);
        item.setData(DataComponentTypes.PAINTING_VARIANT, (Object)painting.getArt());
        painting.remove();
        painting.getWorld().dropItemNaturally(painting.getLocation(), item);
    }
}

