/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.keepbabyanimals;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="keep-baby-animals")
public final class KeepBabyAnimalsModule
extends PluginModule {
    public KeepBabyAnimalsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Breedable)) {
            return;
        }
        Breedable breedable = (Breedable)entity;
        if (breedable.isAdult()) {
            return;
        }
        if (breedable.getAgeLock()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.POISONOUS_POTATO) {
            return;
        }
        breedable.playHurtAnimation(0.0f);
        breedable.getWorld().spawnParticle(Particle.ENTITY_EFFECT, breedable.getEyeLocation(), 8, 0.15, 0.15, 0.15, 0.0, (Object)Color.fromRGB((int)5149489));
        breedable.getWorld().playSound(breedable.getLocation(), Sound.ENTITY_DONKEY_EAT, 1.0f, 1.0f);
        breedable.setAgeLock(true);
        if (player.getGameMode() != GameMode.CREATIVE) {
            item.subtract();
        }
    }
}

