/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.update;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class UpdateChecker {
    private final JavaPlugin plugin;
    private final HttpClient httpClient;
    private final HttpRequest httpRequest;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        URI uri = URI.create("https://api.github.com/repos/UrAvgCode/modern-essentials/releases/latest");
        Duration timeout = Duration.ofSeconds(5L);
        this.httpClient = HttpClient.newBuilder().connectTimeout(timeout).build();
        this.httpRequest = HttpRequest.newBuilder().uri(uri).timeout(timeout).header("Accept", "application/vnd.github+json").GET().build();
    }

    public CompletableFuture<ComparableVersion> fetchLatestVersion() {
        return this.httpClient.sendAsync(this.httpRequest, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            JsonObject json = JsonParser.parseString((String)((String)response.body())).getAsJsonObject();
            String tagName = json.get("tag_name").getAsString();
            return new ComparableVersion(tagName);
        });
    }

    public void checkForUpdate() {
        try {
            ComponentLogger logger = this.plugin.getComponentLogger();
            ComparableVersion version = new ComparableVersion(this.plugin.getPluginMeta().getVersion());
            ComparableVersion latestVersion = this.fetchLatestVersion().get();
            if (latestVersion.compareTo(version) > 0) {
                logger.info((Component)Component.text((String)("A new version is available: " + String.valueOf(latestVersion)), (TextColor)NamedTextColor.GREEN));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendVersionInfo(Audience audience) {
        audience.sendMessage(Component.text((String)"Checking version, please wait...").decorate(TextDecoration.ITALIC));
        ComparableVersion version = new ComparableVersion(this.plugin.getPluginMeta().getVersion());
        ((CompletableFuture)this.fetchLatestVersion().thenAccept(latestVersion -> {
            audience.sendMessage(Component.text((String)"modern-essentials version: ").append((Component)Component.text((String)version.toString(), (TextColor)NamedTextColor.GREEN)));
            int comparison = latestVersion.compareTo(version);
            if (comparison == 0) {
                audience.sendMessage((Component)Component.text((String)"You are running the latest version", (TextColor)NamedTextColor.GREEN));
            } else if (comparison > 0) {
                audience.sendMessage(Component.text((String)"Latest version: ").append((Component)Component.text((String)latestVersion.toString(), (TextColor)NamedTextColor.GREEN)));
                audience.sendMessage(((TextComponent)Component.text((String)"Download: ").append(Component.text((String)"Github", (TextColor)TextColor.color((int)5858158)).clickEvent(ClickEvent.openUrl((String)"https://github.com/UrAvgCode/modern-essentials/releases")))).append(Component.text((String)" Modrinth", (TextColor)TextColor.color((int)1825130)).clickEvent(ClickEvent.openUrl((String)"https://modrinth.com/plugin/modern-essentials/version/latest"))));
            } else {
                audience.sendMessage(Component.text((String)"Latest version: ").append((Component)Component.text((String)latestVersion.toString(), (TextColor)NamedTextColor.GREEN)));
                audience.sendMessage((Component)Component.text((String)"You are running a newer version than the latest release", (TextColor)NamedTextColor.RED));
            }
        })).exceptionally(throwable -> {
            audience.sendMessage(Component.text((String)"modern-essentials version: ").append((Component)Component.text((String)version.toString(), (TextColor)NamedTextColor.GREEN)));
            audience.sendMessage((Component)Component.text((String)"Failed to fetch latest version", (TextColor)NamedTextColor.RED));
            return null;
        });
    }
}

