/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.annotation.ConfigValue;
import com.uravgcode.modernessentials.event.home.DelHomeEvent;
import com.uravgcode.modernessentials.event.home.HomeEvent;
import com.uravgcode.modernessentials.event.home.SetHomeEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
@CommandModule(name="home")
public final class HomeModule
extends PluginModule {
    private static final Map<UUID, NavigableMap<String, Location>> homes = new ConcurrentHashMap<UUID, NavigableMap<String, Location>>();
    private final File file;
    @ConfigValue(path="homes.default-limit")
    private int defaultLimit = 3;

    public HomeModule(JavaPlugin plugin) {
        super(plugin);
        this.file = plugin.getDataPath().resolve("homes.yml").toFile();
    }

    public static NavigableMap<String, Location> getHomes(UUID uuid) {
        NavigableMap<String, Location> playerHomes = homes.get(uuid);
        return playerHomes == null ? Collections.emptyNavigableMap() : Collections.unmodifiableNavigableMap(playerHomes);
    }

    @Override
    public void reload() {
        super.reload();
        homes.clear();
        ComponentLogger logger = this.plugin.getComponentLogger();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.file);
        for (String uuidString : config.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                ConfigurationSection section = config.getConfigurationSection(uuidString);
                if (section == null) continue;
                ConcurrentSkipListMap<String, Location> playerHomes = new ConcurrentSkipListMap<String, Location>(String.CASE_INSENSITIVE_ORDER);
                for (String name : section.getKeys(false)) {
                    Location location = section.getLocation(name);
                    if (location != null) {
                        playerHomes.put(name, location);
                        continue;
                    }
                    logger.warn("Home '{}' for player {} does not contain a valid location", (Object)name, (Object)uuidString);
                }
                homes.put(uuid, playerHomes);
            }
            catch (IllegalArgumentException exception) {
                logger.warn("Invalid UUID in homes.yml: {}", (Object)uuidString);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHome(HomeEvent event) {
        Player player = event.getPlayer();
        String name = event.getName();
        NavigableMap<String, Location> playerHomes = homes.get(player.getUniqueId());
        if (playerHomes == null) {
            player.sendMessage((Component)Component.text((String)"Home not found", (TextColor)NamedTextColor.RED));
            return;
        }
        Location location = (Location)playerHomes.get(name);
        if (location != null) {
            player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            player.sendMessage((Component)Component.text((String)"Home not found", (TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSetHome(SetHomeEvent event) {
        Player player = event.getPlayer();
        String name = event.getName();
        Location location = player.getLocation();
        NavigableMap playerHomes = homes.computeIfAbsent(player.getUniqueId(), uuid -> new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER));
        if (playerHomes.size() >= this.defaultLimit && !playerHomes.containsKey(name)) {
            player.sendMessage((Component)Component.text((String)"Home limit reached", (TextColor)NamedTextColor.RED));
            return;
        }
        if (playerHomes.put(name, location) == null) {
            player.sendMessage("Home created");
        } else {
            player.sendMessage("Home set");
        }
        this.saveHomes();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDelHome(DelHomeEvent event) {
        Player player = event.getPlayer();
        String name = event.getName();
        NavigableMap<String, Location> playerHomes = homes.get(player.getUniqueId());
        if (playerHomes != null && playerHomes.remove(name) != null) {
            player.sendMessage("Home deleted");
            this.saveHomes();
        } else {
            player.sendMessage((Component)Component.text((String)"Home not found", (TextColor)NamedTextColor.RED));
        }
    }

    private void saveHomes() {
        Map<UUID, NavigableMap<String, Location>> snapshot = Map.copyOf(homes);
        CompletableFuture.runAsync(() -> {
            try {
                YamlConfiguration config = new YamlConfiguration();
                snapshot.forEach((uuid, playerHomes) -> {
                    ConfigurationSection playerSection = config.createSection(uuid.toString());
                    playerHomes.forEach((arg_0, arg_1) -> ((ConfigurationSection)playerSection).set(arg_0, arg_1));
                });
                config.save(this.file);
            }
            catch (IOException exception) {
                this.plugin.getComponentLogger().error("Could not save homes.yml", (Throwable)exception);
            }
        });
    }
}

