/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.world.chunk.LightData;
import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.event.FullBrightEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
@NullMarked
@CommandModule(name="fullbright")
public final class FullBrightModule
extends PluginModule
implements PacketListener {
    public final NamespacedKey fullBrightKey;
    private final Set<UUID> fullBrightPlayers;
    private final PacketListenerCommon packetListener;
    private final LightData lightData;

    public FullBrightModule(JavaPlugin plugin) {
        super(plugin);
        this.fullBrightKey = new NamespacedKey((Plugin)plugin, "fullbright");
        this.fullBrightPlayers = ConcurrentHashMap.newKeySet();
        this.packetListener = this.asAbstract(PacketListenerPriority.HIGH);
        int lightCount = 24;
        byte[] fullBrightSection = new byte[2048];
        Arrays.fill(fullBrightSection, (byte)-1);
        byte[][] lightArray = new byte[24][];
        for (int i = 0; i < 24; ++i) {
            lightArray[i] = (byte[])fullBrightSection.clone();
        }
        BitSet lightMask = new BitSet(24);
        lightMask.set(0, 24);
        BitSet emptyLightMask = new BitSet(24);
        this.lightData = new LightData(true, lightMask, lightMask, emptyLightMask, emptyLightMask, 24, 24, (byte[][])lightArray, (byte[][])lightArray);
    }

    @Override
    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            PacketEvents.getAPI().getEventManager().registerListener(this.packetListener);
        }
    }

    @Override
    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            HandlerList.unregisterAll((Listener)this);
            PacketEvents.getAPI().getEventManager().unregisterListener(this.packetListener);
        }
    }

    /*
     * Exception decompiling
     */
    public void onPacketSend(PacketSendEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=1,404
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFullBright(FullBrightEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (dataContainer.has(this.fullBrightKey)) {
            this.fullBrightPlayers.remove(uuid);
            dataContainer.remove(this.fullBrightKey);
            player.sendMessage((Component)Component.text((String)"Fullbright disabled", (TextColor)NamedTextColor.RED));
        } else {
            this.fullBrightPlayers.add(uuid);
            dataContainer.set(this.fullBrightKey, PersistentDataType.BYTE, (Object)1);
            player.sendMessage((Component)Component.text((String)"Fullbright enabled", (TextColor)NamedTextColor.GREEN));
        }
        this.sendLightUpdates(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getPersistentDataContainer().has(this.fullBrightKey) && player.hasPermission("essentials.fullbright")) {
            this.fullBrightPlayers.add(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.fullBrightPlayers.remove(event.getPlayer().getUniqueId());
    }

    private void sendLightUpdates(Player player) {
        World world;
        CraftPlayer craftPlayer;
        block4: {
            block3: {
                if (!(player instanceof CraftPlayer)) break block3;
                craftPlayer = (CraftPlayer)player;
                world = player.getWorld();
                if (world instanceof CraftWorld) break block4;
            }
            return;
        }
        CraftWorld craftWorld = (CraftWorld)world;
        LevelLightEngine lightEngine = craftWorld.getHandle().getLightEngine();
        for (Long chunkKey : player.getSentChunkKeys()) {
            ChunkPos chunkPosition = new ChunkPos(chunkKey.longValue());
            ClientboundLightUpdatePacket packet = new ClientboundLightUpdatePacket(chunkPosition, lightEngine, null, null);
            craftPlayer.getHandle().connection.send((Packet)packet);
        }
    }
}

