/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.event.BackEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
@CommandModule(name="back")
public final class BackModule
extends PluginModule {
    private final Map<UUID, Deque<Location>> locations = new ConcurrentHashMap<UUID, Deque<Location>>();

    public BackModule(JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.COMMAND) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Deque deque = this.locations.computeIfAbsent(uuid, id -> new ArrayDeque());
        deque.push(event.getFrom().clone());
        if (deque.size() > 10) {
            deque.removeLast();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBack(BackEvent event) {
        Player player = event.getPlayer();
        Deque<Location> stack = this.locations.get(player.getUniqueId());
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Location location = stack.pop();
        player.teleportAsync(location);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.locations.remove(event.getPlayer().getUniqueId());
    }
}

