/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.command.CommandBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class WorldCommand
implements CommandBuilder {
    @Override
    public LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"world").requires(this.permission("essentials.world"))).then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes(this::execute))).build();
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Player player = this.player(context);
        World targetWorld = (World)context.getArgument("world", World.class);
        Location location = player.getLocation();
        World.Environment targetEnvironment = targetWorld.getEnvironment();
        World.Environment currentEnvironment = player.getWorld().getEnvironment();
        location.setWorld(targetWorld);
        if (currentEnvironment == World.Environment.NETHER && targetEnvironment == World.Environment.NORMAL) {
            location.setX(location.getX() * 8.0);
            location.setZ(location.getZ() * 8.0);
        } else if (currentEnvironment == World.Environment.NORMAL && targetEnvironment == World.Environment.NETHER) {
            location.setX(location.getX() / 8.0);
            location.setZ(location.getZ() / 8.0);
        }
        player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND);
        player.sendMessage((Component)Component.translatable((String)"commands.teleport.success.entity.single", (ComponentLike[])new ComponentLike[]{player.name(), Component.text((String)targetWorld.getName())}));
        return 1;
    }
}

