/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.argument.TpaPlayerArgument;
import com.uravgcode.modernessentials.command.CommandBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class TpaCommand
implements CommandBuilder {
    @Override
    public LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpa").requires(this.permission("essentials.tpa"))).then(Commands.argument((String)"target", (ArgumentType)new TpaPlayerArgument()).executes(this::execute))).build();
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Player player = this.player(context);
        Player target = (Player)context.getArgument("target", Player.class);
        ClickCallback.Options options = (ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofSeconds(60L)).uses(1).build();
        TextComponent message = Component.textOfChildren((ComponentLike[])new ComponentLike[]{player.name(), Component.text((String)" has requested to teleport to you "), ((TextComponent)Component.text((String)"[Accept]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.callback(audience -> {
            TranslatableComponent teleportMessage = Component.translatable((String)"commands.teleport.success.entity.single", (ComponentLike[])new ComponentLike[]{player.name(), target.name()});
            player.teleportAsync(target.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
            player.sendMessage((Component)teleportMessage);
            target.sendMessage((Component)teleportMessage);
        }, (ClickCallback.Options)options))).hoverEvent((HoverEventSource)Component.translatable((String)"Click to accept")), Component.newline(), Component.text((String)"This request will expire in 60 seconds", (TextColor)NamedTextColor.GRAY)});
        target.sendMessage((Component)message);
        player.sendMessage(Component.text((String)"Teleport request sent to ").append(target.name()));
        return 1;
    }
}

