/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.uravgcode.modernessentials.argument.OtherPlayerArgument;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class TpaPlayerArgument
extends OtherPlayerArgument {
    private static final SimpleCommandExceptionType INVALID_TARGET = new SimpleCommandExceptionType(() -> "Target cannot accept teleport requests");

    @Override
    public <S> Player parse(StringReader reader, S source) throws CommandSyntaxException {
        Player target = super.parse(reader, source);
        if (!target.hasPermission("essentials.tpa.accept")) {
            throw INVALID_TARGET.create();
        }
        return target;
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return super.listSuggestions(context, builder).thenApply(suggestions -> {
            suggestions.getList().removeIf(suggestion -> {
                Player player = Bukkit.getPlayerExact((String)suggestion.getText());
                return player != null && !player.hasPermission("essentials.tpa.accept");
            });
            return suggestions;
        });
    }
}

