/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.uravgcode.modernessentials.manager.ModuleManager;
import com.uravgcode.modernessentials.update.ConfigUpdater;
import com.uravgcode.modernessentials.update.UpdateChecker;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ModernEssentials
extends JavaPlugin {
    private static ModernEssentials instance = null;
    private ConfigUpdater configUpdater = null;
    private ModuleManager moduleManager = null;

    @NotNull
    public static ModernEssentials instance() {
        return Objects.requireNonNull(instance, "plugin not initialized");
    }

    public void onLoad() {
        instance = this;
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().reEncodeByDefault(false).checkForUpdates(false);
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PacketEvents.getAPI().init();
        new UpdateChecker(this).checkForUpdate();
        this.configUpdater = new ConfigUpdater(this);
        this.moduleManager = new ModuleManager(this);
        this.reload();
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }

    public void reload() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.configUpdater.updateConfig();
        this.moduleManager.reloadModules();
    }
}

